/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.cm.actions;

import com.arcway.lib.graphics.Alignment;
import com.arcway.planagent.planeditor.FMCAPlanEditorCommonPlugin;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planeditor.cm.Messages;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.TextAppearanceTpl;
import de.plans.lib.eclipse.ResourceLoader;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;

public class TextAlignmentDecoration
implements IAppearanceButtonDecorationWithMenu {
    private static final String[][] descriptions = new String[][]{{Messages.getString("TextAlignmentDecoration.top_left"), Messages.getString("TextAlignmentDecoration.top_center"), Messages.getString("TextAlignmentDecoration.top_right")}, {Messages.getString("TextAlignmentDecoration.middle_left"), Messages.getString("TextAlignmentDecoration.middle_center"), Messages.getString("TextAlignmentDecoration.middle_right")}, {Messages.getString("TextAlignmentDecoration.bottom_left"), Messages.getString("TextAlignmentDecoration.bottom_center"), Messages.getString("TextAlignmentDecoration.bottom_right")}};
    private static final ImageDescriptor[][] imagesDescriptors = new ImageDescriptor[][]{{TextAlignmentDecoration.createImageDescriptor(1, 8), TextAlignmentDecoration.createImageDescriptor(2, 8), TextAlignmentDecoration.createImageDescriptor(4, 8)}, {TextAlignmentDecoration.createImageDescriptor(1, 16), TextAlignmentDecoration.createImageDescriptor(2, 16), TextAlignmentDecoration.createImageDescriptor(4, 16)}, {TextAlignmentDecoration.createImageDescriptor(1, 32), TextAlignmentDecoration.createImageDescriptor(2, 32), TextAlignmentDecoration.createImageDescriptor(4, 32)}};
    private static TextAlignmentDecoration singelton;

    private static String getDescription(Alignment alignment) {
        return descriptions[TextAlignmentDecoration.getIndexY(alignment.v)][TextAlignmentDecoration.getIndexX(alignment.h)];
    }

    private static ImageDescriptor getImageDescriptor(Alignment alignment) {
        return imagesDescriptors[TextAlignmentDecoration.getIndexY(alignment.v)][TextAlignmentDecoration.getIndexX(alignment.h)];
    }

    private static int getIndexY(int alignV) {
        int v;
        switch (alignV) {
            case 8: {
                v = 0;
                break;
            }
            case 32: {
                v = 2;
                break;
            }
            default: {
                v = 1;
            }
        }
        return v;
    }

    private static int getIndexX(int alignH) {
        int h;
        switch (alignH) {
            case 1: {
                h = 0;
                break;
            }
            case 4: {
                h = 2;
                break;
            }
            default: {
                h = 1;
            }
        }
        return h;
    }

    private static ImageDescriptor createImageDescriptor(int alignH, int alignV) {
        ImageDescriptor descriptor = ResourceLoader.getImageDescriptor((String)("cm/" + TextAlignmentDecoration.getImageFileName(alignH, alignV)), (Plugin)FMCAPlanEditorCommonPlugin.getDefault());
        return descriptor;
    }

    private static String getImageFileName(int alignH, int alignV) {
        String v;
        String h;
        switch (alignH) {
            case 1: {
                h = "l";
                break;
            }
            case 4: {
                h = "r";
                break;
            }
            default: {
                h = "c";
            }
        }
        switch (alignV) {
            case 8: {
                v = "t";
                break;
            }
            case 32: {
                v = "b";
                break;
            }
            default: {
                v = "c";
            }
        }
        return "textalign_" + v + h + ".gif";
    }

    private static Alignment toAlignment(Object state) {
        return (Alignment)state;
    }

    private static ITextAppearanceTpl toTemplate(Alignment alignment) {
        TextAppearanceTpl template = new TextAppearanceTpl();
        template.setAlignment(alignment);
        return template;
    }

    private TextAlignmentDecoration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextAlignmentDecoration getInstance() {
        Class<TextAlignmentDecoration> clazz = TextAlignmentDecoration.class;
        synchronized (TextAlignmentDecoration.class) {
            if (singelton == null) {
                singelton = new TextAlignmentDecoration();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singelton;
        }
    }

    public Class[] getAppearanceClasses() {
        return new Class[]{ITextAppearanceRO.class};
    }

    public Object getStateOfAppearance(IAppearanceRO appearance) {
        return ((ITextAppearanceRO)appearance).getAlignment();
    }

    public String getToolTipText(Object state) {
        return TextAlignmentDecoration.getDescription(TextAlignmentDecoration.toAlignment(state));
    }

    public ImageDescriptor getButtonImageDescriptor(Object state) {
        return TextAlignmentDecoration.getImageDescriptor(TextAlignmentDecoration.toAlignment(state));
    }

    public ImageDescriptor getMenuEntryImage(Object state) {
        return TextAlignmentDecoration.getImageDescriptor(TextAlignmentDecoration.toAlignment(state));
    }

    public String getMenuEntryText(Object state) {
        return TextAlignmentDecoration.getDescription(TextAlignmentDecoration.toAlignment(state));
    }

    public IAppearanceTpl[] getAppearanceTemplates(Object state) {
        return new IAppearanceTpl[]{TextAlignmentDecoration.toTemplate(TextAlignmentDecoration.toAlignment(state))};
    }
}

