/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.cm.actions;

import com.arcway.planagent.planeditor.actions.AppearanceUtil;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planeditor.actions.MenuContributionItem;
import com.arcway.planagent.planeditor.actions.UIChangeAppearanceAction;
import com.arcway.planagent.planeditor.cm.actions.CITextSizeConstantsAndMaps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchPage;

public class CITextSize
extends MenuContributionItem {
    private Map<String, Double> extraSizeMaps = new HashMap<String, Double>();

    public CITextSize() {
    }

    public CITextSize(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    protected IAppearanceButtonDecoration getButtonType() {
        return CITextSizeConstantsAndMaps.APPEARANCE_DECORATION;
    }

    private List<IContributionItem> constructContributionItem() {
        boolean checked;
        UIChangeAppearanceAction action;
        String sizeName;
        IWorkbenchPage workbenchPage = this.getWorkbenchPage();
        AppearanceUtil.SelectionInfoProvider currentSelectionInfoOrNull = this.getCurrentSelectionInfoOrNull();
        boolean enabled = this.isActionEnabled(currentSelectionInfoOrNull, CITextSizeConstantsAndMaps.INIT_TEXT_SIZE);
        ArrayList selectedStates = this.getSelectedStates(currentSelectionInfoOrNull);
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        for (String actionID : CITextSizeConstantsAndMaps.sortedFontSizeID) {
            if (!CITextSizeConstantsAndMaps.textSizeMaps.containsKey(actionID)) continue;
            Double size = CITextSizeConstantsAndMaps.textSizeMaps.get(actionID);
            IAppearanceButtonDecoration buttonType = CITextSizeConstantsAndMaps.APPEARANCE_DECORATION;
            sizeName = ((IAppearanceButtonDecorationWithMenu)buttonType).getMenuEntryText((Object)size);
            action = new UIChangeAppearanceAction(workbenchPage, actionID, sizeName, (Object)size, buttonType);
            action.setEnabled(enabled);
            checked = false;
            if (enabled) {
                checked = this.isActionChecked(size, selectedStates);
            }
            action.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
        this.checkForNewTextSize(selectedStates);
        Set<String> extraSizes = this.extraSizeMaps.keySet();
        if (!extraSizes.isEmpty()) {
            items.add((IContributionItem)new Separator());
        }
        for (String actionID : extraSizes) {
            Double size = this.extraSizeMaps.get(actionID);
            sizeName = ((IAppearanceButtonDecorationWithMenu)CITextSizeConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryText((Object)size);
            action = new UIChangeAppearanceAction(workbenchPage, actionID, sizeName, (Object)size, CITextSizeConstantsAndMaps.APPEARANCE_DECORATION);
            action.setEnabled(enabled);
            checked = false;
            if (enabled) {
                checked = this.isActionChecked(size, selectedStates);
            }
            action.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
        return items;
    }

    private void checkForNewTextSize(ArrayList<Object> selectedStates) {
        this.extraSizeMaps = new HashMap<String, Double>();
        for (Object state : selectedStates) {
            Double size;
            if (!(state instanceof Double) || !this.isNewTextSize(size = (Double)state)) continue;
            String actionID = "com.arcway.cockpitplanagent.editor.actions.fontSize" + size.toString();
            this.extraSizeMaps.put(actionID, size);
        }
    }

    private boolean isNewTextSize(Double state) {
        boolean newState = true;
        for (Double size : CITextSizeConstantsAndMaps.textSizeMaps.values()) {
            if (!size.equals(state)) continue;
            newState = false;
            break;
        }
        return newState;
    }

    private boolean isActionChecked(Double size, ArrayList<Object> selectedStates) {
        boolean checked = false;
        for (Object state : selectedStates) {
            Double selectedSize;
            if (state instanceof Double && (checked = size.equals(selectedSize = (Double)state))) break;
        }
        return checked;
    }

    protected IContributionItem[] getContributionItems() {
        List<IContributionItem> items = this.constructContributionItem();
        IContributionItem[] colorItems = items.toArray(new IContributionItem[items.size()]);
        return colorItems;
    }
}

