/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.controllinginterface.planviewer;

import com.arcway.lib.geometry.Insets;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.java.To;

public class PageSetup {
    private int pageCountX;
    private int pageCountY;
    private double zoom;
    private Alignment alignment;
    private boolean fitHorizontally;
    private boolean fitVertically;
    private double offsetXInMM;
    private double offsetYInMM;
    private Insets margin = null;

    public PageSetup(int pageCountX, int pageCountY, Alignment alignment, double zoom, boolean fitH, boolean fitV, Insets margin) {
        this(pageCountX, pageCountY, alignment, zoom, fitH, fitV, margin, 0.0, 0.0);
    }

    public PageSetup(int pageCountX, int pageCountY, Alignment alignment, double zoom, boolean fitH, boolean fitV, Insets margin, double offsetXInMM, double offsetYInMM) {
        assert (pageCountX >= 0 && pageCountY >= 0) : "PrinterConfig: pageCount must be bigger than 0";
        assert (zoom > -1.0E-10) : "PrinterConfig: zoom must be bigger than 0";
        this.setPageCountX(pageCountX);
        this.setPageCountY(pageCountY);
        if (alignment != null) {
            this.setAlignment(alignment);
        } else {
            this.setAlignment(new Alignment(1, 8));
        }
        this.setZoom(zoom);
        this.setFitHorizontally(fitH);
        this.setFitVertically(fitV);
        this.setMargin(margin);
        this.setOffsetXInMM(offsetXInMM);
        this.setOffsetYInMM(offsetYInMM);
    }

    public PageSetup(PageSetup copyFrom) {
        this.alignment = new Alignment(copyFrom.alignment);
        this.fitHorizontally = copyFrom.fitHorizontally;
        this.fitVertically = copyFrom.fitVertically;
        this.margin = new Insets(copyFrom.margin);
        this.pageCountX = copyFrom.pageCountX;
        this.pageCountY = copyFrom.pageCountY;
        this.zoom = copyFrom.zoom;
        this.offsetXInMM = copyFrom.offsetXInMM;
        this.offsetYInMM = copyFrom.offsetYInMM;
    }

    public int getPageCountX() {
        return this.pageCountX;
    }

    public void setPageCountX(int pageCountX) {
        assert (pageCountX >= 0);
        this.pageCountX = pageCountX;
    }

    public int getPageCountY() {
        return this.pageCountY;
    }

    public void setPageCountY(int pageCountY) {
        assert (pageCountY >= 0);
        this.pageCountY = pageCountY;
    }

    public void setOffsetXInMM(double offsetXInMM) {
        this.offsetXInMM = offsetXInMM;
    }

    public void setOffsetYInMM(double offsetYInMM) {
        this.offsetYInMM = offsetYInMM;
    }

    public double getOffsetXInMM() {
        return this.offsetXInMM;
    }

    public double getOffsetYInMM() {
        return this.offsetYInMM;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = new Alignment(alignment);
    }

    public boolean isFitHorizontally() {
        return this.fitHorizontally;
    }

    public void setFitHorizontally(boolean fitHorizontally) {
        this.fitHorizontally = fitHorizontally;
    }

    public boolean isFitVertically() {
        return this.fitVertically;
    }

    public void setFitVertically(boolean fitVertically) {
        this.fitVertically = fitVertically;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = new Insets(margin);
    }

    public int getHorizontalAlignment() {
        return this.getAlignment().h;
    }

    public void setHorizontalAlignment(int i) {
        this.setAlignment(new Alignment(i, this.getAlignment().v));
    }

    public int getVerticalAlignment() {
        return this.getAlignment().v;
    }

    public void setVerticalAlignment(int i) {
        this.setAlignment(new Alignment(this.getAlignment().h, i));
    }

    public String toString() {
        return "PageSetup[\npageCountX=" + this.pageCountX + ", \npageCountY=" + this.pageCountY + ", \nzoom=" + this.zoom + ", \nalignment=" + To.makeNotNull((Object)this.alignment) + ", \nfitHorizontally=" + this.fitHorizontally + ", \nfitVertically=" + this.fitVertically + ", \nmargin=" + To.makeNotNull((Object)this.margin) + "]";
    }
}

