/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.operating;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class PeriodicTaskScheduler {
    private static final ILogger LOGGER = Logger.getLogger(PeriodicTaskScheduler.class);
    private static final String THREAD_NAME = PeriodicTaskScheduler.class.getSimpleName();
    private static final int RUN_INTERVAL_IN_MILISEC = 1000;
    private static Thread scheduleThread;
    private static Set<Runnable> schedulesTasks;

    static {
        schedulesTasks = new HashSet<Runnable>(32);
    }

    private PeriodicTaskScheduler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addScheduledTask(Runnable task) {
        Set<Runnable> set = schedulesTasks;
        synchronized (set) {
            schedulesTasks.add(task);
            PeriodicTaskScheduler.createAndRunNewThreadIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAllScheduledTasks(Collection<Runnable> tasks) {
        Set<Runnable> set = schedulesTasks;
        synchronized (set) {
            schedulesTasks.addAll(tasks);
            PeriodicTaskScheduler.createAndRunNewThreadIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeScheduledTask(Runnable task) {
        Set<Runnable> set = schedulesTasks;
        synchronized (set) {
            schedulesTasks.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllScheduledTasks(Collection<Runnable> tasks) {
        Set<Runnable> set = schedulesTasks;
        synchronized (set) {
            schedulesTasks.removeAll(tasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearScheduledTasks() {
        Set<Runnable> set = schedulesTasks;
        synchronized (set) {
            schedulesTasks.clear();
        }
    }

    private static void createAndRunNewThreadIfNeeded() {
        if (!(scheduleThread != null && scheduleThread.isAlive() || schedulesTasks.size() <= 0)) {
            scheduleThread = new Thread((Runnable)new PeriodicTaskSchedulerRunnable(), THREAD_NAME);
            scheduleThread.start();
        }
    }

    private static class PeriodicTaskSchedulerRunnable
    implements Runnable {
        private boolean doRun = true;

        private PeriodicTaskSchedulerRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Thread started");
            }
            while (this.doRun) {
                Set set = schedulesTasks;
                synchronized (set) {
                    if (schedulesTasks.size() > 0) {
                        for (Runnable singleTask : schedulesTasks) {
                            try {
                                singleTask.run();
                            }
                            catch (Exception e) {
                                LOGGER.error("Error while running scheduled editor task.", (Throwable)e);
                            }
                        }
                    } else {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Thread ended");
                        }
                        return;
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.doRun = false;
                }
            }
        }
    }
}

