/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.xalan;

import com.nwalsh.xalan.Callout;
import com.nwalsh.xalan.FormatCallout;
import com.nwalsh.xalan.FormatDingbatCallout;
import com.nwalsh.xalan.FormatGraphicCallout;
import com.nwalsh.xalan.FormatTextCallout;
import com.nwalsh.xalan.FormatUnicodeCallout;
import com.nwalsh.xalan.Params;
import java.util.Arrays;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xml.utils.DOMBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Verbatim {
    private Stack elementStack = null;
    private Stack tempStack = null;
    private int lineNumber = 0;
    private int colNumber = 0;
    private int modulus = 0;
    private int width = 0;
    private String separator = "";
    private Callout[] callout = null;
    private int calloutCount = 0;
    private int calloutPos = 0;
    private String graphicsPath = null;
    private String graphicsExt = null;
    private int graphicsMax = 10;
    private boolean graphicsFO = false;
    private static final String foURI = "http://www.w3.org/1999/XSL/Format";
    private static final String xhURI = "http://www.w3.org/1999/xhtml";

    public DocumentFragment numberLines(ExpressionContext expressionContext, NodeIterator nodeIterator) {
        int n = Params.getInt((ExpressionContext)expressionContext, (String)"linenumbering.everyNth");
        int n2 = Params.getInt((ExpressionContext)expressionContext, (String)"linenumbering.width");
        String string = Params.getString((ExpressionContext)expressionContext, (String)"linenumbering.separator");
        DocumentFragment documentFragment = (DocumentFragment)nodeIterator.nextNode();
        int n3 = this.countLineBreaks((Node)documentFragment) + 1;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("PCE!");
            return documentFragment;
        }
        Document document = documentBuilder.newDocument();
        DocumentFragment documentFragment2 = document.createDocumentFragment();
        DOMBuilder dOMBuilder = new DOMBuilder(document, documentFragment2);
        this.elementStack = new Stack();
        this.lineNumber = 0;
        this.modulus = n3 < n ? 1 : n;
        this.width = n2;
        this.separator = string;
        double d = Math.log(n3) / Math.log(10.0);
        if ((double)this.width < d + 1.0) {
            this.width = (int)Math.floor(d + 1.0);
        }
        this.lineNumberFragment(dOMBuilder, (Node)documentFragment);
        return documentFragment2;
    }

    private int countLineBreaks(Node node) {
        int n;
        block3: {
            block2: {
                n = 0;
                if (node.getNodeType() != 11 && node.getNodeType() != 9 && node.getNodeType() != 1) break block2;
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    n += this.countLineBreaks(node2);
                }
                break block3;
            }
            if (node.getNodeType() != 3) break block3;
            String string = node.getNodeValue();
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != '\n') continue;
                ++n;
            }
        }
        return n;
    }

    private void lineNumberFragment(DOMBuilder dOMBuilder, Node node) {
        try {
            String string;
            Object object;
            Object object2;
            if (node.getNodeType() == 11 || node.getNodeType() == 9) {
                for (object2 = node.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                    this.lineNumberFragment(dOMBuilder, (Node)object2);
                }
            } else if (node.getNodeType() == 1) {
                object2 = node.getNamespaceURI();
                object = node.getLocalName();
                string = ((Element)node).getTagName();
                dOMBuilder.startElement((String)object2, (String)object, string, this.copyAttributes((Element)node));
                this.elementStack.push(node);
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.lineNumberFragment(dOMBuilder, node2);
                }
            } else if (node.getNodeType() == 3) {
                object2 = node.getNodeValue();
                if (this.lineNumber == 0) {
                    this.formatLineNumber(dOMBuilder, ++this.lineNumber);
                }
                object = ((String)object2).toCharArray();
                int n = 0;
                for (int i = 0; i < ((String)object2).length(); ++i) {
                    if (((String)object2).charAt(i) == '\n') {
                        if (n > 0) {
                            dOMBuilder.characters((char[])object, 0, n);
                            n = 0;
                        }
                        this.closeOpenElements(dOMBuilder);
                        object[n++] = ((String)object2).charAt(i);
                        dOMBuilder.characters((char[])object, 0, n);
                        n = 0;
                        this.formatLineNumber(dOMBuilder, ++this.lineNumber);
                        this.openClosedElements(dOMBuilder);
                        continue;
                    }
                    object[n++] = ((String)object2).charAt(i);
                }
                if (n > 0) {
                    dOMBuilder.characters((char[])object, 0, n);
                }
            } else if (node.getNodeType() == 8) {
                object2 = node.getNodeValue();
                object = ((String)object2).toCharArray();
                dOMBuilder.comment((char[])object, 0, ((String)object2).length());
            } else if (node.getNodeType() == 7) {
                dOMBuilder.processingInstruction(node.getNodeName(), node.getNodeValue());
            } else {
                System.out.println("Warning: unexpected node type in lineNumberFragment");
            }
            if (node.getNodeType() == 1) {
                object2 = node.getNamespaceURI();
                object = node.getLocalName();
                string = ((Element)node).getTagName();
                dOMBuilder.endElement((String)object2, (String)object, string);
                this.elementStack.pop();
            }
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in lineNumberFragment");
        }
    }

    private void formatLineNumber(DOMBuilder dOMBuilder, int n) {
        char c = '\u00a0';
        String string = "";
        if (n == 1 || this.modulus >= 1 && n % this.modulus == 0) {
            string = "" + n;
        }
        while (string.length() < this.width) {
            string = c + string;
        }
        string = string + this.separator;
        char[] cArray = string.toCharArray();
        try {
            dOMBuilder.characters(cArray, 0, string.length());
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in formatLineNumber");
        }
    }

    public DocumentFragment insertCallouts(ExpressionContext expressionContext, NodeIterator nodeIterator, NodeIterator nodeIterator2) {
        String string = Params.getString((ExpressionContext)expressionContext, (String)"stylesheet.result.type");
        boolean bl = string.equals("fo");
        int n = Params.getInt((ExpressionContext)expressionContext, (String)"callout.defaultcolumn");
        if (Params.getBoolean((ExpressionContext)expressionContext, (String)"callout.graphics")) {
            String string2 = Params.getString((ExpressionContext)expressionContext, (String)"callout.graphics.path");
            String string3 = Params.getString((ExpressionContext)expressionContext, (String)"callout.graphics.extension");
            int n2 = Params.getInt((ExpressionContext)expressionContext, (String)"callout.graphics.number.limit");
            return this.insertGraphicCallouts(nodeIterator, nodeIterator2, n, string2, string3, n2, bl);
        }
        if (Params.getBoolean((ExpressionContext)expressionContext, (String)"callout.unicode")) {
            int n3 = Params.getInt((ExpressionContext)expressionContext, (String)"callout.unicode.start.character");
            int n4 = Params.getInt((ExpressionContext)expressionContext, (String)"callout.unicode.number.limit");
            String string4 = Params.getString((ExpressionContext)expressionContext, (String)"callout.unicode.font");
            return this.insertUnicodeCallouts(nodeIterator, nodeIterator2, n, string4, n3, n4, bl);
        }
        if (Params.getBoolean((ExpressionContext)expressionContext, (String)"callout.dingbats")) {
            int n5 = 10;
            return this.insertDingbatCallouts(nodeIterator, nodeIterator2, n, n5, bl);
        }
        return this.insertTextCallouts(nodeIterator, nodeIterator2, n, bl);
    }

    public DocumentFragment insertGraphicCallouts(NodeIterator nodeIterator, NodeIterator nodeIterator2, int n, String string, String string2, int n2, boolean bl) {
        FormatGraphicCallout formatGraphicCallout = new FormatGraphicCallout(string, string2, n2, bl);
        return this.insertCallouts(nodeIterator, nodeIterator2, n, (FormatCallout)formatGraphicCallout);
    }

    public DocumentFragment insertUnicodeCallouts(NodeIterator nodeIterator, NodeIterator nodeIterator2, int n, String string, int n2, int n3, boolean bl) {
        FormatUnicodeCallout formatUnicodeCallout = new FormatUnicodeCallout(string, n2, n3, bl);
        return this.insertCallouts(nodeIterator, nodeIterator2, n, (FormatCallout)formatUnicodeCallout);
    }

    public DocumentFragment insertDingbatCallouts(NodeIterator nodeIterator, NodeIterator nodeIterator2, int n, int n2, boolean bl) {
        FormatDingbatCallout formatDingbatCallout = new FormatDingbatCallout(n2, bl);
        return this.insertCallouts(nodeIterator, nodeIterator2, n, (FormatCallout)formatDingbatCallout);
    }

    public DocumentFragment insertTextCallouts(NodeIterator nodeIterator, NodeIterator nodeIterator2, int n, boolean bl) {
        FormatTextCallout formatTextCallout = new FormatTextCallout(bl);
        return this.insertCallouts(nodeIterator, nodeIterator2, n, (FormatCallout)formatTextCallout);
    }

    public DocumentFragment insertCallouts(NodeIterator nodeIterator, NodeIterator nodeIterator2, int n, FormatCallout formatCallout) {
        Object object;
        DocumentFragment documentFragment = (DocumentFragment)nodeIterator2.nextNode();
        this.callout = new Callout[10];
        this.calloutCount = 0;
        this.calloutPos = 0;
        this.lineNumber = 1;
        this.colNumber = 1;
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        Node node = nodeIterator.nextNode();
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("areaset")) {
                ++n2;
                for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                    if (object.getNodeType() != 1) continue;
                    if (object.getNodeName().equals("area")) {
                        this.addCallout(n2, (Node)object, n);
                        continue;
                    }
                    System.out.println("Unexpected element in areaset: " + object.getNodeName());
                }
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("area")) {
                this.addCallout(++n2, node, n);
                continue;
            }
            System.out.println("Unexpected element in areaspec: " + node.getNodeName());
        }
        Arrays.sort(this.callout, 0, this.calloutCount);
        object = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("PCE 2!");
            return documentFragment;
        }
        Document document = documentBuilder.newDocument();
        DocumentFragment documentFragment2 = document.createDocumentFragment();
        DOMBuilder dOMBuilder = new DOMBuilder(document, documentFragment2);
        this.elementStack = new Stack();
        this.calloutFragment(dOMBuilder, (Node)documentFragment, formatCallout);
        return documentFragment2;
    }

    private void calloutFragment(DOMBuilder dOMBuilder, Node node, FormatCallout formatCallout) {
        try {
            String string;
            Object object;
            Object object2;
            if (node.getNodeType() == 11 || node.getNodeType() == 9) {
                for (object2 = node.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                    this.calloutFragment(dOMBuilder, (Node)object2, formatCallout);
                }
            } else if (node.getNodeType() == 1) {
                object2 = node.getNamespaceURI();
                object = node.getLocalName();
                string = ((Element)node).getTagName();
                dOMBuilder.startElement((String)object2, (String)object, string, this.copyAttributes((Element)node));
                this.elementStack.push(node);
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.calloutFragment(dOMBuilder, node2, formatCallout);
                }
            } else if (node.getNodeType() == 3) {
                object2 = node.getNodeValue();
                object = ((String)object2).toCharArray();
                int n = 0;
                for (int i = 0; i < ((String)object2).length(); ++i) {
                    if (this.calloutPos < this.calloutCount && this.callout[this.calloutPos].getLine() == this.lineNumber && this.callout[this.calloutPos].getColumn() == this.colNumber) {
                        if (n > 0) {
                            dOMBuilder.characters((char[])object, 0, n);
                            n = 0;
                        }
                        this.closeOpenElements(dOMBuilder);
                        while (this.calloutPos < this.calloutCount && this.callout[this.calloutPos].getLine() == this.lineNumber && this.callout[this.calloutPos].getColumn() == this.colNumber) {
                            formatCallout.formatCallout(dOMBuilder, this.callout[this.calloutPos]);
                            ++this.calloutPos;
                        }
                        this.openClosedElements(dOMBuilder);
                    }
                    if (((String)object2).charAt(i) == '\n') {
                        if (this.calloutPos < this.calloutCount && this.callout[this.calloutPos].getLine() == this.lineNumber && this.callout[this.calloutPos].getColumn() > this.colNumber) {
                            if (n > 0) {
                                dOMBuilder.characters((char[])object, 0, n);
                                n = 0;
                            }
                            this.closeOpenElements(dOMBuilder);
                            while (this.calloutPos < this.calloutCount && this.callout[this.calloutPos].getLine() == this.lineNumber && this.callout[this.calloutPos].getColumn() > this.colNumber) {
                                this.formatPad(dOMBuilder, this.callout[this.calloutPos].getColumn() - this.colNumber);
                                this.colNumber = this.callout[this.calloutPos].getColumn();
                                while (this.calloutPos < this.calloutCount && this.callout[this.calloutPos].getLine() == this.lineNumber && this.callout[this.calloutPos].getColumn() == this.colNumber) {
                                    formatCallout.formatCallout(dOMBuilder, this.callout[this.calloutPos]);
                                    ++this.calloutPos;
                                }
                            }
                            this.openClosedElements(dOMBuilder);
                        }
                        ++this.lineNumber;
                        this.colNumber = 1;
                    } else {
                        ++this.colNumber;
                    }
                    object[n++] = ((String)object2).charAt(i);
                }
                if (n > 0) {
                    dOMBuilder.characters((char[])object, 0, n);
                }
            } else if (node.getNodeType() == 8) {
                object2 = node.getNodeValue();
                object = ((String)object2).toCharArray();
                dOMBuilder.comment((char[])object, 0, ((String)object2).length());
            } else if (node.getNodeType() == 7) {
                dOMBuilder.processingInstruction(node.getNodeName(), node.getNodeValue());
            } else {
                System.out.println("Warning: unexpected node type in calloutFragment: " + node.getNodeType() + ": " + node.getNodeName());
            }
            if (node.getNodeType() == 1) {
                object2 = node.getNamespaceURI();
                object = node.getLocalName();
                string = ((Element)node).getTagName();
                dOMBuilder.endElement((String)object2, (String)object, string);
                this.elementStack.pop();
            }
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in calloutFragment");
        }
    }

    private void addCallout(int n, Node node, int n2) {
        int n3;
        Callout[] calloutArray;
        Element element = (Element)node;
        String string = element.getAttribute("units");
        String string2 = element.getAttribute("otherunits");
        String string3 = element.getAttribute("coords");
        int n4 = 0;
        String string4 = null;
        if (string == null || string.equals("linecolumn")) {
            n4 = 2;
        } else if (string.equals("linerange")) {
            n4 = 4;
        } else if (string.equals("linecolumnpair")) {
            n4 = 3;
        } else if (string.equals("calspair")) {
            n4 = 1;
        } else {
            n4 = 5;
            string4 = string2;
        }
        if (n4 != 2 && n4 != 4) {
            System.out.println("Only linecolumn and linerange units are supported");
            return;
        }
        if (string3 == null) {
            System.out.println("Coords must be specified");
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (++n5 > 2) {
                System.out.println("Unparseable coordinates");
                return;
            }
            try {
                calloutArray = stringTokenizer.nextToken();
                n7 = n3 = Integer.parseInt((String)calloutArray);
                if (n5 != 1) continue;
                n6 = n3;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Unparseable coordinate");
                return;
            }
        }
        if (this.calloutCount == this.callout.length) {
            calloutArray = new Callout[this.calloutCount + 10];
            for (n3 = 0; n3 < this.callout.length; ++n3) {
                calloutArray[n3] = this.callout[n3];
            }
            this.callout = calloutArray;
        }
        if (n5 == 2) {
            if (n4 == 4) {
                for (int i = n6; i <= n7; ++i) {
                    this.callout[this.calloutCount++] = new Callout(n, element, i, n2, n4);
                }
            } else {
                this.callout[this.calloutCount++] = new Callout(n, element, n6, n7, n4);
            }
        } else {
            this.callout[this.calloutCount++] = new Callout(n, element, n6, n2, n4);
        }
    }

    private void formatPad(DOMBuilder dOMBuilder, int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 32;
        }
        try {
            dOMBuilder.characters(cArray, 0, n);
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in formatCallout");
        }
    }

    private void closeOpenElements(DOMBuilder dOMBuilder) throws SAXException {
        this.tempStack = new Stack();
        while (!this.elementStack.empty()) {
            Node node = (Node)this.elementStack.pop();
            String string = node.getNamespaceURI();
            String string2 = node.getLocalName();
            String string3 = ((Element)node).getTagName();
            if (this.elementStack.empty() && (string != null && string.equals(foURI) && string2.equals("block") || string == null && string2.equalsIgnoreCase("pre") || string != null && string.equals(xhURI) && string2.equals("pre") || string == null && string2.equalsIgnoreCase("div") || string != null && string.equals(xhURI) && string2.equals("div"))) {
                this.elementStack.push(node);
                break;
            }
            dOMBuilder.endElement(string, string2, string3);
            this.tempStack.push(node);
        }
    }

    private void openClosedElements(DOMBuilder dOMBuilder) throws SAXException {
        while (!this.tempStack.empty()) {
            Node node = (Node)this.tempStack.pop();
            String string = node.getNamespaceURI();
            String string2 = node.getLocalName();
            String string3 = ((Element)node).getTagName();
            NamedNodeMap namedNodeMap = node.getAttributes();
            AttributesImpl attributesImpl = new AttributesImpl();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                if ((string == null || string == xhURI) && string2.equalsIgnoreCase("a") || node2.getLocalName().equalsIgnoreCase("id")) continue;
                attributesImpl.addAttribute(node2.getNamespaceURI(), node2.getLocalName(), node2.getNodeName(), "CDATA", node2.getNodeValue());
            }
            dOMBuilder.startElement(string, string2, string3, (Attributes)attributesImpl);
            this.elementStack.push(node);
        }
        this.tempStack = null;
    }

    private Attributes copyAttributes(Element element) {
        AttributesImpl attributesImpl = new AttributesImpl();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getName();
            if (string.startsWith("xmlns:") || string.equals("xmlns")) continue;
            attributesImpl.addAttribute(attr.getNamespaceURI(), attr.getName(), attr.getName(), "CDATA", attr.getValue());
        }
        return attributesImpl;
    }
}

