/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.psc.shared.message.FieldName;
import de.plans.psc.shared.message.RequestFamily;
import de.plans.psc.shared.message.RequestID;
import de.plans.psc.shared.message.RequestStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class SegmentHeaderEncoder {
    private static final ILogger LOGGER = Logger.getLogger(SegmentHeaderEncoder.class);
    private static final String UTF_8 = "UTF-8";
    private static final char LF = '\n';
    private static final byte LFByte = 10;
    private static final char CR = '\r';
    private static final byte CRByte = 13;
    private static final String CRLF = new String(new char[]{'\r', '\n'});
    private static final byte[] CRLFBytes = new byte[]{13, 10};
    private static final char FieldNameTerminatorChar = ':';
    private static final char ListElementSeparatorChar = ';';
    private static final char BLANK = ' ';
    private static final String FieldValue_null = "<null>";
    private static final String FieldValue_emptySet = "<empty>";
    private static final String SegmentPreambleString = "ARCWAY COCKPIT PROTOCOL 00000003";
    private static final byte[] SegmentPreambleBytes = new byte[]{65, 82, 67, 87, 65, 89, 32, 67, 79, 67, 75, 80, 73, 84, 32, 80, 82, 79, 84, 79, 67, 79, 76, 32, 48, 48, 48, 48, 48, 48, 48, 51};
    public static final int HeaderBufferSize_Complete_Default = 512;
    public static final int HeaderBufferSize_Standard_Default = 512;
    public static final int HeaderBufferSize_Extra_Default = 128;
    public static final int HeaderBufferSize_Complete_Max = 5120;

    static {
        try {
            assert (Arrays.equals(SegmentPreambleBytes, SegmentPreambleString.getBytes(UTF_8)));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("unhandled catch block", (Throwable)e);
        }
    }

    private SegmentHeaderEncoder() {
    }

    public static byte[] encodeSegment(RawSegmentHeaderData rawSegmentHeaderData) throws UnsupportedEncodingException {
        String fieldContent;
        String fieldName;
        StringBuilder sb = new StringBuilder();
        sb.append(SegmentPreambleString);
        sb.append(CRLF);
        for (Map.Entry<FieldName, String> entry : rawSegmentHeaderData.getStandardFields().entrySet()) {
            fieldName = SegmentHeaderEncoder.encodeFieldName(entry.getKey());
            fieldContent = entry.getValue();
            SegmentHeaderEncoder.appendField(sb, fieldName, fieldContent);
        }
        sb.append(CRLF);
        sb.append(CRLF);
        for (Map.Entry<Object, String> entry : rawSegmentHeaderData.getExtraFields().entrySet()) {
            fieldName = (String)entry.getKey();
            fieldContent = entry.getValue();
            SegmentHeaderEncoder.appendField(sb, fieldName, fieldContent);
        }
        sb.append(CRLF);
        return sb.toString().getBytes(UTF_8);
    }

    public static void appendField(StringBuilder sb, String fieldName, String fieldContent) {
        assert (fieldName.indexOf(58) == -1);
        assert (fieldName.indexOf(13) == -1);
        assert (fieldName.indexOf(10) == -1);
        assert (fieldName.trim().length() == fieldName.length());
        assert (fieldContent.indexOf(13) == -1);
        assert (fieldContent.indexOf(10) == -1);
        assert (fieldContent.trim().length() == fieldContent.length());
        sb.append(fieldName);
        sb.append(':');
        sb.append(' ');
        sb.append(fieldContent);
        sb.append(CRLF);
    }

    private static String readBytesUntil_CRLFCRLF(InputStream inputStream, byte[] preambleBytes, int defaultHeaderBufSize, int maxHeaderBufSize) throws IOException, ExInvalidSegmentData {
        int readsize;
        byte[] bufferArray = new byte[defaultHeaderBufSize];
        int cummulatedBytes = preambleBytes != null ? preambleBytes.length + 4 : 4;
        assert (defaultHeaderBufSize >= cummulatedBytes) : "defaultHeaderBufSize too small even for the initial read";
        SegmentHeaderEncoder.readFully(inputStream, bufferArray, 0, cummulatedBytes);
        if (preambleBytes != null) {
            int i = 0;
            while (i < preambleBytes.length) {
                if (bufferArray[i] != preambleBytes[i]) {
                    throw new ExInvalidSegmentData("Invalid Preamble or Protocol version.");
                }
                ++i;
            }
            i = 0;
            while (i < CRLFBytes.length) {
                if (bufferArray[preambleBytes.length + i] != CRLFBytes[i]) {
                    throw new ExInvalidSegmentData("Invalid Preamble or Protocol version termination bytes.");
                }
                ++i;
            }
        }
        while (true) {
            byte t1;
            if ((t1 = bufferArray[cummulatedBytes - 1]) == 10) {
                if (bufferArray[cummulatedBytes - 2] != 13) {
                    throw new ExInvalidSegmentData("Illegal line break in segment header.");
                }
                byte t3 = bufferArray[cummulatedBytes - 3];
                if (t3 == 10) {
                    if (bufferArray[cummulatedBytes - 4] != 13) {
                        throw new ExInvalidSegmentData("Illegal line breaks in segment header.");
                    }
                    break;
                }
                readsize = 2;
            } else if (t1 == 13) {
                byte t3 = bufferArray[cummulatedBytes - 3];
                if (t3 == 13) {
                    if (bufferArray[cummulatedBytes - 2] != 10) {
                        throw new ExInvalidSegmentData("Illegal line breaks in segment header.");
                    }
                    readsize = 1;
                } else {
                    readsize = 3;
                }
            } else {
                readsize = 4;
            }
            if (bufferArray.length < cummulatedBytes + readsize) {
                assert (false) : "We do not want to get here regularly, enlarge the initial buffer size.";
                int newBufferSize = Math.min(bufferArray.length * 2, maxHeaderBufSize);
                if (newBufferSize <= bufferArray.length) {
                    throw new ExInvalidSegmentData("Segment header size limit of " + maxHeaderBufSize + " bytes exceeded.");
                }
                byte[] newBuffer = new byte[newBufferSize];
                System.arraycopy(bufferArray, 0, newBuffer, 0, bufferArray.length);
                bufferArray = newBuffer;
            }
            SegmentHeaderEncoder.readFully(inputStream, bufferArray, cummulatedBytes, readsize);
            cummulatedBytes += readsize;
        }
        readsize = 0;
        return new String(bufferArray, 0, cummulatedBytes - 4, UTF_8);
    }

    public static RawSegmentHeaderData decodeSegment(InputStream inputStream) throws IOException, ExInvalidSegmentData {
        Pattern lineSplitPattern = Pattern.compile(CRLF);
        String headerWithoutExtraFields = SegmentHeaderEncoder.readBytesUntil_CRLFCRLF(inputStream, SegmentPreambleBytes, 512, 5120);
        String[] headerLines = lineSplitPattern.split(headerWithoutExtraFields, -1);
        LinkedHashMap<FieldName, String> standardFields = new LinkedHashMap<FieldName, String>(2 * headerLines.length);
        int i = 1;
        while (i < headerLines.length) {
            String headerLineI = headerLines[i];
            ArrayList nameValuePair = StringUtil.split((String)headerLineI, (char)':', (int)2);
            if (nameValuePair.size() != 2) {
                throw new ExInvalidSegmentData("Illegal segment header line:" + headerLineI + ", complete standardFields header: " + headerWithoutExtraFields);
            }
            FieldName fieldName = FieldName.parseFieldName(((String)nameValuePair.get(0)).trim());
            if (fieldName == null) {
                throw new ExInvalidSegmentData("Illegal segment header - Unknown header field name:" + ((String)nameValuePair.get(0)).trim() + ", complete standardFields header: " + headerWithoutExtraFields);
            }
            String replacedValue = standardFields.put(fieldName, ((String)nameValuePair.get(1)).trim());
            if (replacedValue != null) {
                throw new ExInvalidSegmentData("Illegal segment header - Duplicate header field:" + ((String)nameValuePair.get(0)).trim() + ", complete standardFields header: " + headerWithoutExtraFields);
            }
            ++i;
        }
        String extraFieldCompartment = SegmentHeaderEncoder.readBytesUntil_CRLFCRLF(inputStream, null, 128, 5120);
        String[] extraFieldLines = lineSplitPattern.split(extraFieldCompartment, -1);
        LinkedHashMap<String, String> extraFields = new LinkedHashMap<String, String>(2 * extraFieldLines.length);
        int i2 = 1;
        while (i2 < extraFieldLines.length) {
            String extraFieldLineI = extraFieldLines[i2];
            ArrayList nameValuePair = StringUtil.split((String)extraFieldLineI, (char)':', (int)2);
            if (nameValuePair.size() != 2) {
                throw new ExInvalidSegmentData("Illegal segment header line:" + extraFieldLineI + ", complete extraFields header: " + extraFieldCompartment);
            }
            String fieldName = ((String)nameValuePair.get(0)).trim();
            String replacedValue = extraFields.put(fieldName, ((String)nameValuePair.get(1)).trim());
            if (replacedValue != null) {
                throw new ExInvalidSegmentData("Illegal segment header - Duplicate header field:" + ((String)nameValuePair.get(0)).trim() + ", complete extraFields header: " + extraFieldCompartment);
            }
            ++i2;
        }
        return new RawSegmentHeaderData(standardFields, extraFields);
    }

    private static void readFully(InputStream inputStream, byte[] b, int off, int len) throws IOException, ExInvalidSegmentData {
        int cummulatedBytes = 0;
        while (cummulatedBytes < len) {
            int readBytes = inputStream.read(b, off + cummulatedBytes, len - cummulatedBytes);
            if (readBytes == -1) {
                throw new ExInvalidSegmentData("Premature end of segment after " + cummulatedBytes + "bytes.");
            }
            cummulatedBytes += readBytes;
        }
    }

    public static FieldName decodeFieldName(String fieldname) {
        return FieldName.parseFieldName(fieldname);
    }

    public static long decodeField_Long(String fieldvalue) {
        return Long.parseLong(fieldvalue);
    }

    public static RequestID decodeField_RequestID(String fieldvalue) {
        if (FieldValue_null.equals(fieldvalue)) {
            return null;
        }
        return RequestID.parseFieldValueEncodedRequestID(fieldvalue);
    }

    public static Set<RequestID> decodeField_Set_RequestID(String fieldvalue) {
        if (FieldValue_emptySet.equals(fieldvalue)) {
            return Collections.emptySet();
        }
        ArrayList elements = StringUtil.split((String)fieldvalue, (char)';');
        HashSet<RequestID> result = new HashSet<RequestID>(elements.size() * 2);
        for (String element : elements) {
            boolean wasNew = result.add(SegmentHeaderEncoder.decodeField_RequestID(element));
            assert (wasNew);
        }
        return result;
    }

    public static RequestStatus decodeField_RequestStatus(String string) {
        return RequestStatus.valueOf(string);
    }

    public static String encodeFieldName(FieldName fieldname) {
        return fieldname.toString();
    }

    public static String encodeField_Long(long l) {
        return Long.toString(l);
    }

    public static String encodeField_RequestID(RequestID requestID) {
        if (requestID == null) {
            return FieldValue_null;
        }
        return RequestID.getFieldValueEncodedRequestID(requestID);
    }

    public static String encodeField_Set_RequestID(Set<RequestID> requestIDs) {
        if (requestIDs.isEmpty()) {
            return FieldValue_emptySet;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFirst = true;
        for (RequestID requestID : requestIDs) {
            if (isFirst) {
                isFirst = false;
            } else {
                stringBuilder.append(';');
            }
            String encodedRequestID = SegmentHeaderEncoder.encodeField_RequestID(requestID);
            assert (encodedRequestID.indexOf(59) == -1);
            stringBuilder.append(encodedRequestID);
        }
        return stringBuilder.toString();
    }

    public static String encodeField_RequestStatus(RequestStatus requestStatus) {
        return requestStatus.name();
    }

    public static String decodeField_String(String string) {
        return string.trim();
    }

    public static String encodeField_String(String string) {
        assert (string != null);
        assert (string.equals(string.trim()));
        return string;
    }

    public static RequestFamily decodeField_RequestFamily(String string) {
        return RequestFamily.parseRequestFamily(string);
    }

    public static String encodeField_RequestFamily(RequestFamily requestFamily) {
        return requestFamily.toString();
    }

    public static class ExInvalidSegmentData
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ExInvalidSegmentData() {
        }

        public ExInvalidSegmentData(String message, Throwable cause) {
            super(message, cause);
        }

        public ExInvalidSegmentData(String message) {
            super(message);
        }

        public ExInvalidSegmentData(Throwable cause) {
            super(cause);
        }
    }

    public static class RawSegmentHeaderData {
        private final LinkedHashMap<FieldName, String> standardFields;
        private final LinkedHashMap<String, String> extraFields;

        public RawSegmentHeaderData(LinkedHashMap<FieldName, String> standardFields, LinkedHashMap<String, String> extraFields) {
            this.standardFields = standardFields;
            this.extraFields = extraFields != null ? extraFields : new LinkedHashMap();
        }

        public LinkedHashMap<FieldName, String> getStandardFields() {
            return this.standardFields;
        }

        public LinkedHashMap<String, String> getExtraFields() {
            return this.extraFields;
        }
    }
}

