/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.admin.swt;

import de.plans.psc.client.dialogs.admin.swt.GroupListWrapper;
import de.plans.psc.client.dialogs.admin.swt.Messages;
import de.plans.psc.client.model.GroupListModel;
import de.plans.psc.client.model.UserGroup;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class UIPnlSelectGroups
extends Composite
implements ISelectionChangedListener {
    private GroupListWrapper proposedViewer;
    private GroupListModel proposedModel;
    private GroupListWrapper selectedViewer;
    private GroupListModel selectedModel;
    private Button btnAddSelected;
    private Button btnAddAll;
    private Button btnRemoveSelected;
    private Button btnRemoveAll;

    public UIPnlSelectGroups(Composite parent, int style) {
        super(parent, style);
        this.initComponents();
    }

    private void initComponents() {
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        this.setLayout((Layout)gl);
        Group g1 = new Group((Composite)this, 0);
        g1.setText(Messages.getString("UIPnlSelectGroups.Proposed_groups_1"));
        g1.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)g1);
        this.proposedViewer = new GroupListWrapper((Composite)g1, 770);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(150, -1).applyTo((Control)this.proposedViewer.getViewer().getList());
        this.proposedViewer.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        Composite buttonBar = new Composite((Composite)this, 0);
        gl = new GridLayout();
        gl.numColumns = 1;
        buttonBar.setLayout((Layout)gl);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 2;
        buttonBar.setLayoutData((Object)gridData);
        this.btnAddSelected = new Button(buttonBar, 8);
        this.btnAddSelected.setText(">");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnAddSelected.setLayoutData((Object)gridData);
        this.btnAddSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIPnlSelectGroups.this.addSelected();
            }
        });
        this.btnAddAll = new Button(buttonBar, 8);
        this.btnAddAll.setText(">>");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnAddAll.setLayoutData((Object)gridData);
        this.btnAddAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIPnlSelectGroups.this.addAll();
            }
        });
        this.btnRemoveSelected = new Button(buttonBar, 8);
        this.btnRemoveSelected.setText("<");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnRemoveSelected.setLayoutData((Object)gridData);
        this.btnRemoveSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIPnlSelectGroups.this.removeSelected();
            }
        });
        this.btnRemoveAll = new Button(buttonBar, 8);
        this.btnRemoveAll.setText("<<");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnRemoveAll.setLayoutData((Object)gridData);
        this.btnRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIPnlSelectGroups.this.removeAll();
            }
        });
        Group g2 = new Group((Composite)this, 0);
        g2.setText(Messages.getString("UIPnlSelectGroups.Selected_groups_6"));
        g2.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)g2);
        this.selectedViewer = new GroupListWrapper((Composite)g2, 770);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(150, -1).applyTo((Control)this.selectedViewer.getViewer().getList());
        this.selectedViewer.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void setLists(GroupListModel proposed, GroupListModel selected) {
        this.proposedModel = proposed;
        this.selectedModel = selected;
        this.proposedViewer.getViewer().setInput((Object)proposed);
        this.selectedViewer.getViewer().setInput((Object)selected);
        this.setButtonStates();
    }

    private void addSelected() {
        for (UserGroup g : this.proposedViewer.getSelectedGroups()) {
            boolean success = this.proposedModel.removeElement(g);
            assert (success);
            this.selectedModel.addElement(g);
        }
        this.proposedViewer.getViewer().setInput((Object)this.proposedModel);
        this.selectedViewer.getViewer().setInput((Object)this.selectedModel);
        this.setButtonStates();
    }

    private void addAll() {
        int i = this.proposedModel.getSize() - 1;
        while (i >= 0) {
            UserGroup g = this.proposedModel.getElement(i);
            this.proposedModel.removeElement(g);
            this.selectedModel.addElement(g);
            --i;
        }
        this.proposedViewer.getViewer().setInput((Object)this.proposedModel);
        this.selectedViewer.getViewer().setInput((Object)this.selectedModel);
        this.setButtonStates();
    }

    private void removeSelected() {
        for (UserGroup g : this.selectedViewer.getSelectedGroups()) {
            boolean success = this.selectedModel.removeElement(g);
            assert (success);
            this.proposedModel.addElement(g);
        }
        this.proposedViewer.getViewer().setInput((Object)this.proposedModel);
        this.selectedViewer.getViewer().setInput((Object)this.selectedModel);
        this.setButtonStates();
    }

    private void removeAll() {
        int i = this.selectedModel.getSize() - 1;
        while (i >= 0) {
            UserGroup g = this.selectedModel.getElement(i);
            this.selectedModel.removeElement(g);
            this.proposedModel.addElement(g);
            --i;
        }
        this.proposedViewer.getViewer().setInput((Object)this.proposedModel);
        this.selectedViewer.getViewer().setInput((Object)this.selectedModel);
        this.setButtonStates();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setButtonStates();
    }

    private void setButtonStates() {
        if (this.proposedModel.getSize() > 0) {
            this.btnAddAll.setEnabled(true);
            if (this.proposedViewer.getViewer().getList().getSelectionCount() > 0) {
                this.btnAddSelected.setEnabled(true);
            } else {
                this.btnAddSelected.setEnabled(false);
            }
        } else {
            this.btnAddAll.setEnabled(false);
            this.btnAddSelected.setEnabled(false);
        }
        if (this.selectedModel.getSize() > 0) {
            this.btnRemoveAll.setEnabled(true);
            if (this.selectedViewer.getViewer().getList().getSelectionCount() > 0) {
                this.btnRemoveSelected.setEnabled(true);
            } else {
                this.btnRemoveSelected.setEnabled(false);
            }
        } else {
            this.btnRemoveAll.setEnabled(false);
            this.btnRemoveSelected.setEnabled(false);
        }
    }
}

