/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.ILoggerManager;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Log4jLoggerManager
implements ILoggerManager {
    public static final String LEVEL_FATAL = "LoggerPreferencePage.fatalEnabled";
    public static final String LEVEL_ERROR = "LoggerPreferencePage.errorEnabled";
    public static final String LEVEL_WARN = "LoggerPreferencePage.warnEnabled";
    public static final String LEVEL_DEBUG = "LoggerPreferencePage.debugEnabled";
    public static final String LEVEL_INFO = "LoggerPreferencePage.infoEnabled";
    public static final String LEVEL_TRACE = "LoggerPreferencePage.traceEnabled";
    public static final boolean LOG4J_LOGGER_ENABLED = true;
    private static boolean[] debugCategoryEnabled = new boolean[200];
    private static final Set enabledLevels;

    static {
        int i = 0;
        while (i < debugCategoryEnabled.length) {
            Log4jLoggerManager.debugCategoryEnabled[i] = true;
            ++i;
        }
        enabledLevels = new HashSet();
        enabledLevels.add(LEVEL_FATAL);
        enabledLevels.add(LEVEL_ERROR);
        enabledLevels.add(LEVEL_WARN);
        enabledLevels.add(LEVEL_INFO);
        enabledLevels.add(LEVEL_DEBUG);
        enabledLevels.add(LEVEL_TRACE);
    }

    public static void setVerboseLevelEnabled(String verboseLevel, boolean value) {
        if (value) {
            enabledLevels.add(verboseLevel);
        } else {
            enabledLevels.remove(verboseLevel);
        }
    }

    public static boolean getVerboseLevelEnabled(String verboseLevel) {
        return enabledLevels.contains(verboseLevel);
    }

    public static boolean enableDebugCategoryEnabled(int debugCategory) {
        if (debugCategory >= 0 && debugCategory < 200) {
            Log4jLoggerManager.debugCategoryEnabled[debugCategory] = true;
            return true;
        }
        return false;
    }

    public static boolean disableDebugCategoryEnabled(int debugCategory) {
        if (debugCategory >= 0 && debugCategory < 200) {
            Log4jLoggerManager.debugCategoryEnabled[debugCategory] = false;
            return true;
        }
        return false;
    }

    public static void shutdown() {
        LogManager.shutdown();
    }

    public ILogger getILogger(String name) {
        return new Log4jLoggerAdapter(Logger.getLogger((String)name));
    }

    public ILogger getILogger(Class clazz) {
        return new Log4jLoggerAdapter(Logger.getLogger((Class)clazz));
    }

    private static class Log4jLoggerAdapter
    implements ILogger {
        private final Logger log4jLogger;

        public Log4jLoggerAdapter(Logger log4jLogger) {
            if (log4jLogger == null) {
                throw new IllegalArgumentException();
            }
            this.log4jLogger = log4jLogger;
        }

        public void trace(String message) {
            if (Log4jLoggerManager.getVerboseLevelEnabled(Log4jLoggerManager.LEVEL_TRACE)) {
                this.log4jLogger.debug((Object)message);
            }
        }

        public void debug(int debugCategory, String message) {
            if (this.isDebugEnabled() && debugCategoryEnabled[debugCategory]) {
                this.log4jLogger.debug((Object)message);
            }
        }

        public void debug(int debugCategory, String message, Throwable t) {
            if (this.isDebugEnabled() && debugCategoryEnabled[debugCategory]) {
                this.log4jLogger.debug((Object)message, t);
            }
        }

        public void debug(String message) {
            if (this.isDebugEnabled()) {
                this.log4jLogger.debug((Object)message);
            }
        }

        public void debug(String message, Throwable t) {
            if (this.isDebugEnabled()) {
                this.log4jLogger.debug((Object)message, t);
            }
        }

        public void error(String message) {
            if (Log4jLoggerManager.getVerboseLevelEnabled(Log4jLoggerManager.LEVEL_ERROR)) {
                this.log4jLogger.error((Object)message);
            }
        }

        public void error(String message, Throwable t) {
            if (Log4jLoggerManager.getVerboseLevelEnabled(Log4jLoggerManager.LEVEL_ERROR)) {
                this.log4jLogger.error((Object)message, t);
            }
        }

        public void error(Throwable t) {
            if (Log4jLoggerManager.getVerboseLevelEnabled(Log4jLoggerManager.LEVEL_ERROR)) {
                this.log4jLogger.error((Object)"", t);
            }
        }

        public void fatal(String message) {
            if (Log4jLoggerManager.getVerboseLevelEnabled(Log4jLoggerManager.LEVEL_FATAL)) {
                this.log4jLogger.fatal((Object)message);
            }
        }

        public void fatal(String message, Throwable t) {
            if (Log4jLoggerManager.getVerboseLevelEnabled(Log4jLoggerManager.LEVEL_FATAL)) {
                this.log4jLogger.fatal((Object)message, t);
            }
        }

        public void fatal(Throwable t) {
            if (Log4jLoggerManager.getVerboseLevelEnabled(Log4jLoggerManager.LEVEL_FATAL)) {
                this.log4jLogger.fatal((Object)"", t);
            }
        }

        public void info(String message) {
            if (Log4jLoggerManager.getVerboseLevelEnabled(Log4jLoggerManager.LEVEL_INFO)) {
                this.log4jLogger.info((Object)message);
            }
        }

        public void info(String message, Throwable t) {
            if (Log4jLoggerManager.getVerboseLevelEnabled(Log4jLoggerManager.LEVEL_INFO)) {
                this.log4jLogger.info((Object)message, t);
            }
        }

        public void warn(String message) {
            if (Log4jLoggerManager.getVerboseLevelEnabled(Log4jLoggerManager.LEVEL_WARN)) {
                this.log4jLogger.warn((Object)message);
            }
        }

        public void warn(String message, Throwable t) {
            if (Log4jLoggerManager.getVerboseLevelEnabled(Log4jLoggerManager.LEVEL_WARN)) {
                this.log4jLogger.warn((Object)message, t);
            }
        }

        public void warn(Throwable t) {
            if (Log4jLoggerManager.getVerboseLevelEnabled(Log4jLoggerManager.LEVEL_WARN)) {
                this.log4jLogger.warn((Object)"", t);
            }
        }

        public boolean isInfoEnabled() {
            return Log4jLoggerManager.getVerboseLevelEnabled(Log4jLoggerManager.LEVEL_INFO) && this.log4jLogger.isInfoEnabled();
        }

        public boolean isDebugEnabled() {
            return Log4jLoggerManager.getVerboseLevelEnabled(Log4jLoggerManager.LEVEL_DEBUG) && this.log4jLogger.isDebugEnabled();
        }

        public boolean isDebugEnabled(int debugCategory) {
            return this.isDebugEnabled() && debugCategoryEnabled[debugCategory];
        }

        public boolean isTraceEnabled() {
            return Log4jLoggerManager.getVerboseLevelEnabled(Log4jLoggerManager.LEVEL_TRACE);
        }
    }
}

