/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

@Deprecated
public class IniFile {
    private static final ILogger logger = Logger.getLogger(IniFile.class);
    private final File iniFile;
    private final String header;
    private final Properties properties = new Properties();

    private IniFile(String filename, String header) {
        this.iniFile = new File(filename);
        this.header = header;
        this.load();
    }

    public IniFile(String filename) {
        this(filename, filename);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void load() {
        FileInputStream iniFile_in = null;
        try {
            try {
                iniFile_in = new FileInputStream(this.iniFile);
                this.properties.load(iniFile_in);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (iniFile_in == null) return;
                try {
                    iniFile_in.close();
                    return;
                }
                catch (IOException e) {
                    logger.error("Error while loading/closing INI File: " + this.iniFile.getAbsolutePath(), (Throwable)e);
                }
                return;
            }
            catch (IOException e) {
                logger.error("Error while loading INI File contents (" + this.iniFile.getAbsolutePath() + ").", (Throwable)e);
                if (iniFile_in == null) return;
                try {
                    iniFile_in.close();
                    return;
                }
                catch (IOException e2) {
                    logger.error("Error while loading/closing INI File: " + this.iniFile.getAbsolutePath(), (Throwable)e2);
                }
                return;
            }
        }
        finally {
            if (iniFile_in != null) {
                try {
                    iniFile_in.close();
                }
                catch (IOException e) {
                    logger.error("Error while loading/closing INI File: " + this.iniFile.getAbsolutePath(), (Throwable)e);
                }
            }
        }
    }

    public void store() {
        block13: {
            FileOutputStream iniFile_out = null;
            try {
                try {
                    File dir;
                    if (!this.iniFile.exists() && (dir = this.iniFile.getParentFile()) != null && !dir.exists()) {
                        dir.mkdirs();
                    }
                    iniFile_out = new FileOutputStream(this.iniFile);
                    this.properties.store(iniFile_out, this.header);
                }
                catch (IOException e) {
                    logger.error("Error while writing INI File contents (" + this.iniFile.getAbsolutePath() + ").", (Throwable)e);
                    if (iniFile_out == null) break block13;
                    try {
                        iniFile_out.close();
                    }
                    catch (IOException e2) {
                        logger.error("Error while writing/closing INI File: " + this.iniFile.getAbsolutePath(), (Throwable)e2);
                    }
                }
            }
            finally {
                if (iniFile_out != null) {
                    try {
                        iniFile_out.close();
                    }
                    catch (IOException e) {
                        logger.error("Error while writing/closing INI File: " + this.iniFile.getAbsolutePath(), (Throwable)e);
                    }
                }
            }
        }
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public String getStringProperty(String key) {
        return this.getProperty(key, "");
    }

    public void setProperty(String key, boolean value) {
        this.properties.setProperty(key, "" + value);
    }

    public boolean getProperty(String key, boolean defaultValue) {
        String value = this.properties.getProperty(key, "" + defaultValue);
        return Boolean.valueOf(value);
    }

    public boolean getBoolProperty(String key) {
        return this.getProperty(key, true);
    }
}

