/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.valueranges;

import com.arcway.lib.java.SetterSuccess;
import de.plans.lib.localisation.DateFormatHelper;
import de.plans.lib.util.valueranges.ILong;
import de.plans.lib.util.valueranges.IValueRangeHelperText;
import de.plans.lib.util.valueranges.Messages;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ValueRangeHelperTimestamp
implements IValueRangeHelperText {
    private static final String ERROR_MSG_PARTI = Messages.getString("ValueRangeHelperTimestamp.ErrorMsg.PartI");
    private static final String ERROR_MSG_PARTII = Messages.getString("ValueRangeHelperTimestamp.ErrorMsg.PartII");
    private boolean includeTime;
    private final ILong persistentLocation;

    public ValueRangeHelperTimestamp(ILong associatedPersistentLocation) {
        this.persistentLocation = associatedPersistentLocation;
        this.includeTime = true;
    }

    public ValueRangeHelperTimestamp(ILong associatedPersistentLocation, boolean includeTime) {
        this.persistentLocation = associatedPersistentLocation;
        this.includeTime = includeTime;
    }

    @Override
    public boolean check(String valueToCheck) {
        return this.check(valueToCheck, null);
    }

    public boolean check(String valueToCheck, Locale locale) {
        assert (valueToCheck != null) : "value to check must not be null";
        return this.getDateFromString(valueToCheck, locale) != null;
    }

    @Override
    public SetterSuccess setPersistentValue(String newValue) {
        return this.setPersistentValue(newValue, null);
    }

    public SetterSuccess setPersistentValue(String newValue, Locale locale) {
        assert (newValue != null) : " new value must not be null";
        if (this.check(newValue, locale)) {
            Long oldValue = this.persistentLocation.getValue();
            this.persistentLocation.setValue(this.getDateFromString(newValue, locale));
            boolean valueChanged = oldValue == null && this.persistentLocation.getValue() != null || oldValue != null && !oldValue.equals(this.persistentLocation.getValue());
            return valueChanged ? SetterSuccess.VALUE_CHANGED : SetterSuccess.VALUE_DID_NOT_CHANGE;
        }
        return SetterSuccess.NEW_VALUE_COULD_NOT_BE_APPLIED;
    }

    private Long getDateFromString(String dateValue, Locale locale) {
        Date date;
        assert (dateValue != null) : " new value must not be null";
        TimeZone timezone = null;
        if (!this.includeTime) {
            timezone = TimeZone.getTimeZone("GMT+2:00");
        }
        if ((date = DateFormatHelper.getDefault().parse(dateValue, locale, timezone)) != null) {
            return new Long(date.getTime());
        }
        return null;
    }

    @Override
    public String getDisplayFormat() {
        return this.getDisplayFormat(Locale.getDefault());
    }

    public String getDisplayFormat(Locale locale) {
        assert (this.persistentLocation != null) : "moduleDataAttribute must not be null";
        if (this.persistentLocation.getValue() == null) {
            return "";
        }
        DateFormat dateFormat = null;
        if (this.includeTime) {
            dateFormat = DateFormatHelper.getDefault().getDateTimeFormat(locale);
        } else {
            dateFormat = DateFormatHelper.getDefault().getDateFormat(locale);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT+2:00"));
        }
        String displayString = dateFormat.format(new Timestamp(this.persistentLocation.getValue()));
        if (displayString != null) {
            return displayString;
        }
        return "";
    }

    public Timestamp getValue() {
        assert (this.persistentLocation != null) : "persistentLocation must not be null";
        if (this.persistentLocation.getValue() != null) {
            return new Timestamp(this.persistentLocation.getValue());
        }
        return null;
    }

    public void setIncludeTime(boolean includeTime) {
        this.includeTime = includeTime;
    }

    public boolean getIncludeTime() {
        return this.includeTime;
    }

    @Override
    public String getErrorMessage(String description) {
        if (description != null) {
            return String.valueOf(description) + ERROR_MSG_PARTII;
        }
        return String.valueOf(ERROR_MSG_PARTI) + ERROR_MSG_PARTII;
    }
}

