/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.gui;

import de.plans.lib.util.gui.AbstractActivityProgressManager;
import de.plans.lib.util.gui.ISubActivityProgressManager;
import org.eclipse.core.runtime.IProgressMonitor;

public class UsableProcessProgressManager
extends AbstractActivityProgressManager {
    private final IProgressMonitor progressMonitor;
    private final int taskWeight;
    private int workCompleted = 0;

    public UsableProcessProgressManager(IProgressMonitor progressMonitor, String processName, int taskCount) {
        super(null);
        this.progressMonitor = progressMonitor;
        this.setNumberOfSteps_internal(taskCount);
        this.taskWeight = Integer.MAX_VALUE / taskCount;
        this.progressMonitor.beginTask(processName, taskCount * this.taskWeight);
    }

    public ISubActivityProgressManager startNextTask(String taskName) {
        ISubActivityProgressManager nextTask = this.startNextStep_internal();
        if (nextTask != null) {
            this.progressMonitor.subTask(taskName);
        }
        return nextTask;
    }

    @Override
    protected final void setProgress(float percentage) {
        this.updateWorkCompleted((int)Math.floor(((float)this.stepsCompleted + percentage) * (float)this.taskWeight));
    }

    public void finishProcess() {
        this.stepsCompleted = this.stepCount;
        this.setProgress(0.0f);
    }

    private void updateWorkCompleted(int newWorkCompleted) {
        if (newWorkCompleted > this.workCompleted) {
            this.progressMonitor.worked(newWorkCompleted - this.workCompleted);
            this.workCompleted = newWorkCompleted;
        }
    }
}

