/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.treeviews;

import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.treeviews.ITreeView;
import com.arcway.lib.ui.treeviews.ITreeViewFilterRule;
import com.arcway.lib.ui.treeviews.ITreeViewListener;
import java.util.ArrayList;

public class FilteredTreeView
implements ITreeView {
    private final ITreeView nextTreeView;
    private ITreeViewFilterRule rule;

    public FilteredTreeView(ITreeViewFilterRule rule, ITreeView nextTreeView) {
        this.nextTreeView = nextTreeView;
        this.rule = rule;
    }

    public void setRule(ITreeViewFilterRule rule) {
        this.rule = rule;
    }

    public ITreeViewFilterRule getRule() {
        return this.rule;
    }

    @Override
    public Object getInvisibleRoot() {
        return this.nextTreeView.getInvisibleRoot();
    }

    @Override
    public Object getParentNode(Object childNode) {
        Object parent = this.nextTreeView.getParentNode(childNode);
        int action = this.rule.check(parent, this.nextTreeView);
        if (action == 2) {
            return this.getParentNode(parent);
        }
        return parent;
    }

    @Override
    public boolean hasChildNodes(Object parentNode) {
        if (this.nextTreeView.hasChildNodes(parentNode)) {
            Object[] children;
            Object[] objectArray = children = this.nextTreeView.getChildNodes(parentNode);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] childrensChildren;
                Object element = objectArray[n2];
                int action = this.rule.check(element, this.nextTreeView);
                if (action == 1) {
                    return true;
                }
                if ((action == 2 || action == 0) && this.nextTreeView.hasChildNodes(element) && (childrensChildren = this.getChildNodes(element)).length > 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public Object[] getChildNodes(Object parentNode) {
        if (this.nextTreeView.hasChildNodes(parentNode)) {
            Object[] children;
            ArrayList<Object> result = new ArrayList<Object>();
            Object[] objectArray = children = this.nextTreeView.getChildNodes(parentNode);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                int action = this.rule.check(element, this.nextTreeView);
                if (action == 1) {
                    result.add(element);
                } else if ((action == 2 || action == 0) && this.nextTreeView.hasChildNodes(element)) {
                    Object[] childrensChildren;
                    Object[] objectArray2 = childrensChildren = this.getChildNodes(element);
                    int n3 = childrensChildren.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object element2 = objectArray2[n4];
                        result.add(element2);
                        ++n4;
                    }
                }
                ++n2;
            }
            return result.toArray();
        }
        return new Object[0];
    }

    @Override
    public boolean areEqualNodes(Object node1, Object node2) {
        return this.nextTreeView.areEqualNodes(node1, node2);
    }

    @Override
    public int getHashCodeForNode(Object node) {
        return this.nextTreeView.getHashCodeForNode(node);
    }

    @Override
    public IStreamResource getNodeImage(Object node) {
        return this.nextTreeView.getNodeImage(node);
    }

    @Override
    public String getNodeText(Object node) {
        return this.nextTreeView.getNodeText(node);
    }

    @Override
    public void setPresentationContext(PresentationContext presentationContext) {
        this.nextTreeView.setPresentationContext(presentationContext);
    }

    @Override
    public PresentationContext getPresentationContext() {
        return this.nextTreeView.getPresentationContext();
    }

    @Override
    public void dispose() {
        this.nextTreeView.dispose();
    }

    @Override
    public void setupTreeViewListener(ITreeViewListener treeViewListener) {
        this.nextTreeView.setupTreeViewListener(treeViewListener);
    }

    @Override
    public Object getItemForNode(Object node) {
        return this.nextTreeView.getItemForNode(node);
    }

    @Override
    public Object getNodeForItem(Object item) {
        return this.nextTreeView.getNodeForItem(item);
    }
}

