/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry.polygon;

import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.geometry.polygon.PolygonCorner;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class PolygonLine {
    private static final ILogger logger = Logger.getLogger(Line.class);
    public PolygonCorner start;
    public PolygonCorner end;
    public Line line;

    public PolygonLine(PolygonCorner start, PolygonCorner end) {
        assert (start != null) : "start = null";
        assert (end != null) : "end = null";
        this.start = start;
        this.end = end;
        this.initializeLine();
    }

    public void initializeLine() {
        Arc arc1st = this.start.arc;
        Point lineStart = arc1st != null ? arc1st.getTo() : this.start;
        Arc arc2nd = this.end.arc;
        Point lineEnd = arc2nd != null ? arc2nd.getFrom() : this.end;
        this.line = Geo.arcLengthLine(lineStart.x, lineStart.y, lineEnd.x, lineEnd.y) < 1.0E-10 && (arc1st != null || arc2nd != null) ? null : new Line(lineStart, lineEnd);
        assert (this.line != null || arc1st != null || arc2nd != null);
    }

    public Rectangle getOuterBounds() {
        Rectangle bounds = null;
        Arc arc1st = this.start.arc;
        Arc arc2nd = this.end.arc;
        if (arc1st != null) {
            bounds = arc1st.getBounds();
        }
        if (this.line != null) {
            bounds = bounds == null ? this.line.getBounds() : bounds.union(this.line.getBounds());
        }
        if (arc2nd != null) {
            bounds = bounds == null ? arc2nd.getBounds() : bounds.union(arc2nd.getBounds());
        }
        if (bounds == null) {
            bounds = new Rectangle((Point)this.start, this.end);
        }
        return bounds;
    }

    public double getDistanceToBorder(Point point) {
        double d;
        assert (point != null) : "point is null";
        double arc1distance = Double.POSITIVE_INFINITY;
        double linedistance = Double.POSITIVE_INFINITY;
        double arc2distance = Double.POSITIVE_INFINITY;
        if (this.line != null) {
            linedistance = Line.getDistance(this.line.start, this.line.end, point);
        }
        if (this.start.arc != null) {
            Arc startArc = new Arc(this.start.arc.center.x, this.start.arc.center.y, this.start.arc.rx, this.start.arc.ry, this.start.getAngle(), this.start.arc.angleEnd);
            Points startApprox = startArc.getPointsApproximated(Polygon.DEFAULT_DRAWARC_MAXIMUM_NUMBER_OF_POINTS, Polygon.DEFAULT_DRAWARC_POINTS_PER_UNIT);
            arc1distance = startApprox.getDistanceToBorder(point, false);
        }
        if (this.end.arc != null) {
            Arc endArc = new Arc(this.end.arc.center.x, this.end.arc.center.y, this.end.arc.rx, this.end.arc.ry, this.end.arc.angleStart, this.end.getAngle());
            Points endApprox = endArc.getPointsApproximated(Polygon.DEFAULT_DRAWARC_MAXIMUM_NUMBER_OF_POINTS, Polygon.DEFAULT_DRAWARC_POINTS_PER_UNIT);
            arc2distance = endApprox.getDistanceToBorder(point, false);
        }
        if (arc1distance < (d = Double.POSITIVE_INFINITY)) {
            d = arc1distance;
        }
        if (linedistance < d) {
            d = linedistance;
        }
        if (arc2distance < d) {
            d = arc2distance;
        }
        return d;
    }

    public Arc getStartArc() {
        Arc startArc = this.start.arc != null ? new Arc(this.start.arc.center.x, this.start.arc.center.y, this.start.arc.rx, this.start.arc.ry, this.start.getAngle(), this.start.arc.angleEnd) : null;
        return startArc;
    }

    public Arc getEndArc() {
        Arc endArc = this.end.arc != null ? new Arc(this.end.arc.center.x, this.end.arc.center.y, this.end.arc.rx, this.end.arc.ry, this.end.arc.angleStart, this.end.getAngle()) : null;
        return endArc;
    }

    public Point getPoint(double relativePosition) {
        Point point;
        Arc arc1st = this.start.arc;
        Arc arc2nd = this.end.arc;
        double arcLength1st = this.getArcLengthStartingArc(arc1st);
        double arcLengthLine = this.getArcLengthConnectionLine(this.line);
        double arcLength2nd = this.getArcLengthEndArc(arc2nd);
        if (Math.abs(arcLength1st) < 1.0E-10) {
            arc1st = null;
        }
        if (Math.abs(arcLengthLine) < 1.0E-10) {
            this.line = null;
        }
        if (Math.abs(arcLength2nd) < 1.0E-10) {
            arc2nd = null;
        }
        double arcLengthSum = arcLength1st + arcLengthLine + arcLength2nd;
        double absolutePosition = relativePosition * arcLengthSum;
        if (arc1st != null && absolutePosition < arcLength1st + 1.0E-10) {
            double arcLengthToSkip = this.getArcLengthToSkipStartingArc(arc1st);
            point = arc1st.getPoint(arcLengthToSkip + absolutePosition);
        } else {
            point = this.line != null && absolutePosition < arcLength1st + arcLengthLine + 1.0E-10 ? this.line.getPoint(absolutePosition - arcLength1st) : (arc2nd != null && absolutePosition < arcLengthSum + 1.0E-10 ? arc2nd.getPoint(absolutePosition - arcLength1st - arcLengthLine) : new Line(this.start, this.end).getCenter());
        }
        return point;
    }

    private double getArcLengthStartingArc(Arc arc1st) {
        double arcLength1st = 0.0;
        if (arc1st != null) {
            double anglePoint = this.start.getAngle();
            arcLength1st = arc1st.getArcLengthArc(anglePoint, arc1st.angleEnd);
        }
        return arcLength1st;
    }

    private double getArcLengthConnectionLine(Line connectingLine) {
        double arcLengthLine = 0.0;
        if (connectingLine != null) {
            arcLengthLine = connectingLine.arcLength();
        }
        return arcLengthLine;
    }

    private double getArcLengthEndArc(Arc arc2nd) {
        double arcLength2nd = 0.0;
        if (arc2nd != null) {
            double anglePoint = this.end.getAngle();
            arcLength2nd = arc2nd.getArcLengthArc(arc2nd.angleStart, anglePoint);
        }
        return arcLength2nd;
    }

    private double getArcLengthToSkipStartingArc(Arc arc1st) {
        double arcLength2nd = 0.0;
        if (arc1st != null) {
            double anglePoint = this.start.getAngle();
            arcLength2nd = arc1st.getArcLengthArc(arc1st.angleStart, anglePoint);
        }
        return arcLength2nd;
    }

    public boolean equalsPolygonLine(PolygonLine a) {
        return a.start.equalsPoint(this.start) && a.end.equalsPoint(this.end);
    }

    public String toString() {
        return "PolygonLine(start=" + this.start + ", line= " + this.line + ", end=" + this.end + ")";
    }

    @Deprecated
    public boolean equals(Object obj) {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof PolygonLine) {
            PolygonLine a = (PolygonLine)obj;
            return this.equalsPolygonLine(a);
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        return this.start.hashCode() ^ this.end.hashCode();
    }
}

