/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;

public class Sector {
    private double angleStart;
    private double angleEnd;
    private final Point origin;

    public Sector(Point origin, Direction direction1, Direction direction2) {
        this.origin = Point.getAsPoint(origin);
        double angle1 = direction1.getAngle();
        double angle2 = direction2.getAngle();
        double angle1To2Normalized = Geo.getNormalizedAngle(angle2 - angle1);
        if (Geo.isInClosedAngleIntervall(angle1To2Normalized, 0.0, 180.0)) {
            this.angleStart = angle1;
            this.angleEnd = angle2;
        } else {
            this.angleStart = angle2;
            this.angleEnd = angle1;
        }
        if (this.angleEnd < this.angleStart) {
            this.angleEnd += 360.0;
        }
    }

    public boolean isInside(Point p) {
        boolean isInside;
        GeoVector originToPoint = new GeoVector(this.origin, p);
        if (originToPoint.abs() < 1.0E-10) {
            isInside = true;
        } else {
            double angle = originToPoint.getDirection().getAngle();
            isInside = Geo.isInClosedAngleIntervall(angle, this.angleStart, this.angleEnd);
        }
        return isInside;
    }

    public String toString() {
        return "Sector(" + super.toString() + ", " + this.origin + ", " + this.angleStart + ", " + this.angleEnd + ")";
    }
}

