/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.shells;

import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.lib.ui.window.IShell;
import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class EclipseShell
implements IShell {
    private final Shell shell;

    public EclipseShell(Shell shell) {
        this.shell = shell;
    }

    public void showModificationProblemsDialog(Collection<? extends IModificationProblem> modificationProblems, String title, String message) {
        this.showModificationProblemsDialog(this.shell, modificationProblems, title, message);
    }

    public void showModificationProblemsDialog(final Shell parentShell, final Collection<? extends IModificationProblem> modificationProblems, final String title, final String message) {
        Display display = this.shell.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ModificationProblemsDialog.showModificationProblemsDialog(modificationProblems, title, message, parentShell);
            }
        });
    }

    public void showMessageDialog(int level, String title, String message) {
        this.showMessageDialog(this.shell, level, title, message);
    }

    public void showMessageDialog(final Shell parentShell, final int level, final String title, final String message) {
        Display display = this.shell.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                int swtLevel;
                switch (level) {
                    case 4: {
                        swtLevel = 2;
                        break;
                    }
                    case 3: {
                        swtLevel = 4;
                        break;
                    }
                    case 2: {
                        swtLevel = 1;
                        break;
                    }
                    default: {
                        swtLevel = 0;
                    }
                }
                MessageDialog messageDialog = new MessageDialog(parentShell, title, null, message, swtLevel, new String[]{IDialogConstants.OK_LABEL}, 0);
                messageDialog.open();
            }
        });
    }
}

