/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.editors.imports;

import com.arcway.lib.eclipse.Messages;
import com.arcway.lib.eclipse.gui.LineSeparator;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.eclipse.resources.ResourceLoader;
import com.arcway.lib.eclipse.uiframework.IEclipseWindow;
import com.arcway.lib.eclipse.uiframework.widgets.ImportEditorPageWidget;
import com.arcway.lib.icons.Icons16x16;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.dialog.imports.ICompareModeChangeListener;
import com.arcway.lib.ui.dialog.imports.IExceptionHandler;
import com.arcway.lib.ui.dialog.imports.IImportModelAccess;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.IMessage;
import com.arcway.lib.ui.window.IWindow;
import java.util.Locale;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class ImportEditorControl
extends Composite {
    public static final int IMPORTMODE_IGNORE = 0;
    public static final int IMPORTMODE_ADD = 1;
    public static final int IMPORTMODE_MERGE = 2;
    private static final int MAX_LENGTH_OF_ERROR_MESSAGE = 250;
    private final IWindow window;
    private ImportEditorPageWidget pageWidget;
    private final IExceptionHandler exceptionHandler;
    private final FormToolkit toolkit;
    private CTabFolder pageTabFolder;
    private String name;
    private Image titleImage;
    private Font titleFont;
    private Label lbl_icon;
    private StyledText txt_title;
    private Button btn_new;
    private Button btn_merge;
    private boolean isMergeEnabled;
    private final Locale userLocale;
    private ImageHyperlink lnk_error;
    private final IImportModelAccess modelAccess;
    private static final Image propertiesImg = ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/pencil.png").createImage();
    private static final Image linkImg = ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/link.png").createImage();
    private ListenerKey compareModeChangeListenerKey;

    public ImportEditorControl(IWindow window, Composite parent, String name, String toolTipText, ImageDescriptor imageDescriptor, Locale locale, FormToolkit toolkit, IExceptionHandler exceptionHandler, IImportModelAccess modelAccess) {
        super(parent, 0);
        this.window = window;
        this.toolkit = toolkit;
        this.exceptionHandler = exceptionHandler;
        this.name = name;
        this.setToolTipText(toolTipText);
        this.titleImage = imageDescriptor.createImage();
        this.userLocale = locale;
        this.modelAccess = modelAccess;
        this.createControl();
        this.compareModeChangeListenerKey = new ListenerKey();
        modelAccess.addCompareModeChangeListener(this.compareModeChangeListenerKey, new ICompareModeChangeListener(){

            public void dispose() {
                ImportEditorControl.this.unregisterCompareModeCHangeListener();
            }

            public void compareModeChanged() {
                ImportEditorControl.this.updateCompareMode();
                ImportEditorControl.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ImportEditorControl.this.isDisposed() && ImportEditorControl.this.pageWidget != null) {
                            ImportEditorControl.this.pageWidget.reflow();
                            ImportEditorControl.this.pageWidget.reflow();
                        }
                    }
                });
            }
        });
    }

    private void unregisterCompareModeCHangeListener() {
        if (this.compareModeChangeListenerKey != null) {
            this.modelAccess.removeCompareModeChangeListener(this.compareModeChangeListenerKey);
            this.compareModeChangeListenerKey = null;
        }
    }

    protected IExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    private Font getTitleFont(Composite comp_title) {
        if (this.titleFont == null) {
            String defaultFontName = comp_title.getFont().getFontData()[0].getName();
            this.titleFont = new Font((Device)comp_title.getDisplay(), defaultFontName, 11, 1);
        }
        return this.titleFont;
    }

    private void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.setBackground(this.toolkit.getColors().getBackground());
        Composite comp_title = this.toolkit.createComposite((Composite)this, 0);
        GridData gd = new GridData(4, 128, true, false);
        comp_title.setLayoutData((Object)gd);
        TableWrapLayout titleLayout = new TableWrapLayout();
        titleLayout.numColumns = 4;
        titleLayout.makeColumnsEqualWidth = false;
        titleLayout.topMargin = 19;
        titleLayout.bottomMargin = 19;
        comp_title.setLayout((Layout)titleLayout);
        this.lbl_icon = this.toolkit.createLabel(comp_title, this.getToolTipText(), 0);
        this.lbl_icon.setImage(this.titleImage);
        TableWrapData td = new TableWrapData(2, 16, 2, 1);
        this.lbl_icon.setLayoutData((Object)td);
        this.txt_title = new StyledText(comp_title, 8);
        this.txt_title.setText(this.name);
        this.txt_title.setFont(this.getTitleFont(comp_title));
        this.txt_title.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        td = new TableWrapData(2, 16, 2, 1);
        this.txt_title.setLayoutData((Object)td);
        this.btn_new = this.toolkit.createButton(comp_title, Messages.getString("ImportEditor.importmode_new", this.userLocale), 16);
        td = new TableWrapData(2, 16);
        td.indent = 19;
        this.btn_new.setLayoutData((Object)td);
        this.lnk_error = this.toolkit.createImageHyperlink(comp_title, 192);
        this.lnk_error.setText(null);
        td = new TableWrapData(256, 256, 2, 1);
        this.lnk_error.setLayoutData((Object)td);
        this.lnk_error.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                int x = ((Control)e.widget).toDisplay((int)0, (int)0).x + ((ImportEditorControl)ImportEditorControl.this).lnk_error.getBounds().width;
                int y = ((Control)e.widget).toDisplay((int)0, (int)0).y + ((ImportEditorControl)ImportEditorControl.this).lnk_error.getBounds().height;
                ImportEditorControl.this.openAdditionalEditorInfo(new Point(x, y));
            }
        });
        this.lnk_error.setVisible(false);
        this.btn_merge = this.toolkit.createButton(comp_title, Messages.getString("ImportEditor.importmode_merge", this.userLocale), 16);
        td = new TableWrapData(2, 16);
        td.indent = 19;
        this.btn_merge.setLayoutData((Object)td);
        this.addSeparator(this);
        this.pageTabFolder = new CTabFolder((Composite)this, 128);
        gd = new GridData(4, 4, true, true);
        this.pageTabFolder.setLayoutData((Object)gd);
        this.pageTabFolder.setBackground(this.toolkit.getColors().getColor("HIGHLIGHT"));
        this.pageTabFolder.setSelectionBackground(this.toolkit.getColors().getBackground());
    }

    public Locale getUserLocale() {
        return this.userLocale;
    }

    protected void addPage(ImportEditorPageWidget importPageWidget, boolean selected) {
        if (this.pageWidget == null) {
            this.pageWidget = importPageWidget;
        }
        CTabItem tabItemPage = new CTabItem(this.pageTabFolder, 0);
        tabItemPage.setText(importPageWidget.getLabel());
        tabItemPage.setToolTipText(importPageWidget.getTooltipText());
        int type = importPageWidget.getType();
        if (type == 0) {
            tabItemPage.setImage(propertiesImg);
        } else if (type == 1) {
            tabItemPage.setImage(linkImg);
        }
        importPageWidget.setFormToolkit(this.toolkit);
        IWorkbenchPage containingWorkbenchPage = null;
        if (this.window instanceof IEclipseWindow) {
            containingWorkbenchPage = ((IEclipseWindow)this.window).getWorkbenchPage();
        }
        importPageWidget.createWidget((Composite)this.pageTabFolder, containingWorkbenchPage);
        tabItemPage.setControl(importPageWidget.getBaseControl());
        importPageWidget.setImportEditorControl(this);
        if (selected) {
            this.pageTabFolder.setSelection(tabItemPage);
        }
    }

    private void addSeparator(Composite comp_form) {
        LineSeparator separator = new LineSeparator(comp_form, 0, this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        separator.setBackground(this.toolkit.getColors().getBackground());
        GridData gd = new GridData(4, 128, true, false);
        separator.setLayoutData(gd);
    }

    public void deactivate() {
        this.unregisterCompareModeCHangeListener();
    }

    public void dispose() {
        this.titleImage.dispose();
        if (this.titleFont != null) {
            this.titleFont.dispose();
            this.titleFont = null;
        }
        super.dispose();
    }

    protected final void setName(String name) {
        this.name = name;
        this.txt_title.setText(name);
        this.txt_title.getParent().layout();
    }

    protected final void setImage(ImageDescriptor imageDescriptor) {
        Image newTitleImage = imageDescriptor.createImage();
        this.lbl_icon.setImage(newTitleImage);
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        this.titleImage = newTitleImage;
    }

    protected void setupImportMode(int importMode) {
        if (importMode == 1) {
            this.btn_new.setSelection(true);
            this.btn_merge.setSelection(false);
            this.modelAccess.setCompareMode(1);
        } else if (importMode == 2) {
            this.btn_new.setSelection(false);
            this.btn_merge.setSelection(true);
            this.modelAccess.setCompareMode(0);
        }
        this.btn_new.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ImportEditorControl.this.btn_new.getSelection()) {
                    ImportEditorControl.this.modelAccess.setCompareMode(1);
                    try {
                        ImportEditorControl.this.setImportMode(1);
                    }
                    catch (EEXNotReproducibleSnapshot e1) {
                        ImportEditorControl.this.exceptionHandler.handleEEXNotReproducibleSnapshot(e1);
                    }
                }
            }
        });
        if (this.isMergeEnabled) {
            this.btn_merge.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ImportEditorControl.this.btn_merge.getSelection()) {
                        try {
                            ImportEditorControl.this.setImportMode(2);
                        }
                        catch (EEXNotReproducibleSnapshot e1) {
                            ImportEditorControl.this.exceptionHandler.handleEEXNotReproducibleSnapshot(e1);
                        }
                        ImportEditorControl.this.modelAccess.setCompareMode(0);
                    }
                }
            });
        } else {
            this.btn_merge.setEnabled(false);
            this.btn_new.setEnabled(false);
            this.btn_merge.setVisible(false);
            this.btn_new.setVisible(false);
            this.modelAccess.setCompareMode(1);
        }
        this.pageWidget.setupImportMode(importMode, this.btn_new, this.isMergeEnabled, this.btn_merge);
    }

    protected void setupMergeEnabled(boolean mergeEnabled) {
        this.isMergeEnabled = mergeEnabled;
        this.pageWidget.setupMergeEnabled(mergeEnabled);
    }

    public void updateCompareMode() {
        if (this.pageWidget != null) {
            this.pageWidget.updateCompareMode();
        }
    }

    public int getCompareMode() {
        return this.modelAccess.getCompareMode();
    }

    public void setCompareMode(int mode) {
        this.modelAccess.setCompareMode(mode);
    }

    public String getMessage() {
        return this.lnk_error.getText();
    }

    public void setMessage(IMessage message, boolean hasDetails) {
        if (this.lnk_error.isDisposed()) {
            return;
        }
        String errorMessage = message.getText();
        int breakIndex = errorMessage.indexOf(10);
        if (breakIndex != -1) {
            errorMessage = errorMessage.substring(0, breakIndex);
        }
        if (errorMessage.length() > 250) {
            errorMessage = String.valueOf(errorMessage.substring(0, 250)) + "...";
        }
        this.lnk_error.setText(errorMessage);
        int errorLevel = message.getLevel();
        IStreamResource icon16x16 = message.getIcon16x16();
        if (icon16x16 == null) {
            if (errorLevel == 2) {
                this.lnk_error.setImage(ImageCache.getImage(this.getDisplay(), Icons16x16.ERROR));
            } else if (errorLevel == 3) {
                this.lnk_error.setImage(ImageCache.getImage(this.getDisplay(), Icons16x16.WARNING));
            } else if (errorLevel == 4) {
                this.lnk_error.setImage(ImageCache.getImage(this.getDisplay(), Icons16x16.INFO));
            } else {
                this.lnk_error.setImage(null);
            }
        } else {
            this.lnk_error.setImage(ImageCache.getImage(this.getDisplay(), icon16x16));
        }
        if (errorLevel == 2) {
            this.lnk_error.setForeground(this.getDisplay().getSystemColor(3));
        } else if (errorLevel == 3) {
            this.lnk_error.setForeground(this.getDisplay().getSystemColor(8));
        } else if (errorLevel == 4) {
            this.lnk_error.setForeground(this.getDisplay().getSystemColor(28));
        } else {
            this.lnk_error.setForeground(this.getDisplay().getSystemColor(28));
        }
        if (errorMessage.length() == 0 && this.lnk_error.getImage() == null) {
            this.lnk_error.setVisible(false);
        } else {
            this.lnk_error.setVisible(true);
            this.lnk_error.setEnabled(hasDetails);
        }
    }

    protected abstract void openAdditionalEditorInfo(Point var1);

    protected abstract void setImportMode(int var1) throws EEXNotReproducibleSnapshot;
}

