/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class LineSeparator
extends Canvas {
    private final Color colour1;

    public LineSeparator(Composite parent, int style) {
        this(parent, style, parent.getDisplay().getSystemColor(15));
    }

    public LineSeparator(Composite parent, int style, Color colour1) {
        super(parent, style);
        this.colour1 = colour1;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                LineSeparator.this.internalPaintControl(e);
            }
        });
    }

    private void internalPaintControl(PaintEvent e) {
        GC gc = e.gc;
        int height = this.getSize().y;
        int width = this.getSize().x;
        int horizontalBorder = 0;
        int verticalBorder = (height - 2) / 2;
        gc.setBackground(this.getBackground());
        gc.fillRectangle(0, 0, width, height);
        gc.setForeground(this.colour1);
        gc.drawLine(horizontalBorder, verticalBorder, width - horizontalBorder - 1, verticalBorder);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = wHint;
        int height = hHint;
        if (wHint == -1) {
            width = 30;
        }
        if (hHint == -1) {
            height = 1;
        }
        return new Point(width, height);
    }
}

