/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class CheckboxIntegerFieldEditor
extends FieldEditor {
    public static final int DEFAULT = 0;
    public static final int SEPARATE_LABEL = 1;
    private final int style;
    private boolean wasSelected;
    private Button checkBox = null;
    private final String _true;
    private final String _false;

    public CheckboxIntegerFieldEditor(String name, String labelText, int style, Composite parent, String _true, String _false) {
        this.init(name, labelText);
        this.style = style;
        this._true = _true;
        this._false = _false;
        this.createControl(parent);
    }

    public CheckboxIntegerFieldEditor(String name, String label, Composite parent, String _true, String _false) {
        this(name, label, 0, parent, _true, _false);
    }

    protected void adjustForNumColumns(int numColumns) {
        int numColumnsTemp = numColumns;
        if (this.style == 1) {
            ((GridData)this.checkBox.getLayoutData()).horizontalSpan = --numColumnsTemp;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        int numColumnsTemp = numColumns;
        String text = this.getLabelText();
        switch (this.style) {
            case 1: {
                this.getLabelControl(parent);
                --numColumnsTemp;
                text = null;
                break;
            }
            default: {
                this.checkBox = this.getChangeControl(parent);
                GridData gd = new GridData();
                gd.horizontalSpan = numColumnsTemp;
                this.checkBox.setLayoutData((Object)gd);
                if (text == null) break;
                this.checkBox.setText(text);
            }
        }
    }

    protected void doLoad() {
        if (this.checkBox != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.checkBox.setSelection(value.equals(this._true));
            this.wasSelected = value.equals(this._true);
        }
    }

    protected void doLoadDefault() {
        if (this.checkBox != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.checkBox.setSelection(value.equals(this._true));
            this.wasSelected = value.equals(this._true);
        }
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.checkBox.getSelection() ? this._true : this._false);
    }

    public String getStringValue() {
        return this.checkBox.getSelection() ? this._true : this._false;
    }

    protected Button getChangeControl(Composite parent) {
        if (this.checkBox == null) {
            this.checkBox = new Button(parent, 16416);
            this.checkBox.setFont(parent.getFont());
            this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = CheckboxIntegerFieldEditor.this.checkBox.getSelection();
                    CheckboxIntegerFieldEditor.this.valueChanged(CheckboxIntegerFieldEditor.this.wasSelected ? CheckboxIntegerFieldEditor.this._true : CheckboxIntegerFieldEditor.this._false, isSelected ? CheckboxIntegerFieldEditor.this._true : CheckboxIntegerFieldEditor.this._false);
                    CheckboxIntegerFieldEditor.this.wasSelected = isSelected;
                }
            });
            this.checkBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    CheckboxIntegerFieldEditor.this.checkBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.checkBox, parent);
        }
        return this.checkBox;
    }

    public int getNumberOfControls() {
        switch (this.style) {
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    public void setFocus() {
        if (this.checkBox != null) {
            this.checkBox.setFocus();
        }
    }

    public void setLabelText(String text) {
        super.setLabelText(text);
        Label label = this.getLabelControl();
        if (label == null && this.checkBox != null) {
            this.checkBox.setText(text);
        }
    }

    protected void valueChanged(String oldValue, String newValue) {
        this.setPresentsDefaultValue(false);
        if (!oldValue.equals(newValue)) {
            this.fireValueChanged("field_editor_value", oldValue, newValue);
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        if (this.style == 1) {
            super.setEnabled(enabled, parent);
        }
        this.getChangeControl(parent).setEnabled(enabled);
    }
}

