/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.file.tmp;

import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.file.tmp.ITempDirectoryProvider;
import com.arcway.lib.file.tmp.ITempFileProvider;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;

public class CheckOutTempFileProvider
implements ITempDirectoryProvider {
    private static final ILogger LOGGER = Logger.getLogger(CheckOutTempFileProvider.class);
    private static final String CHECKOUT_ROOT_DIRECTORY_PREFIX = "checkout-";
    private static final String CHECKOUT_INDIVIDUAL_FILE_DIRECTORY_PREFIX = "file-";
    private static final int MAXIMUM_FILE_NAME_LENGTH = 40;
    private static SessionTempDirectoryManager.SessionTempDirectory checkOutRoot;
    private final String fileName;

    static {
        try {
            checkOutRoot = SessionTempDirectoryManager.createSessionTempSubDirectory(CHECKOUT_ROOT_DIRECTORY_PREFIX);
        }
        catch (JvmExternalResourceInteractionException e) {
            LOGGER.error("Couldn't create root directory for checking out documents", (Throwable)e);
        }
    }

    public CheckOutTempFileProvider(String fileName) {
        this.fileName = fileName;
    }

    public ITempFileProvider createTemporaryDirectory() {
        return new ITempFileProvider(){

            public File createTemporaryFile() {
                if (checkOutRoot != null) {
                    try {
                        SessionTempDirectoryManager.SessionTempDirectory tempFolder = SessionTempDirectoryManager.createSessionTempSubDirectory(CheckOutTempFileProvider.CHECKOUT_INDIVIDUAL_FILE_DIRECTORY_PREFIX, checkOutRoot);
                        String tempFileName = FileHelper.convertStringToPortableFileName((String)CheckOutTempFileProvider.this.fileName);
                        tempFileName = FileHelper.shortenFileName((String)tempFileName, (int)40);
                        return new File(tempFolder, tempFileName);
                    }
                    catch (JvmExternalResourceInteractionException ex) {
                        LOGGER.error("Couldn't create directory in check out root directory.", (Throwable)ex);
                        return null;
                    }
                }
                return null;
            }
        };
    }
}

