/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.word.util;

import au.com.swz.swttocom.swt.ResourceManager;
import com.arcway.lib.eclipse.ole.word.Application;
import com.arcway.lib.eclipse.ole.word._Application;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class MSWordVersionAndSettingsHelper {
    private static final ILogger LOGGER = Logger.getLogger(MSWordVersionAndSettingsHelper.class);
    private static int wordVersion = -1;
    private static boolean defaultSaveFormatIs2003 = false;
    public static final int VERSIONNUMBER_MSWORD2007 = 12;

    public static int getInstalledVersionOfMSWord() {
        if (wordVersion == -1) {
            MSWordVersionAndSettingsHelper.determineMSWordVersionAndSettings();
        }
        return wordVersion;
    }

    public static boolean getDefaultSaveFormatIs2003() {
        if (wordVersion == -1) {
            MSWordVersionAndSettingsHelper.determineMSWordVersionAndSettings();
        }
        return defaultSaveFormatIs2003;
    }

    private static void determineMSWordVersionAndSettings() {
        try {
            ResourceManager resourceManager = new ResourceManager();
            _Application wordApplication = null;
            try {
                try {
                    wordApplication = Application.create(6, resourceManager, true);
                    defaultSaveFormatIs2003 = wordApplication.get_DefaultSaveFormat().toLowerCase().equals("doc");
                    String version = wordApplication.get_Version();
                    int firstDotIndex = version.indexOf(".");
                    String majorVersion = firstDotIndex >= 0 ? version.substring(0, firstDotIndex) : version;
                    try {
                        int majorVersionAsInt;
                        wordVersion = majorVersionAsInt = Integer.parseInt(majorVersion);
                    }
                    catch (NumberFormatException nfE) {
                        LOGGER.warn("Can not determine MS Word version (= \"" + version + "\"). Assuming no valid MS Word is installed.");
                        wordVersion = -1;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Can not determine MS Word version (exception occurred). Assuming no valid MS Word is installed.", (Throwable)e);
                    wordVersion = -1;
                    try {
                        if (wordApplication != null && wordApplication.get_Documents().get_Count() == 0) {
                            wordApplication.Quit();
                        }
                    }
                    catch (Exception e2) {
                        LOGGER.warn("Failed to Quit() Word Application.", (Throwable)e2);
                    }
                    resourceManager.shutdown();
                }
            }
            finally {
                try {
                    if (wordApplication != null && wordApplication.get_Documents().get_Count() == 0) {
                        wordApplication.Quit();
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to Quit() Word Application.", (Throwable)e);
                }
                resourceManager.shutdown();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can not initialise OLE environment (exception occurred). Assuming no valid MS Word is installed.", (Throwable)e);
            wordVersion = -1;
        }
    }
}

