/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.excel.util;

import au.com.swz.swttocom.swt.ResourceManager;
import com.arcway.lib.eclipse.ole.excel.Application;
import com.arcway.lib.eclipse.ole.excel._Application;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class MSExcelVersionAndSettingsHelper {
    private static final ILogger LOGGER = Logger.getLogger(MSExcelVersionAndSettingsHelper.class);
    private static int excelVersion = -1;
    private static boolean defaultSaveFormatIs2003 = false;
    public static final int VERSIONNUMBER_MSEXCEL2007 = 12;

    public static int getInstalledVersionOfMSExcel() {
        if (excelVersion == -1) {
            MSExcelVersionAndSettingsHelper.determineMSExcelVersionAndSettings();
        }
        return excelVersion;
    }

    public static boolean getDefaultSaveFormatIs2003() {
        if (excelVersion == -1) {
            MSExcelVersionAndSettingsHelper.determineMSExcelVersionAndSettings();
        }
        return defaultSaveFormatIs2003;
    }

    private static void determineMSExcelVersionAndSettings() {
        try {
            ResourceManager resourceManager = new ResourceManager();
            _Application excelApplication = null;
            try {
                try {
                    excelApplication = Application.create(6, resourceManager, true);
                    defaultSaveFormatIs2003 = excelApplication.get_DefaultSaveFormat() == 43;
                    String version = excelApplication.get_Version();
                    int firstDotIndex = version.indexOf(".");
                    String majorVersion = firstDotIndex >= 0 ? version.substring(0, firstDotIndex) : version;
                    try {
                        int majorVersionAsInt;
                        excelVersion = majorVersionAsInt = Integer.parseInt(majorVersion);
                    }
                    catch (NumberFormatException nfE) {
                        LOGGER.warn("Can not determine MS Excel version (= \"" + version + "\"). Assuming no valid MS Excel is installed.");
                        excelVersion = -1;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Can not determine MS Excel version (exception occurred). Assuming no valid MS Excel is installed.", (Throwable)e);
                    excelVersion = -1;
                    try {
                        if (excelApplication != null && excelApplication.get_Workbooks().get_Count() == 0) {
                            excelApplication.Quit();
                        }
                    }
                    catch (Exception e2) {
                        LOGGER.warn("Failed to Quit() Excel Application.", (Throwable)e2);
                    }
                    resourceManager.shutdown();
                }
            }
            finally {
                try {
                    if (excelApplication != null && excelApplication.get_Workbooks().get_Count() == 0) {
                        excelApplication.Quit();
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to Quit() Excel Application.", (Throwable)e);
                }
                resourceManager.shutdown();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can not initialise OLE environment (exception occurred). Assuming no valid MS Excel is installed.", (Throwable)e);
            excelVersion = -1;
        }
    }
}

