/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.eclipse.interFace.gui.actions;

import com.arcway.frontend.definition.lib.ui.editor.repository.RepositoryEditorFactory;
import com.arcway.frontend.eclipse.interFace.Messages;
import com.arcway.frontend.eclipse.interFace.repositoryproviders.EclipseFrontendRepositoryObjectReference;
import com.arcway.frontend.eclipse.interFace.repositoryproviders.EclipseFrontendRepositoryReference;
import com.arcway.lib.eclipse.uiframework.editors.EclipseWindow;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.lib.high.genericmodifications.implementation.type.manager.GenericModificationTypeManager;
import com.arcway.repository.lib.high.genericmodifications.interFace.type.IGenericModificationObjectType;
import com.arcway.repository.lib.high.genericmodifications.interFace.type.manager.IGenericModificationTypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public class NewPlatformObjectActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private Collection<EclipseFrontendRepositoryObjectReference> currentlySelectedRepositoryObjectReferences = Collections.emptyList();
    private IWorkbenchPart workbenchPart;

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentlySelectedRepositoryObjectReferences = this.getSelectedRepositoryObjectReferences(selection);
        action.setEnabled(!this.currentlySelectedRepositoryObjectReferences.isEmpty());
    }

    private Collection<EclipseFrontendRepositoryObjectReference> getSelectedRepositoryObjectReferences(ISelection selection) {
        ArrayList<EclipseFrontendRepositoryObjectReference> selectedRepositoryObjects = new ArrayList<EclipseFrontendRepositoryObjectReference>();
        if (selection != null) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                IRepositoryObject selectedRepositoryObject;
                if (selectedElement instanceof IRepositoryObject) {
                    selectedRepositoryObject = (IRepositoryObject)selectedElement;
                } else if (selectedElement instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)selectedElement;
                    selectedRepositoryObject = (IRepositoryObject)adaptable.getAdapter(IRepositoryObject.class);
                } else {
                    selectedRepositoryObject = null;
                }
                if (selectedRepositoryObject == null || !this.isObjectToShow(selectedRepositoryObject)) continue;
                try {
                    EclipseFrontendRepositoryObjectReference repositoryObjectReference = new EclipseFrontendRepositoryObjectReference(selectedRepositoryObject);
                    selectedRepositoryObjects.add(repositoryObjectReference);
                }
                catch (EclipseFrontendRepositoryReference.EXRepositoryHasNoRepositoryProvider eXRepositoryHasNoRepositoryProvider) {
                }
                catch (EXNotReproducibleSnapshot eXNotReproducibleSnapshot) {
                    // empty catch block
                }
            }
        }
        return selectedRepositoryObjects;
    }

    private boolean isObjectToShow(IRepositoryObject repositoryObject) {
        IRepositoryObjectType repositoryObjectType = repositoryObject.getObjectType();
        IRepositoryTypeManagerRO repositoryTypeManager = repositoryObjectType.getRepositoryTypeManagerRO();
        IGenericModificationTypeManager genericModificationTypeManager = GenericModificationTypeManager.getGenericModificationTypeManager((IRepositoryTypeManagerRO)repositoryTypeManager);
        IGenericModificationObjectType genericModificationObjectType = genericModificationTypeManager.getGenericModificationObjectType(repositoryObjectType);
        boolean isObjectToShow = this.isObjectToShow(genericModificationObjectType);
        return isObjectToShow;
    }

    private boolean isObjectToShow(IGenericModificationObjectType genericModificationObjectType) {
        boolean isObjectToShow = genericModificationObjectType.isCreatableGenerically();
        return isObjectToShow;
    }

    public void run(IAction action) {
        for (EclipseFrontendRepositoryObjectReference repositoryObjectReference : this.currentlySelectedRepositoryObjectReferences) {
            IRepositoryInterfaceRO repositoryInterfaceRO = EclipseFrontendRepositoryReference.findRepositoryInterface(repositoryObjectReference);
            try {
                RepositoryEditorFactory.Input input = RepositoryEditorFactory.createEditorInputForObjectModification((IRepositoryInterfaceRO)repositoryInterfaceRO, (IRepositoryObjectReference)repositoryObjectReference.getRepositoryObjectReference());
                IWorkbenchPage page = this.getPage();
                if (page == null) {
                    throw new NullPointerException("No active workbench part.");
                }
                EclipseWindow window = new EclipseWindow(page);
                window.openEditor((Object)input);
            }
            catch (Exception e) {
                String title = Messages.getString("Actions.editorCanNotBeInitialisedTitle", Locale.getDefault());
                String message = String.valueOf(Messages.getString("Actions.editorCanNotBeInitialisedMessage", Locale.getDefault())) + "\n" + Messages.getString("General.seeErrorLog", Locale.getDefault());
                String[] labels = new String[]{"OK"};
                MessageDialog dialog = new MessageDialog(null, title, null, message, 2, labels, 1);
                dialog.open();
            }
        }
    }

    protected final IWorkbenchPage getPage() {
        if (this.workbenchPart != null) {
            return this.workbenchPart.getSite().getPage();
        }
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null) {
            return activeWindow.getActivePage();
        }
        return null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbenchPart = targetPart;
    }
}

