/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.treeviews;

import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendPropertyType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.treeviews.ITreeViewModelAccessAgent;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryAttributeSetNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryDataItemNode;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.FileResourceInPackage;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertyReference;

public class RepositoryPropertyNode
extends RepositoryDataItemNode {
    private static final IStreamResource DEFAULT_ICON_16x16 = new FileResourceInPackage(RepositoryPropertyNode.class, "green_p.gif");
    private final IRepositoryPropertyReference repositoryPropertyReference;
    private IRepositoryProperty cachedRepositoryProperty;
    private static final ILogger logger = Logger.getLogger(RepositoryPropertyNode.class);

    public RepositoryPropertyNode(IRepositoryProperty repositoryProperty, ITreeViewModelAccessAgent treeViewModelAccessAgent, IRepositoryPropertySetSample snapshotID) throws EXNotReproducibleSnapshot {
        super(treeViewModelAccessAgent, snapshotID);
        this.repositoryPropertyReference = new RepositoryPropertyReference(repositoryProperty);
        this.cachedRepositoryProperty = null;
    }

    @Override
    public RepositoryDataItemNode getParentNode(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryPropertyIntoCache(repositorySnapshot);
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in getParentNode() )");
            return null;
        }
        return new RepositoryAttributeSetNode(this.cachedRepositoryProperty.getAttributeSet(), this.getTreeViewModelAccessAgent(), this.snapshotID);
    }

    @Override
    public boolean hasChildNodes(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        return false;
    }

    @Override
    public Object[] getChildNodes(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        return null;
    }

    @Override
    public String getNodeText(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryPropertyIntoCache(repositorySnapshot);
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in getNodeText() )");
            return "";
        }
        IRepositoryPropertyType repositoryPropertyType = this.cachedRepositoryProperty.getPropertyType();
        ITreeViewModelAccessAgent treeView = this.getTreeViewModelAccessAgent();
        if (treeView == null) {
            return null;
        }
        IFrontendTypeManager frontendTypeManager = treeView.getFrontendTypeManager();
        IFrontendDataType frontendDataType = frontendTypeManager.getFrontendDataType(repositoryPropertyType.getDataType());
        IFrontendPropertyType frontendPropertyType = frontendTypeManager.getFrontendPropertyType(repositoryPropertyType);
        IFrontendLabel valueLabel = frontendDataType.getLabelForValue(this.cachedRepositoryProperty.getValue(), repositoryPropertyType.getDataTypeParameters(), frontendPropertyType.getFrontendDataTypeParameters(), treeView.getPresentationContext());
        IFrontendLabel typeLabel = frontendDataType.getLabel(treeView.getPresentationContext().getLocale());
        IFrontendLabel label = frontendPropertyType.getLabel();
        return String.valueOf(label.getText()) + ": " + valueLabel.getText() + " (" + typeLabel.getText() + ")";
    }

    @Override
    public IStreamResource getNodeImage(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryPropertyIntoCache(repositorySnapshot);
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved!( in getNodeImage() )");
            return null;
        }
        IRepositoryPropertyType repositoryPropertyType = this.cachedRepositoryProperty.getPropertyType();
        ITreeViewModelAccessAgent treeView = this.getTreeViewModelAccessAgent();
        if (treeView == null) {
            return null;
        }
        IFrontendTypeManager frontendTypeManager = treeView.getFrontendTypeManager();
        IFrontendDataType frontendDataType = frontendTypeManager.getFrontendDataType(repositoryPropertyType.getDataType());
        IFrontendPropertyType frontendPropertyType = frontendTypeManager.getFrontendPropertyType(repositoryPropertyType);
        IFrontendLabel valueLabel = frontendDataType.getLabelForValue(this.cachedRepositoryProperty.getValue(), repositoryPropertyType.getDataTypeParameters(), frontendPropertyType.getFrontendDataTypeParameters(), treeView.getPresentationContext());
        IStreamResource icon16x16 = valueLabel.getIcon16x16();
        if (icon16x16 == null) {
            icon16x16 = frontendPropertyType.getLabel().getIcon16x16();
        }
        if (icon16x16 == null) {
            icon16x16 = frontendDataType.getLabel(treeView.getPresentationContext().getLocale()).getIcon16x16();
        }
        if (icon16x16 == null) {
            icon16x16 = DEFAULT_ICON_16x16;
        }
        return icon16x16;
    }

    @Override
    public boolean equals(Object node) {
        if (!(node instanceof RepositoryPropertyNode)) {
            return false;
        }
        if (!super.equals(node)) {
            return false;
        }
        return IRepositoryPropertyReference.REFERENCES_EQUAL_PROPERTY_HASHER.isEqual((Object)this.repositoryPropertyReference, (Object)((RepositoryPropertyNode)node).repositoryPropertyReference);
    }

    @Override
    public int hashCode() {
        return IRepositoryPropertyReference.REFERENCES_EQUAL_PROPERTY_HASHER.getHashCode((Object)this.repositoryPropertyReference);
    }

    private void resolveRepositoryPropertyIntoCache(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot, EXObjectReferenceCannotBeResolved {
        if (this.cachedRepositoryProperty != null && this.cachedRepositoryProperty.getSnapshot() == repositorySnapshot) {
            return;
        }
        this.cachedRepositoryProperty = RepositoryReferences.getPropertyFromReference((IRepositoryPropertyReference)this.repositoryPropertyReference, (IRepositorySnapshotRO)repositorySnapshot);
    }

    @Override
    public Object getItem(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryPropertyIntoCache(repositorySnapshot);
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in getItem() )");
            return null;
        }
        return this.cachedRepositoryProperty;
    }
}

