/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.modificationproblems;

import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.exception.IFrontendException;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.collections.ISortedSet_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.repository.interFace.exceptions.ExceptionLevel;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import java.util.ArrayList;
import java.util.Collection;

public class RepositoryAccessModificationProblem
implements IModificationProblem {
    private final String humanReadableDescriptionOfCause;
    private final String humanReadableDescriptionOfConsequence;
    private final int severity;

    public static Collection<RepositoryAccessModificationProblem> convertIntoModificationProblems(IRepositoryTypeManagerRO repositoryTypeManager, IMessageSet messages, PresentationContext presentationContext, String humanReadableDescriptionOfConsequence) {
        ISortedSet_ repositoryAccessExceptions = messages.getMessages();
        ArrayList<RepositoryAccessModificationProblem> modificationProblems = new ArrayList<RepositoryAccessModificationProblem>(repositoryAccessExceptions.size());
        for (RepositoryAccessException repositoryAccessException : repositoryAccessExceptions) {
            modificationProblems.add(new RepositoryAccessModificationProblem(repositoryTypeManager, repositoryAccessException, presentationContext, humanReadableDescriptionOfConsequence));
        }
        return modificationProblems;
    }

    public RepositoryAccessModificationProblem(IRepositoryTypeManagerRO repositoryTypeManager, RepositoryAccessException repositoryAccessException, PresentationContext presentationContext, String humanReadableDescriptionOfConsequence) {
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
        IFrontendException frontendException = frontendTypeManager.getFrontendException((Exception)repositoryAccessException);
        ExceptionLevel exceptionLevel = repositoryAccessException.getExceptionLevel();
        switch (exceptionLevel) {
            case EXCEPTION: {
                this.severity = 2;
                break;
            }
            case WARNING: {
                this.severity = 3;
                break;
            }
            case INFORMATION: {
                this.severity = 4;
                break;
            }
            default: {
                this.severity = 2;
            }
        }
        this.humanReadableDescriptionOfCause = frontendException.getExceptionMessage(presentationContext);
        this.humanReadableDescriptionOfConsequence = humanReadableDescriptionOfConsequence;
    }

    public String getHumanReadableDescriptionOfCause() {
        return this.humanReadableDescriptionOfCause;
    }

    public String getHumanReadableDescriptionOfConsequence() {
        return this.humanReadableDescriptionOfConsequence;
    }

    public int getSeverity() {
        return this.severity;
    }
}

