/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.implementation.type;

import com.arcway.frontend.definition.lib.implementation.lib.BaseFrontendDeclaration;
import com.arcway.frontend.definition.lib.implementation.type.AbstractFrontendType;
import com.arcway.frontend.definition.lib.implementation.type.FrontendObjectType;
import com.arcway.frontend.definition.lib.implementation.type.FrontendRelationType;
import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.declaration.FrontendModuleTypeDeclaration;
import com.arcway.frontend.definition.lib.interFace.declaration.FrontendObjectTypeDeclaration;
import com.arcway.frontend.definition.lib.interFace.declaration.FrontendRelationTypeDeclaration;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendModuleType;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendObjectType;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendRelationType;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryDeclarationItem;
import com.arcway.repository.interFace.registration.type.module.IRepositoryModuleType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FrontendModuleType
extends AbstractFrontendType
implements IFrontendModuleType {
    private final Map repositoryObjectType2frontendObjectType;
    private final Map repositoryRelationType2frontendRelationType;

    public FrontendModuleType(FrontendTypeManager frontendTypeManager, IRepositoryModuleType repositoryModuleType) {
        super(frontendTypeManager, (IRepositoryDeclarationItem)repositoryModuleType);
        ICollection_ allObjectTypes = repositoryModuleType.getAllObjectTypes();
        this.repositoryObjectType2frontendObjectType = new HashMap(allObjectTypes.size());
        for (IRepositoryObjectType repositoryObjectType : allObjectTypes) {
            FrontendObjectType frontendObjectType = new FrontendObjectType(frontendTypeManager, repositoryObjectType);
            this.repositoryObjectType2frontendObjectType.put(repositoryObjectType, frontendObjectType);
        }
        ICollection_ allRelationTypes = repositoryModuleType.getAllCrossLinkRelationTypes();
        this.repositoryRelationType2frontendRelationType = new HashMap(allRelationTypes.size());
        for (ICrossLinkRepositoryRelationType repositoryRelationType : allRelationTypes) {
            FrontendRelationType frontendRelationType = new FrontendRelationType(frontendTypeManager, repositoryRelationType);
            this.repositoryRelationType2frontendRelationType.put(repositoryRelationType, frontendRelationType);
        }
    }

    @Override
    public IRepositoryModuleType getRepositoryModuleType() {
        return (IRepositoryModuleType)this.getRepositoryDeclarationItem();
    }

    public void loadDeclaration(FrontendModuleTypeDeclaration frontendModuleTypeDeclaration) {
        Locale declarationLocale = frontendModuleTypeDeclaration.getLocale();
        this.loadAbstractDeclaration(declarationLocale, frontendModuleTypeDeclaration, 0);
        ICollection_<FrontendObjectTypeDeclaration> frontendObjectTypeDeclarations = frontendModuleTypeDeclaration.getObjectTypeDeclarations();
        for (FrontendObjectTypeDeclaration frontendObjectTypeDeclaration : frontendObjectTypeDeclarations) {
            IRepositoryObjectTypeID objectTypeID = frontendObjectTypeDeclaration.getRepositoryObjectTypeID();
            IRepositoryObjectType repositoryObjectType = this.getRepositoryTypeManager().getObjectType(objectTypeID);
            FrontendObjectType frontendObjectType = this.getFrontendTypeManagerImplementation().getFrontendObjectTypeImplementation(repositoryObjectType);
            frontendObjectType.loadDeclaration(declarationLocale, frontendObjectTypeDeclaration);
        }
        ICollection_<FrontendRelationTypeDeclaration> frontendRelationTypeDeclarations = frontendModuleTypeDeclaration.getCrossLinkRelationTypeDeclarations();
        for (FrontendRelationTypeDeclaration frontendRelationTypeDeclaration : frontendRelationTypeDeclarations) {
            IRepositoryRelationTypeID relationTypeID = frontendRelationTypeDeclaration.getRepositoryRelationTypeID();
            ICrossLinkRepositoryRelationType repositoryRelationType = this.getRepositoryTypeManager().getCrossLinkRelationType(relationTypeID);
            FrontendRelationType frontendRelationType = this.getFrontendTypeManagerImplementation().getFrontendRelationTypeImplementation(repositoryRelationType);
            frontendRelationType.loadDeclaration(declarationLocale, frontendRelationTypeDeclaration);
        }
    }

    public void loadDeclaration(BaseFrontendDeclaration baseFrontendDeclaration) {
        Locale declarationLocale = baseFrontendDeclaration.getLocale();
        ICollection_<FrontendObjectTypeDeclaration> frontendObjectTypeDeclarations = baseFrontendDeclaration.getObjectTypeDeclarations();
        for (FrontendObjectTypeDeclaration frontendObjectTypeDeclaration : frontendObjectTypeDeclarations) {
            IRepositoryObjectTypeID objectTypeID = frontendObjectTypeDeclaration.getRepositoryObjectTypeID();
            IRepositoryObjectType repositoryObjectType = this.getRepositoryTypeManager().getObjectType(objectTypeID);
            FrontendObjectType frontendObjectType = this.getFrontendTypeManagerImplementation().getFrontendObjectTypeImplementation(repositoryObjectType);
            frontendObjectType.loadDeclaration(declarationLocale, frontendObjectTypeDeclaration);
        }
        ICollection_<FrontendRelationTypeDeclaration> frontendRelationTypeDeclarations = baseFrontendDeclaration.getRelationTypeDeclarations();
        for (FrontendRelationTypeDeclaration frontendRelationTypeDeclaration : frontendRelationTypeDeclarations) {
            IRepositoryRelationTypeID relationTypeID = frontendRelationTypeDeclaration.getRepositoryRelationTypeID();
            ICrossLinkRepositoryRelationType repositoryRelationType = this.getRepositoryTypeManager().getCrossLinkRelationType(relationTypeID);
            FrontendRelationType frontendRelationType = this.getFrontendTypeManagerImplementation().getFrontendRelationTypeImplementation(repositoryRelationType);
            frontendRelationType.loadDeclaration(declarationLocale, frontendRelationTypeDeclaration);
        }
    }

    public FrontendObjectType getFrontendObjectTypeImplementation(IRepositoryObjectType repositoryObjectType) {
        return (FrontendObjectType)this.repositoryObjectType2frontendObjectType.get(repositoryObjectType);
    }

    public FrontendRelationType getFrontendRelationTypeImplementation(ICrossLinkRepositoryRelationType repositoryRelationType) {
        return (FrontendRelationType)this.repositoryRelationType2frontendRelationType.get(repositoryRelationType);
    }

    @Override
    public IFrontendObjectType getFrontendObjectType(IRepositoryObjectType repositoryObjectType) {
        return this.getFrontendObjectTypeImplementation(repositoryObjectType);
    }

    @Override
    public IFrontendRelationType getFrontendRelationType(ICrossLinkRepositoryRelationType repositoryRelationType) {
        return this.getFrontendRelationTypeImplementation(repositoryRelationType);
    }
}

