/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.ppm1.ppm1migrator.messages;

import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.TimestampUtil;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class EOTask
extends EOEncodableObject
implements IPermissionOperand,
ICockpitProjectData {
    public static String XML_NAME = "pmm.task";
    private static final String ATTR_TAG_START = "start";
    private static final String ATTR_TAG_FINISH = "finish";
    private static final String ATTR_TAG_DURATION = "duration";
    private static final String ATTR_TAG_ACTUAL_START = "actualstart";
    private static final String ATTR_TAG_ACTUAL_FINISH = "actualfinish";
    private static final String ATTR_TAG_ACTUAL_DURATION = "actualduration";
    private static final String ATTR_TAG_ACTUAL_WORK = "actualwork";
    private static final String ATTR_TAG_BASELINE_START = "baselinestart";
    private static final String ATTR_TAG_BASELINE_FINISH = "baselinefinish";
    private static final String ATTR_TAG_BASELINE_DURATION = "baselineduration";
    private static final String ATTR_TAG_NAME = "name";
    private static final String ATTR_TAG_PERCENT_WORK_COMPLETE = "percentworkcomplete";
    private static final String ATTR_TAG_WORK = "work";
    private static final String ATTR_TAG_RESOURCE_NAMES = "resourcenames";
    private static final String ATTR_TAG_REMAINING_DURATION = "remainingduration";
    private static final String ATTR_TAG_IS_CRITICAL = "iscritical";
    private static final String ATTR_TAG_PRIORITY = "priority";
    private static final String ATTR_TAG_STATUS = "status";
    private static final String ATTR_TAG_IS_MILESTONE = "ismilestone";
    private static final String ATTR_TAG_ORIGINAL_PERCENT_WORK_COMPLETE = "originalpercentworkcomplete";
    private static final String ATTR_TAG_ORIGINAL_WORK = "originalwork";
    private static final String ATTR_TAG_UID = "uid";
    private static final String ATTR_TAG_EXTERNAL_UID = "externaluid";
    private static final String ATTR_TAG_EXTERNAL_ID = "externalid";
    private static final String ATTR_TAG_PROJECT_UID = "projectuid";
    private static final String ATTR_TAG_PM_PROJECT_UID = "pmprojectuid";
    private static final String ATTR_TAG_PARENT_UID = "parentuid";
    private Timestamp start;
    private Timestamp finish;
    private int duration = 0;
    private Timestamp actualStart;
    private Timestamp actualFinish;
    private int actualDuration = 0;
    private float actualWork = 0.0f;
    private Timestamp baselineStart;
    private Timestamp baselineFinish;
    private int baselineDuration = 0;
    private String name = "";
    private int percentWorkComplete = 0;
    private float work = 0.0f;
    private String resourceNames = "";
    private int remainingDuration = 0;
    private boolean isCritical = false;
    private int priority = -1;
    private int status = 4;
    private boolean isMilestone = false;
    private float originalWork = 0.0f;
    private final Set resourcesOfWorkItems = new HashSet();
    private String uid;
    private String externalUid;
    private String externalId;
    private String projectUid;
    private String pmProjectUid;
    private String parentUID;
    private EOTask parent;
    private final List subTasks = new ArrayList();

    public EOTask() {
        super(XML_NAME);
    }

    public EOTask(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_TAG_START, this.start);
        this.appendAttrToXML(writeContext, ATTR_TAG_FINISH, this.finish);
        this.appendAttrToXML(writeContext, ATTR_TAG_DURATION, this.duration);
        this.appendAttrToXML(writeContext, ATTR_TAG_ACTUAL_START, this.actualStart);
        this.appendAttrToXML(writeContext, ATTR_TAG_ACTUAL_FINISH, this.actualFinish);
        this.appendAttrToXML(writeContext, ATTR_TAG_ACTUAL_DURATION, this.actualDuration);
        this.appendAttrToXML(writeContext, ATTR_TAG_ACTUAL_WORK, this.getActualWork());
        this.appendAttrToXML(writeContext, ATTR_TAG_BASELINE_START, this.baselineStart);
        this.appendAttrToXML(writeContext, ATTR_TAG_BASELINE_FINISH, this.baselineFinish);
        this.appendAttrToXML(writeContext, ATTR_TAG_BASELINE_DURATION, this.baselineDuration);
        this.appendAttrToXML(writeContext, ATTR_TAG_NAME, this.name);
        this.appendAttrToXML(writeContext, ATTR_TAG_PERCENT_WORK_COMPLETE, this.getPercentWorkComplete());
        this.appendAttrToXML(writeContext, ATTR_TAG_WORK, this.work);
        this.appendAttrToXML(writeContext, ATTR_TAG_RESOURCE_NAMES, this.resourceNames);
        this.appendAttrToXML(writeContext, ATTR_TAG_REMAINING_DURATION, this.remainingDuration);
        this.appendAttrToXML(writeContext, ATTR_TAG_IS_CRITICAL, this.isCritical);
        this.appendAttrToXML(writeContext, ATTR_TAG_PRIORITY, this.priority);
        this.appendAttrToXML(writeContext, ATTR_TAG_STATUS, this.status);
        this.appendAttrToXML(writeContext, ATTR_TAG_IS_MILESTONE, this.isMilestone);
        this.appendAttrToXML(writeContext, ATTR_TAG_ORIGINAL_WORK, this.originalWork);
        this.appendAttrToXML(writeContext, ATTR_TAG_UID, this.uid);
        this.appendAttrToXML(writeContext, ATTR_TAG_EXTERNAL_UID, this.externalUid);
        this.appendAttrToXML(writeContext, ATTR_TAG_EXTERNAL_ID, this.externalId);
        this.appendAttrToXML(writeContext, ATTR_TAG_PROJECT_UID, this.projectUid);
        this.appendAttrToXML(writeContext, ATTR_TAG_PM_PROJECT_UID, this.pmProjectUid);
        this.appendAttrToXML(writeContext, ATTR_TAG_PARENT_UID, this.parentUID);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_START)) {
            this.start = this.toTimestamp(value);
        } else if (name.equals(ATTR_TAG_FINISH)) {
            this.finish = this.toTimestamp(value);
        } else if (name.equals(ATTR_TAG_DURATION)) {
            this.duration = Integer.parseInt(value);
        } else if (name.equals(ATTR_TAG_ACTUAL_START)) {
            this.actualStart = this.toTimestamp(value);
        } else if (name.equals(ATTR_TAG_ACTUAL_FINISH)) {
            this.actualFinish = this.toTimestamp(value);
        } else if (name.equals(ATTR_TAG_ACTUAL_DURATION)) {
            this.actualDuration = Integer.parseInt(value);
        } else if (name.equals(ATTR_TAG_ACTUAL_WORK)) {
            this.actualWork = Float.parseFloat(value);
        } else if (name.equals(ATTR_TAG_BASELINE_START)) {
            this.baselineStart = this.toTimestamp(value);
        } else if (name.equals(ATTR_TAG_BASELINE_FINISH)) {
            this.baselineFinish = this.toTimestamp(value);
        } else if (name.equals(ATTR_TAG_BASELINE_DURATION)) {
            this.baselineDuration = Integer.parseInt(value);
        } else if (name.equals(ATTR_TAG_NAME)) {
            this.name = value;
        } else if (name.equals(ATTR_TAG_PERCENT_WORK_COMPLETE)) {
            this.percentWorkComplete = Integer.parseInt(value);
        } else if (name.equals(ATTR_TAG_REMAINING_DURATION)) {
            this.remainingDuration = Integer.parseInt(value);
        } else if (name.equals(ATTR_TAG_RESOURCE_NAMES)) {
            this.resourceNames = value;
        } else if (name.equals(ATTR_TAG_WORK)) {
            this.work = Float.parseFloat(value);
        } else if (name.equals(ATTR_TAG_IS_CRITICAL)) {
            this.isCritical = Boolean.valueOf(value);
        } else if (name.equals(ATTR_TAG_PRIORITY)) {
            this.priority = Integer.parseInt(value);
        } else if (name.equals(ATTR_TAG_STATUS)) {
            this.status = Integer.parseInt(value);
        } else if (name.equals(ATTR_TAG_IS_MILESTONE)) {
            this.isMilestone = Boolean.valueOf(value);
        } else if (name.equals(ATTR_TAG_ORIGINAL_WORK)) {
            this.originalWork = Float.parseFloat(value);
        } else if (name.equals(ATTR_TAG_UID)) {
            this.uid = value;
        } else if (name.equals(ATTR_TAG_EXTERNAL_UID)) {
            this.externalUid = value;
        } else if (name.equals(ATTR_TAG_EXTERNAL_ID)) {
            this.externalId = value;
        } else if (name.equals(ATTR_TAG_PROJECT_UID)) {
            this.projectUid = value;
        } else if (name.equals(ATTR_TAG_PM_PROJECT_UID)) {
            this.pmProjectUid = value;
        } else if (name.equals(ATTR_TAG_PARENT_UID)) {
            this.parentUID = value;
        } else {
            knownAttribute = false;
        }
        return knownAttribute;
    }

    protected boolean hasChildren() {
        return false;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        EOTask task = (EOTask)((Object)obj);
        return this.getProjectUID().equals(task.getProjectUID()) && this.getUID().equals(task.getUID());
    }

    public int hashCode() {
        return (String.valueOf(this.getProjectUID()) + this.getUID()).hashCode();
    }

    public EOTask copy() {
        EOTask task = new EOTask();
        task.setUid(this.getUID());
        task.setExternalTaskUid(this.getExternalTaskUid());
        task.setExternalTaskId(this.getExternalTaskId());
        task.setProjectUid(this.getProjectUID());
        task.setPMProjectUid(this.getPMProjectUid());
        task.setParentUid(this.getParentUid());
        if (this.getStart() != null) {
            task.setStart(new Timestamp(this.getStart().getTime()));
        }
        if (this.getFinish() != null) {
            task.setFinish(new Timestamp(this.getFinish().getTime()));
        }
        task.setDuration(this.getDuration());
        if (this.getActualStart() != null) {
            task.setActualStart(new Timestamp(this.getActualStart().getTime()));
        }
        if (this.getActualFinish() != null) {
            task.setActualFinish(new Timestamp(this.getActualFinish().getTime()));
        }
        task.setActualDuration(this.getActualDuration());
        if (this.getBaselineStart() != null) {
            task.setBaselineStart(new Timestamp(this.getBaselineStart().getTime()));
        }
        if (this.getBaselineFinish() != null) {
            task.setBaselineFinish(new Timestamp(this.getBaselineFinish().getTime()));
        }
        task.setBaselineDuration(this.getBaselineDuration());
        task.setName(this.getName());
        task.setWork(this.getWork());
        task.setResourceNames(this.getResourceNames());
        task.setRemainingDuration(this.getRemainingDuration());
        task.setIsCritical(this.getIsCritical());
        task.setPriority(this.getPriority());
        task.setStatus(this.getStatus());
        task.setIsMilestone(this.getIsMilestone());
        task.setOriginalWork(this.getOriginalWork());
        task.setParent(this.getParent());
        for (EOTask subTask : this.subTasks) {
            task.addSubTask(subTask);
        }
        return task;
    }

    public int getSubTasksCount() {
        return this.subTasks.size();
    }

    public EOTask getSubTask(int index) {
        return (EOTask)((Object)this.subTasks.get(index));
    }

    public void addSubTask(EOTask task) {
        assert (task != null) : "task is null";
        this.subTasks.add(task);
        task.setParent(this);
        task.setParentUid(this.getUID());
    }

    public void removeSubTask(EOTask task) {
        assert (task != null) : "task is null";
        this.subTasks.remove((Object)task);
    }

    public void removeSubTask(int index) {
        this.subTasks.remove(index);
    }

    public Object[] getSubTasksArray() {
        return this.subTasks.toArray();
    }

    public void clearSubTasks() {
        this.subTasks.clear();
    }

    public int getDuration() {
        return this.duration;
    }

    public Timestamp getFinish() {
        return this.finish;
    }

    public Timestamp getStart() {
        return this.start;
    }

    public int getActualDuration() {
        return this.actualDuration;
    }

    public Timestamp getActualFinish() {
        return this.actualFinish;
    }

    public Timestamp getActualStart() {
        return this.actualStart;
    }

    public float getActualWork() {
        return this.actualWork;
    }

    public int getBaselineDuration() {
        return this.baselineDuration;
    }

    public Timestamp getBaselineFinish() {
        return this.baselineFinish;
    }

    public Timestamp getBaselineStart() {
        return this.baselineStart;
    }

    public String getName() {
        if (this.name == null) {
            return " ";
        }
        return this.name;
    }

    public int getPercentWorkComplete() {
        float totalWork = this.getWork();
        if (totalWork == 0.0f) {
            if (this.getActualWork() == 0.0f) {
                return 0;
            }
            return 100;
        }
        return (int)(100.0f * this.getActualWork() / totalWork);
    }

    public int getRemainingDuration() {
        return this.remainingDuration;
    }

    public String getResourceNames() {
        return this.resourceNames;
    }

    public float getWork() {
        return this.work;
    }

    public boolean getIsCritical() {
        return this.isCritical;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean hasOrIsFutureTask() {
        if (this.getSubTasksCount() > 0) {
            int i = 0;
            while (i < this.getSubTasksCount()) {
                EOTask child = this.getSubTask(i);
                if (child.hasOrIsFutureTask()) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return this.getPercentWorkComplete() != 100 && this.getStart() != null && this.getFinish() != null && System.currentTimeMillis() < this.getStart().getTime();
    }

    public int getCalculatedStatus() {
        int status = -1;
        if (this.getSubTasksCount() > 0) {
            int i = 0;
            while (i < this.getSubTasksCount()) {
                EOTask child = this.getSubTask(i);
                int childStatus = child.getCalculatedStatus();
                if (childStatus == 2) {
                    status = 2;
                    break;
                }
                if (childStatus == 3) {
                    status = status == 0 || status == 1 ? 1 : 3;
                } else if (childStatus == 0) {
                    status = status == 3 || status == 1 ? 1 : 0;
                } else if (childStatus == 1) {
                    status = 1;
                }
                ++i;
            }
        } else {
            status = this.getPercentWorkComplete() == 100 ? 0 : (this.getStart() == null || this.getFinish() == null ? 4 : (System.currentTimeMillis() < this.getStart().getTime() ? 3 : (System.currentTimeMillis() > this.getFinish().getTime() ? 2 : 1)));
        }
        if (status == -1) {
            status = 4;
        }
        return status;
    }

    public boolean getIsMilestone() {
        return this.isMilestone;
    }

    public int getOriginalPercentWorkComplete() {
        return (int)(100.0f * this.getActualWork() / this.getOriginalWork());
    }

    public float getOriginalWork() {
        assert (this.originalWork >= 0.0f);
        return this.originalWork;
    }

    public String getUID() {
        return this.uid;
    }

    public String getExternalTaskUid() {
        return this.externalUid;
    }

    public String getExternalTaskId() {
        return this.externalId;
    }

    public String getProjectUID() {
        return this.projectUid;
    }

    public String getPMProjectUid() {
        return this.pmProjectUid;
    }

    public String getParentUid() {
        return this.parentUID;
    }

    public EOTask getParent() {
        return this.parent;
    }

    public int getExternalTaskIDasInt() {
        if (this.externalId == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.externalId);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setDuration(int duration) {
        assert (duration >= 0) : "duration < 0";
        this.duration = duration;
    }

    public void setFinish(Timestamp finish) {
        this.finish = finish;
    }

    public void setStart(Timestamp start) {
        this.start = start;
    }

    public void setActualDuration(int duration) {
        assert (duration >= 0) : "duration < 0";
        this.actualDuration = duration;
    }

    public void setActualFinish(Timestamp finish) {
        this.actualFinish = finish;
    }

    public void setActualStart(Timestamp start) {
        this.actualStart = start;
    }

    public void setActualWork(float work) {
        this.actualWork = work;
    }

    public void setBaselineDuration(int duration) {
        assert (duration >= 0) : "duration < 0";
        this.baselineDuration = duration;
    }

    public void setBaselineFinish(Timestamp finish) {
        this.baselineFinish = finish;
    }

    public void setBaselineStart(Timestamp start) {
        this.baselineStart = start;
    }

    public void setName(String name) {
        assert (name != null) : "name is null";
        this.name = name;
    }

    public void setRemainingDuration(int duration) {
        assert (duration >= 0) : "duration < 0";
        this.remainingDuration = duration;
    }

    public void setResourceNames(String string) {
        this.resourceNames = string;
    }

    public void setWork(float work) {
        assert ((double)work >= 0.0) : "work < 0";
        this.work = work;
    }

    public void setIsCritical(boolean isCritical) {
        this.isCritical = isCritical;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setIsMilestone(boolean isMilestone) {
        this.isMilestone = isMilestone;
    }

    public void setOriginalWork(float f) {
        assert (f >= 0.0f);
        this.originalWork = f;
    }

    public void setUid(String UID) {
        assert (UID != null) : "task UID is null";
        this.uid = UID;
    }

    public void setExternalTaskUid(String UID) {
        this.externalUid = UID;
    }

    public void setExternalTaskId(String ID) {
        assert (ID != null) : "external task ID is null";
        this.externalId = ID;
    }

    public void setProjectUid(String UID) {
        assert (UID != null) : "project UID is null";
        this.projectUid = UID;
    }

    public void setPMProjectUid(String UID) {
        assert (UID != null) : "pm project UID is null";
        this.pmProjectUid = UID;
    }

    public void setParentUid(String uid) {
        this.parentUID = uid;
    }

    public void setParent(EOTask parent) {
        this.parent = parent;
    }

    public void clearResourcesOfWorkItems() {
        this.resourcesOfWorkItems.clear();
    }

    public boolean addRessourceOfWorkItem(String resourceName) {
        return this.resourcesOfWorkItems.add(resourceName);
    }

    public String getResourcesOfWorkItemsAsCommaSeperatedString() {
        Object[] names = this.resourcesOfWorkItems.toArray();
        String nameString = null;
        int i = 0;
        while (i < names.length) {
            nameString = i == 1 ? (String)names[i] : String.valueOf(nameString) + "," + (String)names[i];
            ++i;
        }
        return nameString;
    }

    public String[] getResourcesOfWorkItems() {
        Object[] names = this.resourcesOfWorkItems.toArray();
        String[] nameStrings = new String[names.length];
        int i = 0;
        while (i < names.length) {
            nameStrings[i] = (String)names[i];
            ++i;
        }
        return nameStrings;
    }

    public String getPermissionOperandDisplayName() {
        return this.getName();
    }

    public String getPermissionOperandType() {
        return "treeElement";
    }

    public String getPermissionOperandUID() {
        return this.getUID();
    }

    public String getTypeID() {
        return "com.arcway.msp.task";
    }

    public static final boolean haveEqualAttributes(EOTask t1, EOTask t2) {
        boolean equal = t1.getActualDuration() == t2.getActualDuration() && t1.getActualWork() == t2.getActualWork() && TimestampUtil.equals((Timestamp)t1.getActualFinish(), (Timestamp)t2.getActualFinish()) && TimestampUtil.equals((Timestamp)t1.getActualStart(), (Timestamp)t2.getActualStart()) && TimestampUtil.equals((Timestamp)t1.getBaselineFinish(), (Timestamp)t2.getBaselineFinish()) && TimestampUtil.equals((Timestamp)t1.getBaselineStart(), (Timestamp)t2.getBaselineStart()) && t1.getBaselineDuration() == t2.getBaselineDuration() && t1.getDuration() == t2.getDuration() && StringUtil.equals((String)t1.getExternalTaskId(), (String)t2.getExternalTaskId()) && StringUtil.equals((String)t1.getExternalTaskUid(), (String)t2.getExternalTaskUid()) && TimestampUtil.equals((Timestamp)t1.getFinish(), (Timestamp)t2.getFinish()) && t1.getIsCritical() == t2.getIsCritical() && t1.getIsMilestone() == t2.getIsMilestone() && StringUtil.equals((String)t1.getName(), (String)t2.getName()) && t1.getOriginalPercentWorkComplete() == t2.getOriginalPercentWorkComplete() && t1.getOriginalWork() == t2.getOriginalWork() && StringUtil.equals((String)t1.getParentUid(), (String)t2.getParentUid()) && t1.getPriority() == t2.getPriority() && StringUtil.equals((String)t1.getPMProjectUid(), (String)t2.getPMProjectUid()) && StringUtil.equals((String)t1.getProjectUID(), (String)t2.getProjectUID()) && t1.getRemainingDuration() == t2.getRemainingDuration() && StringUtil.equals((String)t1.getResourceNames(), (String)t2.getResourceNames()) && TimestampUtil.equals((Timestamp)t1.getStart(), (Timestamp)t2.getStart()) && t1.getStatus() == t2.getStatus() && t1.getWork() == t2.getWork();
        return equal;
    }

    public int getCommitCount() {
        return 0;
    }
}

