/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.util;

import com.arcway.cockpit.modulelib2.client.util.LocalisedLabelWithKey;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.localisation.ILabelProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LabelProvider
implements ILabelProvider {
    private final Map<String, String> map_language_label = new HashMap<String, String>();
    private String defaultLabel;
    private boolean hasRealDefault = false;

    public LabelProvider(String localisationCode) {
        if (localisationCode == null) {
            return;
        }
        ArrayList localisations = StringUtil.split((String)localisationCode, (char)';');
        int c = 0;
        while (c < localisations.size()) {
            ArrayList localisationPair = StringUtil.split((String)((String)localisations.get(c)), (char)':', (int)2);
            if (localisationPair.size() == 1) {
                this.defaultLabel = (String)localisationPair.get(0);
                this.hasRealDefault = true;
            } else if (localisationPair.size() == 2) {
                this.map_language_label.put((String)localisationPair.get(0), (String)localisationPair.get(1));
                if (c == 0) {
                    this.defaultLabel = (String)localisationPair.get(1);
                    this.hasRealDefault = false;
                }
            }
            ++c;
        }
    }

    public String getLabel(Locale locale) {
        String label = this.map_language_label.get(locale.getLanguage());
        if (label == null) {
            label = this.map_language_label.get(null);
        }
        if (label == null) {
            label = this.defaultLabel;
        }
        return label;
    }

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public LocalisedLabelWithKey getLocalisedLabel(String key) {
        LocalisedLabelWithKey localisedLabel = new LocalisedLabelWithKey(key);
        for (Map.Entry<String, String> language_label_entry : this.map_language_label.entrySet()) {
            localisedLabel.addLocalisation(language_label_entry.getKey(), language_label_entry.getValue());
        }
        if (this.defaultLabel != null) {
            localisedLabel.addLocalisation(null, this.defaultLabel);
        }
        return localisedLabel;
    }
}

