/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.platformadapter;

import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.links.IFrameLinkManager;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.crossmodulelinks.CrossModuleLinkManager;
import com.arcway.cockpit.modulelib2.client.core.crossmodulelinks.ICrossModuleLinkType;
import com.arcway.cockpit.modulelib2.client.platformadapter.AbstractLinkManagerAdapter;
import com.arcway.cockpit.modulelib2.client.platformadapter.PlatformAdaptorConstants;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.LabelHelper;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.ILicenseTypeProvider;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.ILinkManagerInterfaceForPlatformAdapter;
import com.arcway.lib.java.collectionmaps.ISetMapWithFixReturnSetsRO;
import com.arcway.lib.java.collectionmaps.ImmutableSetMap;
import com.arcway.repository.clientadapter.interFace.CardinalityType;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.ILabel;
import com.arcway.repository.clientadapter.interFace.IRelationContribution;
import com.arcway.repository.clientadapter.interFace.IRelationContributionForPermissionCheck;
import com.arcway.repository.clientadapter.interFace.Label;
import com.arcway.repository.cockpit.interFace.declaration.frame.modules.COTIDsModuleData;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LinkManagerAdapter_CrossModuleLink
extends AbstractLinkManagerAdapter {
    private final ICrossModuleLinkType linkType;
    private final Map<String, String> map_cockpitTypeID_moduleID;
    private final Map<String, ILicenseTypeProvider> map_moduleID_licenseTypeProvider;
    private final ProjectAgent projectAgent;

    public LinkManagerAdapter_CrossModuleLink(ICrossModuleLinkType linkType, Map<String, String> map_cockpitTypeID_moduleID, ILinkManagerInterfaceForPlatformAdapter linkManager, RepositoryIDCreator repositoryIDCreator, ProjectAgent projectAgent, Map<String, ILicenseTypeProvider> map_moduleID_licenseTypeProvider) {
        super(linkManager, null, null, repositoryIDCreator);
        this.linkType = linkType;
        this.map_cockpitTypeID_moduleID = map_cockpitTypeID_moduleID;
        this.map_moduleID_licenseTypeProvider = map_moduleID_licenseTypeProvider;
        this.projectAgent = projectAgent;
    }

    public IRepositoryRelationTypeID getRepositorySuperRelationTypeID() {
        return PlatformAdaptorConstants.RELATION_TYPE_ID_ABSTRACTCROSSMODULEDATALINK;
    }

    public ILabel[] getLabels() {
        return LabelHelper.getLabels(this.linkType.getName(), null);
    }

    @Override
    protected String getCockpitLinkTypeID() {
        return this.linkType.getId();
    }

    @Override
    protected String getLinkableObjectRoleID() {
        return "referredItem";
    }

    @Override
    protected IRepositoryRelationContributionRoleID getRelationContributionRoleIDForLinkableObject() {
        return this.repositoryIDCreator.createRepositoryRelationContributionRoleID(PlatformAdaptorConstants.RELATION_TYPE_ID_ABSTRACTCROSSMODULEDATALINK, this.getLinkableObjectRoleID());
    }

    @Override
    protected IRepositoryObjectTypeID getLinkableObjectObjectTypeID() {
        if (this.linkType.getAllowedTypesForLinkableObjectContribution() != CrossModuleLinkManager.ALLOW_ALL_MODULEDATA_TYPES && this.linkType.getAllowedTypesForLinkableObjectContribution().size() == 1) {
            String allowedTypeCockpitTypeID = this.linkType.getAllowedTypesForLinkableObjectContribution().iterator().next();
            String moduleID = RepositoryIDCreator.getCoreTypeID(this.map_cockpitTypeID_moduleID.get(allowedTypeCockpitTypeID));
            return new RepositoryIDCreator(moduleID, "declaration_module_coremodule").createObjectTypeIDForRealType(allowedTypeCockpitTypeID);
        }
        return COTIDsModuleData.OBJECT_TYPE_ID;
    }

    @Override
    protected CardinalityType getLinkableObjectCardinality() {
        if (this.linkType.getLinkableObjectCardinality() != null && this.linkType.getLinkableObjectCardinality().equals("none-or-one")) {
            return CardinalityType.C0_1;
        }
        return CardinalityType.C0_n_NOT_CONFLICTING;
    }

    @Override
    protected ILabel[] getLinkableObjectRoleLabels() {
        if (this.linkType.getLinkableObjectContributionName() != null) {
            return LabelHelper.getLabels(this.linkType.getLinkableObjectContributionName(), null);
        }
        return Label.createLabels(Messages.class, (String)"CrossModuleLinks.General.RoleReferredItem", null);
    }

    @Override
    protected String getModuleDataRoleID() {
        return "referringItem";
    }

    @Override
    protected IRepositoryRelationContributionRoleID getRelationContributionRoleIDForModuleData() {
        return this.repositoryIDCreator.createRepositoryRelationContributionRoleID(PlatformAdaptorConstants.RELATION_TYPE_ID_ABSTRACTCROSSMODULEDATALINK, this.getModuleDataRoleID());
    }

    @Override
    protected IRepositoryObjectTypeID getModuleDataObjectTypeID() {
        if (this.linkType.getAllowedTypesForModuleDataContribution() != CrossModuleLinkManager.ALLOW_ALL_MODULEDATA_TYPES && this.linkType.getAllowedTypesForModuleDataContribution().size() == 1) {
            String allowedTypeCockpitTypeID = this.linkType.getAllowedTypesForModuleDataContribution().iterator().next();
            String moduleID = RepositoryIDCreator.getCoreTypeID(this.map_cockpitTypeID_moduleID.get(allowedTypeCockpitTypeID));
            return new RepositoryIDCreator(moduleID, "declaration_module_coremodule").createObjectTypeIDForRealType(allowedTypeCockpitTypeID);
        }
        return COTIDsModuleData.OBJECT_TYPE_ID;
    }

    @Override
    protected CardinalityType getModuleDataCardinality() {
        if (this.linkType.getModuleDataCardinality() != null && this.linkType.getModuleDataCardinality().equals("none-or-one")) {
            return CardinalityType.C0_1;
        }
        return CardinalityType.C0_n_NOT_CONFLICTING;
    }

    @Override
    protected ILabel[] getModuleDataRoleLabels() {
        if (this.linkType.getModuleDataContributionName() != null) {
            return LabelHelper.getLabels(this.linkType.getModuleDataContributionName(), null);
        }
        return Label.createLabels(Messages.class, (String)"CrossModuleLinks.General.RoleReferringItem", null);
    }

    @Override
    protected Collection<? extends ICockpitProjectData> getLinkableObjects(String moduleDataUID) {
        return CrossModuleLinkManager.getInstance(this.projectAgent.getProjectUID()).getLinkableObjects(moduleDataUID, this.linkType.getId());
    }

    @Override
    protected Collection<? extends ICockpitProjectData> getModuleDataItems(String linkableObjectUID) {
        return CrossModuleLinkManager.getInstance(this.projectAgent.getProjectUID()).getModuleDataItems(linkableObjectUID, this.linkType.getId());
    }

    @Override
    protected ISetMapWithFixReturnSetsRO<String, EOLink> getAllLinksMappedByLinkableObjectUID() {
        IFrameLinkManager frameLinkManager = this.projectAgent.getLinkManager();
        ISetMapWithFixReturnSetsRO<String, EOLink> linksForLinkType = this.linkManager.getLinksForLinkType(this.linkType.getId());
        HashMap newMapping = new HashMap(linksForLinkType.keySet().size() * 2);
        boolean newMappingIsReduced = false;
        for (String loUID : linksForLinkType.keySet()) {
            Set loValues = linksForLinkType.get((Object)loUID);
            HashSet<EOLink> scratchValueSet = new HashSet<EOLink>(loValues.size() * 2);
            boolean loValuesReduced = false;
            ICockpitProjectData linkableObject = null;
            for (EOLink link : loValues) {
                if (linkableObject == null && (linkableObject = frameLinkManager.getLinkableObject(link)) == null) {
                    newMappingIsReduced = true;
                    break;
                }
                if (frameLinkManager.getModuleDataItem(link) != null) {
                    scratchValueSet.add(link);
                    continue;
                }
                loValuesReduced = true;
                newMappingIsReduced = true;
            }
            if (linkableObject == null) continue;
            if (!loValuesReduced) {
                newMapping.put(loUID, loValues);
                continue;
            }
            if (scratchValueSet.isEmpty()) continue;
            newMapping.put(loUID, Collections.unmodifiableSet(scratchValueSet));
        }
        if (!newMappingIsReduced) {
            return linksForLinkType;
        }
        return new ImmutableSetMap(newMapping);
    }

    @Override
    protected EOLink getLink(String moduleDataUID, String linkableObjectUID) {
        for (EOLink link : this.linkManager.getLinksForLinkableObject(linkableObjectUID, this.linkType.getId())) {
            if (!link.getModuleDataUID().equals(moduleDataUID) || this.projectAgent.getLinkManager().getLinkableObject(link) == null || this.projectAgent.getLinkManager().getModuleDataItem(link) == null) continue;
            return link;
        }
        return null;
    }

    @Override
    protected boolean isPropertyOfModuleDataItems() {
        return false;
    }

    public boolean isCreatableAndDeletableGenerically() {
        return true;
    }

    public void checkPermissionForCreateOrDeleteLink(IRelationContributionForPermissionCheck[] relationContributions) throws EXCockpitPermissionDenied {
        if (this.retrieveModuleDataContribution((IRelationContribution[])relationContributions) != null && this.linkType.getAllowedTypesForModuleDataContribution() != CrossModuleLinkManager.ALLOW_ALL_MODULEDATA_TYPES) {
            this.checkLicenseForCockpitType(this.linkType.getAllowedTypesForModuleDataContribution().iterator().next());
        }
        if (this.retrieveLinkableObjectContribution((IRelationContribution[])relationContributions) != null && this.linkType.getAllowedTypesForLinkableObjectContribution() != CrossModuleLinkManager.ALLOW_ALL_MODULEDATA_TYPES) {
            this.checkLicenseForCockpitType(this.linkType.getAllowedTypesForLinkableObjectContribution().iterator().next());
        }
        CrossModuleLinkManager crossModuleLinkManager = CrossModuleLinkManager.getInstance(this.projectAgent.getProjectUID());
        IRelationContributionForPermissionCheck[] iRelationContributionForPermissionCheckArray = relationContributions;
        int n = relationContributions.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<String> allowedTypesForContribution;
            IRelationContributionForPermissionCheck relationContribution = iRelationContributionForPermissionCheckArray[n2];
            boolean isModuleDataContribution = IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)relationContribution.getRepositoryRelationContributionRoleID(), (Object)this.getRelationContributionRoleIDForModuleData());
            Collection<String> collection = allowedTypesForContribution = isModuleDataContribution ? this.linkType.getAllowedTypesForModuleDataContribution() : this.linkType.getAllowedTypesForLinkableObjectContribution();
            if (allowedTypesForContribution != CrossModuleLinkManager.ALLOW_ALL_MODULEDATA_TYPES && relationContribution.getDataTypeIDOfTheDatasAncestor() == null) {
                boolean hasPermission;
                boolean bl = hasPermission = isModuleDataContribution ? crossModuleLinkManager.checkPermissionForLinkingAndUnlinking_ModuleData(relationContribution.getCockpitDataUID(), this.linkType.getId()) : crossModuleLinkManager.checkPermissionForLinkingAndUnlinking_LinkableObject(relationContribution.getCockpitDataUID(), this.linkType.getId());
                if (!hasPermission) {
                    throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied")});
                }
            }
            ++n2;
        }
    }

    private void checkLicenseForCockpitType(String cockpitTypeID) throws EXCockpitPermissionDenied {
        String moduleID = this.map_cockpitTypeID_moduleID.get(cockpitTypeID);
        ILicenseTypeProvider licenseTypeProvider = this.map_moduleID_licenseTypeProvider.get(moduleID);
        IClientFunctionLicenseType2 licenseType = licenseTypeProvider.getModificationLicenseType();
        if (licenseType != null && !this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)licenseType)) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied.NoLicense")});
        }
    }
}

