/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.platformadapter;

import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.messages.ILinkTypeHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.platformadapter.AbstractLinkManagerAdapter_ModuleDataLinks;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.LabelHelper;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.ILicenseTypeProvider;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.ILinkManagerInterfaceForPlatformAdapter;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.IModuleDataTypeDescriptionForPlatformAdapter;
import com.arcway.lib.UUIDGenerator;
import com.arcway.repository.clientadapter.interFace.CardinalityType;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.ILabel;
import com.arcway.repository.clientadapter.interFace.IRelationContribution;
import com.arcway.repository.clientadapter.interFace.IRelationContributionForPermissionCheck;

public class LinkManagerAdapter_AttributeLinkToModuleData
extends AbstractLinkManagerAdapter_ModuleDataLinks {
    public static final String OBJECT_ROLE_ID = "object";
    public static final String ATTRIBUTE_ROLE_ID = "attribute";
    private final IModuleDataTypeDescriptionForPlatformAdapter dataTypeDescription;
    private final String attributeID;
    private final ILicenseTypeProvider licenseTypeProvider;
    private final IFrameProjectAgent projectAgent;

    public LinkManagerAdapter_AttributeLinkToModuleData(IFrameProjectAgent projectAgent_, ILinkManagerInterfaceForPlatformAdapter linkManager, AbstractDataMgr dataManager, IModuleDataTypeDescriptionForPlatformAdapter dataTypeDescription, String attributeID, ILinkTypeHelper linkTypeHelper, ILicenseTypeProvider licenseTypeProvider, RepositoryIDCreator repositoryIDCreator) {
        super(linkManager, dataManager, linkTypeHelper, repositoryIDCreator);
        this.dataTypeDescription = dataTypeDescription;
        this.attributeID = attributeID;
        this.licenseTypeProvider = licenseTypeProvider;
        this.projectAgent = projectAgent_;
    }

    @Override
    protected String getCockpitLinkTypeID() {
        return this.dataTypeDescription.getLinkTypeIDForLinkedModuleDataAttribute(this.attributeID);
    }

    @Override
    protected CardinalityType getLinkableObjectCardinality() {
        return CardinalityType.C0_n_NOT_CONFLICTING;
    }

    @Override
    protected String getLinkableObjectDataTypeID() {
        return this.dataTypeDescription.getModuleDataTypeIDForLinkedModuleDataAttribute(this.attributeID);
    }

    @Override
    protected String getLinkableObjectRoleID() {
        return ATTRIBUTE_ROLE_ID;
    }

    @Override
    protected CardinalityType getModuleDataCardinality() {
        if (this.dataTypeDescription.isMandatoryAttribute(this.attributeID)) {
            return CardinalityType.C1_1_AS_PROPERTY;
        }
        return CardinalityType.C0_1_AS_PROPERTY;
    }

    @Override
    protected String getModuleDataDataTypeID() {
        return this.dataTypeDescription.getTypeID();
    }

    @Override
    protected String getModuleDataRoleID() {
        return OBJECT_ROLE_ID;
    }

    public ILabel[] getLabels() {
        return new ILabel[0];
    }

    public boolean isCreatableAndDeletableGenerically() {
        return true;
    }

    @Override
    protected ILabel[] getLinkableObjectRoleLabels() {
        return LabelHelper.getLabelsForAttribute(this.dataTypeDescription, this.attributeID);
    }

    @Override
    protected ILabel[] getModuleDataRoleLabels() {
        return LabelHelper.getLabelsForModuleDataType(this.dataTypeDescription);
    }

    @Override
    protected boolean isPropertyOfModuleDataItems() {
        return true;
    }

    public void checkPermissionForCreateOrDeleteLink(IRelationContributionForPermissionCheck[] relationContributions) throws EXCockpitPermissionDenied {
        IClientFunctionLicenseType2 licenseType = this.licenseTypeProvider.getModificationLicenseType();
        if (licenseType != null && !this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)licenseType)) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied.NoLicense")});
        }
        IRelationContributionForPermissionCheck MDContribution = (IRelationContributionForPermissionCheck)this.retrieveModuleDataContribution((IRelationContribution[])relationContributions);
        String moduleDataUID = MDContribution != null && MDContribution.getDataTypeIDOfTheDatasAncestor() == null ? MDContribution.getCockpitDataUID() : null;
        if (moduleDataUID != null && this.dataManager.itemExistsOnServer(moduleDataUID, this.getModuleDataDataTypeID())) {
            IModuleData parent;
            IModuleData moduleData = (IModuleData)this.dataManager.getItem(this.getModuleDataDataTypeID(), moduleDataUID);
            if (moduleData == null) {
                moduleData = this.dataTypeDescription.createInstance(UUIDGenerator.getUniqueID());
                parent = null;
            } else {
                parent = this.dataManager.getParent(moduleData);
            }
            if (!this.permissionMgr.mayEditAttribute(moduleData, parent, this.attributeID)) {
                throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied")});
            }
        }
    }
}

