/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.migration.version3.framework;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOAttributeTypeID_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOContainer_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLinkLog_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOModuleData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOVersionedModuleData_V0;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.EnumAttributeValueConverter;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.ICommonModuleDataMigrator;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IGenericItemMigratorTask;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.ILinkScanner;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IModuleDataMigrationProcessor;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IModuleDataMigrator;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IModuleDataScanner;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IVersionedItemMigrator;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IVersionedModuleDataScanner;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.ModuleDataMigrationProcessor;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.VersionedModuleDataID;
import com.arcway.lib.UUIDGenerator;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.util.HashMap;
import java.util.Map;

public class LinkedAttributeToEnumerationCustomPropertyMigrator
implements IGenericItemMigratorTask {
    private final String dataTypeID;
    private final String attributeRoleID;
    private final String linkedObjektDataTypeID;
    private final String nameAttributeTypeID;
    private final String linkTypeID;
    private final String humanreadableID;
    private final String displayName;
    private final int position;
    private final Map<String, String> linkedObjectUID_2_LinkedObjetName = new HashMap<String, String>();
    private final Map<VersionedModuleDataID, String> versionedLinkedObjectUID_2_LinkedObjetName = new HashMap<VersionedModuleDataID, String>();
    private final Map<String, String> objectUID_2_linkedObjectUID = new HashMap<String, String>();
    private EOAttributeTypeID_V0 customPropertyTypeID = null;

    public LinkedAttributeToEnumerationCustomPropertyMigrator(String dataTypeID, String attributeRoleID, String linkedObjektDataTypeID, String nameAttributeTypeID, String linkTypeID, String humanreadableID, String displayName, int position) {
        this.dataTypeID = dataTypeID;
        this.attributeRoleID = attributeRoleID;
        this.linkedObjektDataTypeID = linkedObjektDataTypeID;
        this.nameAttributeTypeID = nameAttributeTypeID;
        this.linkTypeID = linkTypeID;
        this.humanreadableID = humanreadableID;
        this.displayName = displayName;
        this.position = position;
    }

    @Override
    public void installMigratorProcessors(final IModuleDataMigrationProcessor genericItemMigrator) {
        genericItemMigrator.addItemScanner(this.linkedObjektDataTypeID, new IModuleDataScanner(){

            @Override
            public void scanModuleData(EOModuleData_V0 item) {
                String name = item.getAttribute(LinkedAttributeToEnumerationCustomPropertyMigrator.this.nameAttributeTypeID);
                if (name != null && name.length() > 0) {
                    LinkedAttributeToEnumerationCustomPropertyMigrator.this.linkedObjectUID_2_LinkedObjetName.put(item.getUid(), name);
                }
            }
        });
        genericItemMigrator.addVersionedItemScanner(this.linkedObjektDataTypeID, new IVersionedModuleDataScanner(){

            @Override
            public void scanVersionedModuleData(EOVersionedModuleData_V0 item) {
                String name = item.getAttribute(LinkedAttributeToEnumerationCustomPropertyMigrator.this.nameAttributeTypeID);
                if (name != null && name.length() > 0) {
                    LinkedAttributeToEnumerationCustomPropertyMigrator.this.versionedLinkedObjectUID_2_LinkedObjetName.put(new VersionedModuleDataID(item), name);
                }
            }
        });
        genericItemMigrator.deleteDataType(this.linkedObjektDataTypeID);
        genericItemMigrator.addLinkScanner(this.linkTypeID, new ILinkScanner(){

            @Override
            public void scanLink(String objectUID, String linkedObjectUID) {
                LinkedAttributeToEnumerationCustomPropertyMigrator.this.objectUID_2_linkedObjectUID.put(objectUID, linkedObjectUID);
            }
        });
        genericItemMigrator.deleteLinks(this.linkTypeID, this.dataTypeID, this.linkedObjektDataTypeID);
        genericItemMigrator.addCommonMigrator(new ICommonModuleDataMigrator(){

            @Override
            public void migrateModuleData() {
                LinkedAttributeToEnumerationCustomPropertyMigrator.this.customPropertyTypeID = new EOAttributeTypeID_V0(UUIDGenerator.getUniqueID(), LinkedAttributeToEnumerationCustomPropertyMigrator.this.humanreadableID);
                EnumAttributeValueConverter attributeValueConverter = new EnumAttributeValueConverter(LinkedAttributeToEnumerationCustomPropertyMigrator.this.linkedObjectUID_2_LinkedObjetName);
                EOList<EOContainer_V0<EOString>> eoValueRange = attributeValueConverter.getValueRange();
                genericItemMigrator.createCustomPropertyType(LinkedAttributeToEnumerationCustomPropertyMigrator.this.dataTypeID, LinkedAttributeToEnumerationCustomPropertyMigrator.this.attributeRoleID, LinkedAttributeToEnumerationCustomPropertyMigrator.this.customPropertyTypeID, LinkedAttributeToEnumerationCustomPropertyMigrator.this.displayName, LinkedAttributeToEnumerationCustomPropertyMigrator.this.position, "enumeration_string_single", (EOEncodableObject)eoValueRange);
            }
        });
        genericItemMigrator.addItemMigrator(this.dataTypeID, new IModuleDataMigrator(){

            @Override
            public boolean migrateModuleData(EOModuleData_V0 item) {
                String value = (String)LinkedAttributeToEnumerationCustomPropertyMigrator.this.objectUID_2_linkedObjectUID.get(item.getUid());
                if (value != null) {
                    String name = (String)LinkedAttributeToEnumerationCustomPropertyMigrator.this.linkedObjectUID_2_LinkedObjetName.get(value);
                    LinkedAttributeToEnumerationCustomPropertyMigrator.this.transformAttributeToCustomProperty(item, value, name);
                }
                boolean keepItem = true;
                return keepItem;
            }
        });
        genericItemMigrator.addVersionedItemMigrator(this.dataTypeID, new IVersionedItemMigrator(){

            @Override
            public boolean migrateVersionedModuleData(EOVersionedModuleData_V0 item) {
                VersionedModuleDataID linkedObjectID = null;
                for (EOLinkLog_V0 link : item.getOutLinks()) {
                    if (!link.getLinkTypeID().equals(LinkedAttributeToEnumerationCustomPropertyMigrator.this.linkTypeID)) continue;
                    linkedObjectID = new VersionedModuleDataID(link.getLinkableObjectUID(), link.getLinkableObjectVersion());
                    break;
                }
                if (linkedObjectID != null) {
                    String name = (String)LinkedAttributeToEnumerationCustomPropertyMigrator.this.versionedLinkedObjectUID_2_LinkedObjetName.get(linkedObjectID);
                    LinkedAttributeToEnumerationCustomPropertyMigrator.this.transformAttributeToCustomProperty((EOModuleData_V0)item, linkedObjectID.getUid(), name);
                }
                boolean keepItem = true;
                return keepItem;
            }
        });
    }

    private void transformAttributeToCustomProperty(EOModuleData_V0 item, String value, String name) {
        if (name != null && name.length() > 0) {
            EOList<EOContainer_V0<EOString>> customPropertyValue = EnumAttributeValueConverter.transformAttributeValue(value, name);
            ModuleDataMigrationProcessor.setCustomProperty(item, this.customPropertyTypeID, customPropertyValue);
        }
    }
}

