/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.projections;

import com.arcway.cockpit.modulelib2.client.ModuleLib2Plugin;
import com.arcway.cockpit.modulelib2.client.gui.projections.AbstractProjectionsLicenseHandler;
import com.arcway.lib.eclipse.gui.DecoratedImageDescriptor;
import com.arcway.lib.eclipse.resources.ResourceDisposer;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;

public abstract class AbstractProjectionPreferenceNode
extends PreferenceNode {
    private final AbstractProjectionsLicenseHandler licenseHandler = this.getProjectionLicenseHandler();
    private final Image enabledImage;
    private final Image disabledImage;

    public AbstractProjectionPreferenceNode(String id, String label, ImageDescriptor image, String className) {
        super(id, label, image, className);
        this.enabledImage = image.createImage();
        ResourceDisposer.markResourceAsSingleton((Resource)this.enabledImage);
        this.disabledImage = this.createDisabledImage(image).createImage();
        ResourceDisposer.markResourceAsSingleton((Resource)this.disabledImage);
    }

    private ImageDescriptor createDisabledImage(ImageDescriptor enabledImage) {
        ImageDescriptor disabledImage;
        if (enabledImage != null) {
            disabledImage = new DecoratedImageDescriptor(enabledImage);
            ((DecoratedImageDescriptor)disabledImage).addDecorator(ModuleLib2Plugin.getImageDescriptor("license_restriction.gif"), 3);
        } else {
            disabledImage = ModuleLib2Plugin.getImageDescriptor("license_restriction_16x16.gif");
        }
        return disabledImage;
    }

    public Image getLabelImage() {
        if (this.licenseHandler == null || this.licenseHandler.anyProjectHasLicense()) {
            return this.enabledImage;
        }
        return this.disabledImage;
    }

    protected abstract AbstractProjectionsLicenseHandler getProjectionLicenseHandler();
}

