/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.filters;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.TextListFilterItem;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import de.plans.lib.util.valueranges.IValueRangeHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ModuleDataTextListFilterItem
extends TextListFilterItem
implements IModuleProjectSwitchListener {
    private final IModelControllerProvider modelControllerProvider;
    private IModelController model;
    private final String dataTypeUid;
    private Comparator comparator;
    private boolean useHashMap = false;
    private static final String NOT_SPECIFIED = IValueRangeHelper.NOT_SPECIFIED;

    public ModuleDataTextListFilterItem(String name, String dataTypeUid, IModuleProjectSwitchListenerManager projectSwitchListenerManager, IModelControllerProvider modelControllerProvider, AbstractTextValuesFilter filter) {
        super(name, filter);
        this.modelControllerProvider = modelControllerProvider;
        this.dataTypeUid = dataTypeUid;
        projectSwitchListenerManager.registerProjectSwitchListener((IModuleProjectSwitchListener)this);
    }

    public ModuleDataTextListFilterItem(String name, String dataTypeUid, IModelController modelController, AbstractTextValuesFilter filter) {
        super(name, filter);
        this.modelControllerProvider = null;
        this.model = modelController;
        this.dataTypeUid = dataTypeUid;
    }

    public Control createContent(Composite parent) {
        if (this.model != null) {
            ArrayList<? extends IModuleData> items = new ArrayList<IModuleData>(this.model.getAllItems(this.dataTypeUid));
            if (this.comparator != null) {
                Collections.sort(items, this.comparator);
            }
            this.clearFilterValues();
            List itemNames = this.useHashMap ? this.fillItemNamesWithHashing(items) : this.fillItemNamesWithOutHashing(items);
            for (String itemName : itemNames) {
                if ("".equals(itemName)) {
                    this.addFilterValue(NOT_SPECIFIED, itemName);
                    continue;
                }
                this.addFilterValue(itemName, itemName);
            }
        } else {
            this.setFilterValues(Collections.EMPTY_LIST);
        }
        return super.createContent(parent);
    }

    private List fillItemNamesWithHashing(List moduleDataItems) {
        ArrayList<String> itemNames = new ArrayList<String>(moduleDataItems.size());
        HashSet<String> usedItems = new HashSet<String>(moduleDataItems.size());
        for (IModuleData item : moduleDataItems) {
            String itemName = this.extractStringAttribute(item);
            if (usedItems.contains(itemName)) continue;
            usedItems.add(itemName);
            itemNames.add(itemName);
        }
        return itemNames;
    }

    private List fillItemNamesWithOutHashing(List moduleDataItems) {
        ArrayList<String> itemNames = new ArrayList<String>(moduleDataItems.size());
        for (IModuleData item : moduleDataItems) {
            String itemName = this.extractStringAttribute(item);
            if (itemNames.contains(itemName)) continue;
            itemNames.add(itemName);
        }
        return itemNames;
    }

    public void useHashMapForDuplicateDetection(boolean enable) {
        this.useHashMap = enable;
    }

    protected String extractStringAttribute(IModuleData data) {
        return data.getDisplayRepresentation();
    }

    public void projectSwitched(String projectUID) {
        this.model = this.modelControllerProvider.getModelController(projectUID);
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }
}

