/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure;

import com.arcway.cockpit.modulelib2.client.gui.editor.specification.AbstractEditorSpecificationPart;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.IEditorSpecificationPart;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.TableParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Table
extends AbstractEditorSpecificationPart {
    private final Map<String, AbstractEditorSpecificationPart> childMap = new HashMap<String, AbstractEditorSpecificationPart>();
    private final TableParameters tableParameters;

    public Table(List<AbstractEditorSpecificationPart> childList, TableParameters tableParameters) {
        int columnListCounter = 1;
        for (AbstractEditorSpecificationPart part : childList) {
            part.setIndex(columnListCounter);
            String partID = part.getID();
            this.childMap.put(partID, part);
            ++columnListCounter;
        }
        this.tableParameters = tableParameters;
    }

    public List<AbstractEditorSpecificationPart> getChildList() {
        ArrayList<AbstractEditorSpecificationPart> list = new ArrayList<AbstractEditorSpecificationPart>(this.childMap.values());
        Table.sortSpecificationPartList(list);
        return list;
    }

    public AbstractEditorSpecificationPart getEditorSpecificationPart(String id) {
        return this.childMap.get(id);
    }

    public AbstractEditorSpecificationPart getChild(int index) {
        return this.getChildList().get(index);
    }

    public TableParameters getTableParameters() {
        return this.tableParameters;
    }

    public List<IEditorSpecificationPart> getChildren() {
        ArrayList<IEditorSpecificationPart> children = new ArrayList<IEditorSpecificationPart>();
        children.addAll(this.childMap.values());
        children.add(this.tableParameters);
        return children;
    }

    @Override
    public String getTypeID() {
        return "Table";
    }
}

