/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategoryIconProvider;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.ModuleLib2Plugin;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.AbstractModuleHandler;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.java.Equals;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import de.plans.lib.localisation.ILabelProvider;
import de.plans.lib.localisation.LabelProviderUnlocalisedString;
import de.plans.lib.resources.IIconResource;
import de.plans.lib.util.valueranges.DiscreteValue;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AttributeHandlerForCategories
extends AbstractModuleHandler {
    private static final ILogger logger = Logger.getLogger(AttributeHandlerForCategories.class);
    private final List<DiscreteValueWithCategoryID> categories = new ArrayList<DiscreteValueWithCategoryID>();
    private static final IStatus STATUS_NO_PERMISSION = new Status(4, ModuleLib2Plugin.getDefault().getBundle().getSymbolicName(), 0, Messages.getString("AbstractModuleAttributeHandler.ErrMsgPermission"), null);
    private static final IStatus STATUS_NO_LOCK = new Status(4, ModuleLib2Plugin.getDefault().getBundle().getSymbolicName(), 0, Messages.getString("AbstractModuleAttributeHandler.ErrMsgLock"), null);

    public AttributeHandlerForCategories(IModuleProjectSwitchListenerManager projectSwitchListenerManager, IModelControllerProvider modelControllerProvider, String dataTypeID) {
        this(projectSwitchListenerManager, modelControllerProvider, dataTypeID, true);
    }

    public AttributeHandlerForCategories(IModuleProjectSwitchListenerManager projectSwitchListenerManager, IModelControllerProvider modelControllerProvider, String dataTypeID, boolean checkAttributePermission) {
        super(projectSwitchListenerManager, modelControllerProvider, ObjectTypeCategoryLabels.LABEL_CATEGORY, dataTypeID, checkAttributePermission);
    }

    @Override
    public IStatus canChangeValue(Object domainItem, int value) {
        IModuleData moduleData = (IModuleData)domainItem;
        if (this.isCheckPermissions() && !this.getModelController().getPermissionMgr().mayEditItemStructurally(moduleData, this.getModelController().getParent(moduleData))) {
            return STATUS_NO_PERMISSION;
        }
        if (!this.getModelController().getLockMgr().acquireEditLock((ICockpitProjectData)((IModuleData)domainItem)).hasLock()) {
            return STATUS_NO_LOCK;
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean enableFor(Object domainItem) {
        IModuleData moduleData = (IModuleData)domainItem;
        return !this.isCheckPermissions() || this.getModelController().getPermissionMgr().mayEditItemStructurally(moduleData, this.getModelController().getParent(moduleData));
    }

    @Override
    public String getID() {
        return "object-type-category";
    }

    @Override
    public boolean registerFor(Object domainItem) {
        assert (domainItem instanceof IModuleData) : "Expected IModuleData. Got " + domainItem.getClass();
        IModuleData moduleData = (IModuleData)domainItem;
        return moduleData.getTypeDescription().isSupportingCategories() && moduleData.getTypeID().equals(this.getDataTypeID());
    }

    @Override
    public List<? extends DiscreteValue> getValueRange() {
        this.calculateValueRange();
        return this.categories;
    }

    @Override
    public int getCurrentValueIndex(Object item) {
        assert (item instanceof IModuleData) : "Expected IModuleData. Got " + item.getClass();
        int i = 0;
        while (i < this.categories.size()) {
            if (Equals.equals((Object)this.categories.get(i).categoryID, (Object)((IModuleData)item).getCategoryID())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void changeValue(Object domainItem, int index, DiscreteValue value) {
        assert (domainItem instanceof IModuleData) : "Expected IModuleData. Got " + domainItem.getClass();
        assert (value instanceof DiscreteValueWithCategoryID) : "Expected DiscreteValueWithCategoryID. Got " + value.getClass();
        IModuleData moduleData = (IModuleData)domainItem;
        moduleData.setCategoryID(((DiscreteValueWithCategoryID)value).categoryID);
        this.getModelController().itemPropertiesModified(moduleData, null);
    }

    private void calculateValueRange() {
        List allCategories = this.getModelController().getProjectAgent().getObjectTypeCategoriesManager().getAllCategoriesForObjectTypeSorted(this.getDataTypeID());
        this.categories.clear();
        this.categories.add(new DiscreteValueWithCategoryID((ILabelProvider)new LabelProviderUnlocalisedString(ObjectTypeCategoryLabels.LABEL_DEFAULTCATEGORY), null, null));
        for (ObjectTypeCategory objectTypeCategory : allCategories) {
            IIconResource iconResource = ObjectTypeCategoryIconProvider.getDefault().getObjectTypeCategoryIconResource(this.getModelController().getProjectUID(), objectTypeCategory.getObjectTypeCategoryID());
            this.categories.add(new DiscreteValueWithCategoryID((ILabelProvider)new LabelProviderUnlocalisedString(objectTypeCategory.getDisplayName()), iconResource, objectTypeCategory.getObjectTypeCategoryID()));
        }
    }

    private class DiscreteValueWithCategoryID
    extends DiscreteValue {
        private final ObjectTypeCategoryID categoryID;

        public DiscreteValueWithCategoryID(ILabelProvider label, IIconResource image, ObjectTypeCategoryID categoryID) {
            super(label, image);
            this.categoryID = categoryID;
        }
    }
}

