/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.ModuleActionDelegate;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.AbstractCopyManager;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class AbstractActionDelegateCopy
extends ModuleActionDelegate {
    private AbstractCopyManager copyManager;
    private IModelController modelController;
    private final List selectedElements = new LinkedList();
    private boolean enablement = false;

    protected void init() {
        this.copyManager = this.getCopyManager();
    }

    public void run(IAction action) {
        Object copiedData = this.copyManager.getCopy(this.selectedElements, this.modelController);
        this.copyManager.setToClipboard(copiedData);
        ISelectionProvider selectionProvider = this.getIssuingPart().getSite().getSelectionProvider();
        ISelection selection = selectionProvider.getSelection();
        selectionProvider.setSelection(selection);
    }

    protected boolean determineEnabledStatus(String projectUID) {
        this.modelController = projectUID != null ? this.getModelController(projectUID) : null;
        this.enablement = false;
        return this.enablement;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        this.selectedElements.removeAll(changes.getDeletedElements());
        return this.enablement;
    }

    public boolean determineEnabledStatus(ISelection selection) {
        String projectUID;
        this.enablement = false;
        this.selectedElements.clear();
        if (selection instanceof IStructuredSelection && (projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)selection)) != null) {
            IStructuredSelection structuredSelection;
            this.modelController = this.getModelController(projectUID);
            if (this.modelController != null && !(structuredSelection = (IStructuredSelection)selection).isEmpty()) {
                String virtualParentTypeID;
                boolean onlyModuleDataItems = true;
                for (Object selectedItem : structuredSelection) {
                    if (selectedItem instanceof IModuleData) continue;
                    onlyModuleDataItems = false;
                    break;
                }
                if (onlyModuleDataItems && (virtualParentTypeID = this.copyManager.getVirtualParentDataType(structuredSelection.toList())) != null) {
                    this.enablement = true;
                    this.selectedElements.addAll(structuredSelection.toList());
                }
            }
        }
        return this.enablement;
    }

    protected abstract AbstractCopyManager getCopyManager();

    protected abstract IModelController getModelController(String var1);
}

