/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.IFilesManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.IDataTypeWithFile;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IFrameUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.INewIDReceiver;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccessWrapper;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.gui.CustomPropertyTempFileStore;
import com.arcway.cockpit.modulelib2.client.gui.Pair_VirtualParentTypeID_AllowedChildTypes;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataViewSorter;
import com.arcway.cockpit.modulelib2.client.messages.CustomModuleAttribute;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.KeyUID;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.messages.transfer.CopiedModuleDataTransferAgent;
import com.arcway.cockpit.modulelib2.client.messages.transfer.CopiedModuleDataTransferContent;
import com.arcway.cockpit.modulelib2.client.messages.transfer.CopiedModuleData_VirtualParentType_TransferAgent;
import com.arcway.cockpit.modulelib2.client.messages.transfer.EOTemporaryFileForCopyAndPaste;
import com.arcway.cockpit.modulelib2.client.messages.transfer.ModuleDataTransferAgent;
import com.arcway.cockpit.modulelib2.shared.messages.ILinkTypeHelper_Shared;
import com.arcway.lib.java.collectionmaps.CollectionMap;
import com.arcway.lib.java.collectionmaps.ListMap;
import com.arcway.lib.java.collectionmaps.MapMap;
import com.arcway.lib.java.collectionmaps.SetMap;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.FileResourceWithOverwrittenName;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import de.plans.lib.util.StringComparatorFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractCopyManager {
    static final ILogger logger = Logger.getLogger(AbstractCopyManager.class);
    private static final String ABSTRACTPARENTTYPEID_PREFIX = "AbstractParentTypeForCopyAndPaste-ContainerFor-";
    private static final String ABSTRACTPARENTTYPEID_INFIX = "-TogetherWith-";
    private static final Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
    private static final CustomPropertyTempFileStore customPropertyTempFileStore = new CustomPropertyTempFileStore();
    private final String moduleID;
    private final ILinkTypeHelper_Shared linkTypeHelper;
    private final ModuleDataTransferAgent singleModuleDataItemTransferAgent;
    private Map<String, Set<String>> map_virtualParentTypeID_possibleParentTypes;
    private SetMap<String, String> map_parentTypeID_appropriateVirtualParentTypes;
    private List<Pair_VirtualParentTypeID_AllowedChildTypes> pairs_virtualParentTypeID_allowedChildTypes;
    private Map<String, List<String>> map_virtualParentTypeID_allowedChildTypes;
    private static final String TEMPORARY_DUMMY_ID_FOR_COPIED_ITEMS = "$$TEMPORARY_DUMMY_ID_FOR_COPIED_ITEMS$$==";
    private final Map<KeyUID, String> map_uid_temporarilyRemovedID = new HashMap<KeyUID, String>();

    public AbstractCopyManager(String moduleID, IClientDataFactory clientDataFactory, ILinkTypeHelper_Shared linkTypeHelper) {
        this.moduleID = moduleID;
        this.linkTypeHelper = linkTypeHelper;
        this.singleModuleDataItemTransferAgent = ModuleDataTransferAgent.getInstance(moduleID, clientDataFactory);
    }

    protected final void construct() {
        this.map_virtualParentTypeID_possibleParentTypes = new HashMap<String, Set<String>>();
        this.map_parentTypeID_appropriateVirtualParentTypes = new SetMap();
        this.pairs_virtualParentTypeID_allowedChildTypes = new LinkedList<Pair_VirtualParentTypeID_AllowedChildTypes>();
        this.map_virtualParentTypeID_allowedChildTypes = new HashMap<String, List<String>>();
        this.determineVirtualParentTypesForCopyAndPaste(this.map_virtualParentTypeID_possibleParentTypes, this.map_parentTypeID_appropriateVirtualParentTypes, this.pairs_virtualParentTypeID_allowedChildTypes, this.map_virtualParentTypeID_allowedChildTypes);
    }

    private String getTransferTypeID() {
        String transferTypeID = "CopyPaste_" + this.moduleID;
        return transferTypeID;
    }

    private CopiedModuleDataTransferAgent getTransferAgent() {
        String typeID = this.getTransferTypeID();
        return CopiedModuleDataTransferAgent.getInstance(typeID);
    }

    private CopiedModuleData_VirtualParentType_TransferAgent getTransferAgentForVirtualParentType() {
        String typeID = this.getTransferTypeID();
        return CopiedModuleData_VirtualParentType_TransferAgent.getInstance(typeID);
    }

    public final Object getCopy(Collection<IModuleData> itemsToCopy, IModelController modelController) {
        ArrayList<IModuleData> rootItems = new ArrayList<IModuleData>();
        ArrayList<IModuleData> items = new ArrayList<IModuleData>();
        HashSet<EOLink> links = new HashSet<EOLink>();
        HashSet<EOLink> mdLinksToContext = new HashSet<EOLink>();
        HashSet<EOLink> loLinksToContext = new HashSet<EOLink>();
        HashSet<EOLink> mdLinksToFrameContext = new HashSet<EOLink>();
        HashSet<IModuleData> contextItems = new HashSet<IModuleData>();
        HashSet<EOLink> linksToCopiedContext = new HashSet<EOLink>();
        HashSet<EOTemporaryFileForCopyAndPaste> tempFileDescriptors = new HashSet<EOTemporaryFileForCopyAndPaste>();
        HashMap<String, String> objectTypeCategoryMetaInformation = new HashMap<String, String>();
        ArrayList<IModuleData> itemsToCopyAsList = new ArrayList<IModuleData>(itemsToCopy);
        AbstractCopyManager.sortDataToBeCopied(itemsToCopyAsList, modelController);
        for (IModuleData itemToCopy : itemsToCopyAsList) {
            this.copyItem(itemToCopy, null, rootItems, items, links, mdLinksToContext, loLinksToContext, mdLinksToFrameContext, contextItems, linksToCopiedContext, objectTypeCategoryMetaInformation, modelController);
        }
        SetMap customPropertyTypes = new SetMap();
        tempFileDescriptors.addAll(AbstractCopyManager.handleCopyOfFileCustomProperties(rootItems, modelController, (SetMap<String, IAttributeType>)customPropertyTypes));
        tempFileDescriptors.addAll(AbstractCopyManager.handleCopyOfFileCustomProperties(items, modelController, (SetMap<String, IAttributeType>)customPropertyTypes));
        tempFileDescriptors.addAll(AbstractCopyManager.handleCopyOfFileCustomProperties(contextItems, modelController, (SetMap<String, IAttributeType>)customPropertyTypes));
        return new CopiedModuleDataTransferContent(this.getVirtualParentDataType(itemsToCopy), this.singleModuleDataItemTransferAgent, rootItems, items, new ArrayList<EOLink>(links), new ArrayList<EOLink>(mdLinksToContext), new ArrayList<EOLink>(loLinksToContext), new ArrayList<EOLink>(mdLinksToFrameContext), new ArrayList<IModuleData>(contextItems), new ArrayList<EOLink>(linksToCopiedContext), new ArrayList<EOTemporaryFileForCopyAndPaste>(tempFileDescriptors), objectTypeCategoryMetaInformation);
    }

    public final Collection<IModuleData> paste(final Object copiedData, final IModuleData target, final IModelController modelController, final Shell shell) {
        final Collection[] copies = new Collection[1];
        modelController.getProjectAgent().getLockManager().doWithBlockOfflineModeProjectLock(new Runnable(){

            @Override
            public void run() {
                CopiedModuleDataTransferContent copyTransferContent = (CopiedModuleDataTransferContent)copiedData;
                copies[0] = AbstractCopyManager.this.pasteData(target, copyTransferContent.getCopiedRootItems(), copyTransferContent.getCopiedItems(), copyTransferContent.getCopiedLinks(), copyTransferContent.getCopiedMDLinksToContext(), copyTransferContent.getCopiedLOLinksToContext(), copyTransferContent.getCopiedMDLinksToFrameContext(), copyTransferContent.getCopiedContextItems(), copyTransferContent.getCopiedLinksToCopiedContext(), copyTransferContent.getTempFileDescriptors(), copyTransferContent.getObjectTypeCategoryMetaInformation(), modelController, shell);
            }
        });
        return copies[0];
    }

    public final void setToClipboard(Object copiedData) {
        CopiedModuleDataTransferContent content = (CopiedModuleDataTransferContent)copiedData;
        String virtualParentTypeID = content.getVirtualParentTypeID();
        clipboard.setContents(new Object[]{copiedData, virtualParentTypeID}, new Transfer[]{this.getTransferAgent(), this.getTransferAgentForVirtualParentType()});
    }

    public final Object retrieveFromClipboard(String parentTypeID) {
        String virtualParentTypeID = this.isCopiedDataInClipboard(parentTypeID);
        if (virtualParentTypeID == null) {
            return null;
        }
        Object contents = clipboard.getContents((Transfer)this.getTransferAgent());
        if (contents != null && contents instanceof CopiedModuleDataTransferContent) {
            ((CopiedModuleDataTransferContent)contents).setVirtualParentTypeID(virtualParentTypeID);
            return contents;
        }
        return null;
    }

    public final String isCopiedDataInClipboard(String parentTypeID) {
        Object contents = clipboard.getContents((Transfer)this.getTransferAgentForVirtualParentType());
        if (contents != null) {
            String virtualParentTypeIDOfClipboardData = (String)contents;
            Set appropriateVirtualParentTypes = this.map_parentTypeID_appropriateVirtualParentTypes.get((Object)parentTypeID);
            for (String appropriateVirtualParentTypeID : appropriateVirtualParentTypes) {
                if (!virtualParentTypeIDOfClipboardData.equals(appropriateVirtualParentTypeID)) continue;
                return virtualParentTypeIDOfClipboardData;
            }
        }
        return null;
    }

    public final boolean isValidParentType(String parentCockpitTypeID, String virtualParentTypeID) {
        return this.map_virtualParentTypeID_possibleParentTypes.get(virtualParentTypeID).contains(parentCockpitTypeID);
    }

    public Collection<IModuleData> getRootItemsOfCopy(Object copiedData) {
        return ((CopiedModuleDataTransferContent)copiedData).getCopiedRootItems();
    }

    public String getVirtualParentDataType(Collection<IModuleData> sourceData) {
        HashSet<String> dataTypeIDsOfSourceData = new HashSet<String>();
        for (IModuleData sourceItem : sourceData) {
            dataTypeIDsOfSourceData.add(sourceItem.getTypeID());
        }
        for (Pair_VirtualParentTypeID_AllowedChildTypes pair : this.pairs_virtualParentTypeID_allowedChildTypes) {
            if (!pair.allowedChildTypes.containsAll(dataTypeIDsOfSourceData)) continue;
            return pair.virtualParentTypeID;
        }
        return null;
    }

    public String getVirtualParentDataType(Object copiedData) {
        String virtualParentDataTypeID = ((CopiedModuleDataTransferContent)copiedData).getVirtualParentTypeID();
        if (virtualParentDataTypeID == null) {
            virtualParentDataTypeID = this.getVirtualParentDataType(this.getRootItemsOfCopy(copiedData));
            ((CopiedModuleDataTransferContent)copiedData).setVirtualParentTypeID(virtualParentDataTypeID);
        }
        return virtualParentDataTypeID;
    }

    public boolean doCheckPermissions(String virtualParentType, IModuleData target, IModelController modelController) {
        return this.doCheckPermissions(virtualParentType, target, modelController, null);
    }

    public boolean doCheckPermissions(String virtualParentType, IModuleData target, IModelController modelController, Shell shell) {
        AbstractPermissionMgr permissionMgr = modelController.getPermissionMgr();
        Collection childTypeIDs = this.map_virtualParentTypeID_allowedChildTypes.get(virtualParentType);
        for (String childTypeID : childTypeIDs) {
            if (permissionMgr.mayCreateChildren(target, childTypeID)) continue;
            if (shell != null) {
                MessageDialog.openInformation((Shell)shell, (String)Messages.getString("CopyDragNDropSupport.TargetNoCreationPermissionTitle"), (String)Messages.getString("CopyDragNDropSupport.TargetNoCreationPermissionMessage"));
            }
            return false;
        }
        return true;
    }

    public boolean doAcquireLocks(IModuleData target, IModelController modelController, LockAccessWrapper lockAccessWrapper) {
        return this.doAcquireLocks(target, modelController, null, lockAccessWrapper);
    }

    public boolean doAcquireLocks(IModuleData target, IModelController modelController, Shell shell, LockAccessWrapper lockAccessWrapper) {
        AbstractLockManager lockManager = modelController.getLockMgr();
        LockAccess addLock = lockManager.acquireInsertLock((ICockpitProjectData)target, false);
        if (!addLock.hasLock()) {
            if (shell != null) {
                MessageDialog.openInformation((Shell)shell, (String)Messages.getString("CopyDragNDropSupport.TargetLockedTitle"), (String)Messages.getString("CopyDragNDropSupport.TargetLockedMessage"));
            }
            return false;
        }
        if (lockAccessWrapper != null) {
            lockAccessWrapper.setLockAccess(addLock);
        }
        return true;
    }

    protected abstract Collection<String> getOptionalMDContextLinkTypes(String var1);

    protected abstract Collection<String> getOptionalLOContextLinkTypes(String var1);

    protected abstract Collection<String> getOptionalMDFrameContextLinkTypes(String var1);

    protected abstract Collection<String> getRequiredContextLinkTypes(String var1);

    protected abstract void customCopyOperations(IModuleData var1, IModuleData var2, List<IModuleData> var3, List<IModuleData> var4, Set<EOLink> var5, Set<EOLink> var6, Set<EOLink> var7, Set<EOLink> var8, Set<IModuleData> var9, Set<EOLink> var10, IModelController var11);

    protected abstract void customPasteOperations(IModuleData var1, List<IModuleData> var2, List<IModuleData> var3, List<EOLink> var4, List<EOLink> var5, List<EOLink> var6, List<IModuleData> var7, List<EOLink> var8, Map<String, String> var9, IModelController var10);

    protected abstract Collection<String> getPossibleParentDataTypes(String var1);

    protected abstract Collection<String> getAllCopyableDataTypes();

    private void determineVirtualParentTypesForCopyAndPaste(Map<String, Set<String>> map_virtualParentTypeID_possibleParentTypes_, SetMap<String, String> map_parentTypeID_appropriateVirtualParentTypes_, List<Pair_VirtualParentTypeID_AllowedChildTypes> pairs_virtualParentTypeID_allowedChildTypes_, Map<String, List<String>> map_virtualParentTypeID_allowedChildTypes_) {
        ArrayList<String> allTypes = new ArrayList<String>(this.getAllCopyableDataTypes());
        Collections.sort(allTypes, StringComparatorFactory.getStringComparator((boolean)false));
        HashSet<String> stillPossibleParents = new HashSet<String>(allTypes);
        stillPossibleParents.add("hierarchyroot");
        this.determineVirtualParentTypesForCopyAndPaste_internal(allTypes, 0, new LinkedList<String>(), stillPossibleParents, map_virtualParentTypeID_possibleParentTypes_, map_parentTypeID_appropriateVirtualParentTypes_, pairs_virtualParentTypeID_allowedChildTypes_, map_virtualParentTypeID_allowedChildTypes_);
    }

    private void determineVirtualParentTypesForCopyAndPaste_internal(List<String> allTypes, int typeIndex, List<String> consideredChildTypes, Set<String> stillPossibleParents, Map<String, Set<String>> map_virtualParentTypeID_possibleParentTypes_, SetMap<String, String> map_parentTypeID_appropriateVirtualParentTypes_, List<Pair_VirtualParentTypeID_AllowedChildTypes> pairs_virtualParentTypeID_allowedChildTypes_, Map<String, List<String>> map_virtualParentTypeID_allowedChildTypes_) {
        if (typeIndex < allTypes.size()) {
            String typeID = allTypes.get(typeIndex);
            LinkedList<String> consideredChildTypes_new = new LinkedList<String>(consideredChildTypes);
            consideredChildTypes_new.add(typeID);
            HashSet<String> stillPossibleParents_new = new HashSet<String>(stillPossibleParents);
            stillPossibleParents_new.retainAll(this.getPossibleParentDataTypes(typeID));
            if (!stillPossibleParents_new.isEmpty()) {
                this.determineVirtualParentTypesForCopyAndPaste_internal(allTypes, typeIndex + 1, consideredChildTypes_new, stillPossibleParents_new, map_virtualParentTypeID_possibleParentTypes_, map_parentTypeID_appropriateVirtualParentTypes_, pairs_virtualParentTypeID_allowedChildTypes_, map_virtualParentTypeID_allowedChildTypes_);
            }
            this.determineVirtualParentTypesForCopyAndPaste_internal(allTypes, typeIndex + 1, consideredChildTypes, stillPossibleParents, map_virtualParentTypeID_possibleParentTypes_, map_parentTypeID_appropriateVirtualParentTypes_, pairs_virtualParentTypeID_allowedChildTypes_, map_virtualParentTypeID_allowedChildTypes_);
        } else {
            AbstractCopyManager.determineVirtualParentTypesForCopyAndPaste_internal_storeResult(consideredChildTypes, stillPossibleParents, map_virtualParentTypeID_possibleParentTypes_, map_parentTypeID_appropriateVirtualParentTypes_, pairs_virtualParentTypeID_allowedChildTypes_, map_virtualParentTypeID_allowedChildTypes_);
        }
    }

    private static void determineVirtualParentTypesForCopyAndPaste_internal_storeResult(List<String> consideredChildTypes, Set<String> stillPossibleParents, Map<String, Set<String>> map_virtualParentTypeID_possibleParentTypes_, SetMap<String, String> map_parentTypeID_appropriateVirtualParentTypes_, List<Pair_VirtualParentTypeID_AllowedChildTypes> pairs_virtualParentTypeID_allowedChildTypes_, Map<String, List<String>> map_virtualParentTypeID_allowedChildTypes_) {
        if (!consideredChildTypes.isEmpty()) {
            String virtualParentTypeID;
            Pair_VirtualParentTypeID_AllowedChildTypes newPair = new Pair_VirtualParentTypeID_AllowedChildTypes();
            newPair.virtualParentTypeID = virtualParentTypeID = AbstractCopyManager.getAbstractParentTypeID(consideredChildTypes);
            newPair.allowedChildTypes = consideredChildTypes;
            int index = pairs_virtualParentTypeID_allowedChildTypes_.size();
            while (index >= 0) {
                Pair_VirtualParentTypeID_AllowedChildTypes pair = new Pair_VirtualParentTypeID_AllowedChildTypes();
                if (index > 0) {
                    pair = pairs_virtualParentTypeID_allowedChildTypes_.get(index - 1);
                }
                if (index == 0 || consideredChildTypes.size() >= pair.allowedChildTypes.size()) {
                    pairs_virtualParentTypeID_allowedChildTypes_.add(index, newPair);
                    map_virtualParentTypeID_allowedChildTypes_.put(virtualParentTypeID, consideredChildTypes);
                    map_virtualParentTypeID_possibleParentTypes_.put(virtualParentTypeID, stillPossibleParents);
                    for (String parentType : stillPossibleParents) {
                        map_parentTypeID_appropriateVirtualParentTypes_.add((Object)parentType, (Object)virtualParentTypeID);
                    }
                    return;
                }
                --index;
            }
        }
    }

    private static String getAbstractParentTypeID(List<String> allowedChildTypes) {
        StringBuffer abstractParentTypeIDBuffer = new StringBuffer(1024);
        abstractParentTypeIDBuffer.append(ABSTRACTPARENTTYPEID_PREFIX);
        abstractParentTypeIDBuffer.append(allowedChildTypes.get(0));
        int index = 1;
        while (index < allowedChildTypes.size()) {
            abstractParentTypeIDBuffer.append(ABSTRACTPARENTTYPEID_INFIX);
            abstractParentTypeIDBuffer.append(allowedChildTypes.get(index));
            ++index;
        }
        return abstractParentTypeIDBuffer.toString();
    }

    protected IModuleData getExistingContextItem(IModuleData copiedContextItem, IModelController modelController) {
        for (IModuleData iModuleData : modelController.getAllItems(copiedContextItem.getTypeID())) {
            if (!iModuleData.getDisplayRepresentation().equals(copiedContextItem.getDisplayRepresentation())) continue;
            return iModuleData;
        }
        return null;
    }

    private void copyItem(IModuleData item, IModuleData parent, List<IModuleData> rootItems, List<IModuleData> items, Set<EOLink> links, Set<EOLink> mdLinksToContext, Set<EOLink> loLinksToContext, Set<EOLink> mdLinksToFrameContext, Set<IModuleData> contextItems, Set<EOLink> linksToCopiedContext, Map<String, String> objectTypeCategoryMetaInformation, IModelController modelController) {
        EOLink contextLink;
        this.copyItem_Recursively(item, parent, rootItems, items, links, mdLinksToContext, loLinksToContext, mdLinksToFrameContext, contextItems, linksToCopiedContext, objectTypeCategoryMetaInformation, modelController);
        HashSet<String> itemUIDSet = new HashSet<String>();
        for (IModuleData copiedItem : rootItems) {
            itemUIDSet.add(copiedItem.getUID());
        }
        for (IModuleData copiedItem : items) {
            itemUIDSet.add(copiedItem.getUID());
        }
        Iterator<EOLink> contextLinkIterator = mdLinksToContext.iterator();
        while (contextLinkIterator.hasNext()) {
            contextLink = contextLinkIterator.next();
            if (!itemUIDSet.contains(contextLink.getLinkableObjectUID())) continue;
            contextLinkIterator.remove();
            links.add(contextLink);
        }
        contextLinkIterator = loLinksToContext.iterator();
        while (contextLinkIterator.hasNext()) {
            contextLink = contextLinkIterator.next();
            if (!itemUIDSet.contains(contextLink.getModuleDataUID())) continue;
            contextLinkIterator.remove();
            links.add(contextLink);
        }
    }

    private void copyItem_Recursively(IModuleData item, IModuleData parent, List<IModuleData> rootItems, List<IModuleData> items, Set<EOLink> links, Set<EOLink> mdLinksToContext, Set<EOLink> loLinksToContext, Set<EOLink> mdLinksToFrameContext, Set<IModuleData> contextItems, Set<EOLink> linksToCopiedContext, Map<String, String> objectTypeCategoryMetaInformation, IModelController modelController) {
        String hierarchyLinkType;
        IModuleData copiedItem = item.copy(true);
        if (parent != null) {
            items.add(copiedItem);
        } else {
            rootItems.add(copiedItem);
        }
        ObjectTypeCategoryID categoryID = item.getCategoryID();
        if (categoryID != null && !objectTypeCategoryMetaInformation.containsKey(categoryID.getUID())) {
            ObjectTypeCategory category = ((IFrameProjectAgent)modelController.getProjectAgent()).getObjectTypeCategoriesManager().getCategory(categoryID);
            objectTypeCategoryMetaInformation.put(category.getUID(), category.getHumanReadableID());
        }
        if (parent != null && (hierarchyLinkType = this.linkTypeHelper.getHierarchyLinkTypeID(parent.getTypeID(), item.getTypeID())) != null) {
            Iterator<String> hierarchyLinkCollection = modelController.getLinksForModuleDataItem(item, hierarchyLinkType);
            EOLink eOLink = (EOLink)hierarchyLinkCollection.iterator().next();
            links.add(new EOLink(eOLink));
        }
        for (String linkType : this.getOptionalMDContextLinkTypes(item.getTypeID())) {
            for (EOLink eOLink : modelController.getLinksForModuleDataItem(item, linkType)) {
                mdLinksToContext.add(new EOLink(eOLink));
            }
        }
        for (String linkType : this.getOptionalLOContextLinkTypes(item.getTypeID())) {
            for (EOLink eOLink : modelController.getLinksForLinkableObject(item.getUID(), linkType)) {
                loLinksToContext.add(new EOLink(eOLink));
            }
        }
        for (String linkType : this.getOptionalMDFrameContextLinkTypes(item.getTypeID())) {
            for (EOLink eOLink : modelController.getLinksForModuleDataItem(item, linkType)) {
                mdLinksToFrameContext.add(new EOLink(eOLink));
            }
        }
        for (String linkType : this.getRequiredContextLinkTypes(item.getTypeID())) {
            String string = this.linkTypeHelper.getLinkTargetDataTypeIDForLinkType(linkType);
            for (EOLink eOLink : modelController.getLinksForModuleDataItem(item, linkType)) {
                linksToCopiedContext.add(new EOLink(eOLink));
                IModuleData linkableObject = modelController.getItem(string, eOLink.getLinkableObjectUID());
                contextItems.add(linkableObject.copy(true));
            }
        }
        this.customCopyOperations(item, parent, rootItems, items, links, mdLinksToContext, loLinksToContext, mdLinksToFrameContext, contextItems, linksToCopiedContext, modelController);
        ArrayList<IModuleData> children = new ArrayList<IModuleData>(modelController.getChildren(item));
        AbstractCopyManager.sortDataToBeCopied(children, modelController);
        for (IModuleData child : children) {
            this.copyItem_Recursively(child, item, rootItems, items, links, mdLinksToContext, loLinksToContext, mdLinksToFrameContext, contextItems, linksToCopiedContext, objectTypeCategoryMetaInformation, modelController);
        }
    }

    private static Collection<EOTemporaryFileForCopyAndPaste> handleCopyOfFileCustomProperties(Collection<IModuleData> items, IModelController modelController, SetMap<String, IAttributeType> map_cockpitTypeID_customPropertyTypes) {
        LinkedList<EOTemporaryFileForCopyAndPaste> tempFileDescriptors = new LinkedList<EOTemporaryFileForCopyAndPaste>();
        for (IModuleData item : items) {
            if (!map_cockpitTypeID_customPropertyTypes.containsKey((Object)item.getTypeID())) {
                AbstractCopyManager.findFileCustomProperties(item.getTypeID(), modelController, map_cockpitTypeID_customPropertyTypes);
            }
            Set fileCustomPropertyTypes = map_cockpitTypeID_customPropertyTypes.get((Object)item.getTypeID());
            for (IAttributeType fileCustomPropertyType : fileCustomPropertyTypes) {
                EOTemporaryFileForCopyAndPaste tempFileDescriptor;
                IDataTypeWithFile fileCustomPropertyTypeDataType = (IDataTypeWithFile)fileCustomPropertyType.getDataType();
                IAttribute fileCustomProperty = item.getCustomAttribute(fileCustomPropertyType);
                FileID fileDescriptor = null;
                if (fileCustomProperty != null) {
                    fileDescriptor = (FileID)fileCustomProperty.getAttributeValue();
                }
                if (fileDescriptor == null || fileDescriptor.equals((Object)FileID.NO_FILE) || (tempFileDescriptor = customPropertyTempFileStore.copyCustomPropertyToTempFileStore(fileDescriptor, fileCustomPropertyTypeDataType, modelController)) == null || tempFileDescriptor.getTemporaryFile() == null) continue;
                tempFileDescriptors.add(tempFileDescriptor);
            }
        }
        return tempFileDescriptors;
    }

    private static void findFileCustomProperties(String cockpitTypeID, IModelController modelController, SetMap<String, IAttributeType> map_cockpitTypeID_customPropertyTypes) {
        map_cockpitTypeID_customPropertyTypes.addAll((Object)cockpitTypeID, Collections.emptyList());
        IFrameUserDefinedAttributeTypesManager customPropertyManager = ((ProjectAgent)modelController.getProjectAgent()).getFrameUserDefinedAttributeTypesManager();
        List customPropertyTypesForType = customPropertyManager.getAllUserDefinedAttributeTypes(cockpitTypeID);
        for (IAttributeType customPropertyType : customPropertyTypesForType) {
            if (!(customPropertyType.getDataType() instanceof IDataTypeWithFile)) continue;
            map_cockpitTypeID_customPropertyTypes.add((Object)cockpitTypeID, (Object)customPropertyType);
        }
    }

    private Collection<IModuleData> pasteData(final IModuleData newParent, final List<IModuleData> rootItems, final List<IModuleData> items, final List<EOLink> links, final List<EOLink> mdLinksToContext, final List<EOLink> loLinksToContext, final List<EOLink> mdLinksToFrameContext, final List<IModuleData> contextItems, final List<EOLink> linksToCopiedContext, final List<EOTemporaryFileForCopyAndPaste> tempFileDescriptors, final Map<String, String> objectTypeCategoryMetaInformation, final IModelController modelController, final Shell shell) {
        final ArrayList<IModuleData> copies = new ArrayList<IModuleData>(rootItems.size());
        final boolean[] hasBeenAborted = new boolean[1];
        modelController.executeTransaction(new Runnable(){

            @Override
            public void run() {
                EOLink copy;
                String newLinkableObjectUID;
                String projectUID = modelController.getProjectUID();
                HashMap<String, String> uidMap = new HashMap<String, String>();
                ArrayList<Object> createdItemsSet = new ArrayList<Object>(rootItems.size() + items.size() + contextItems.size());
                ArrayList<EOLink> createdLinksSet = new ArrayList<EOLink>(links.size() + mdLinksToContext.size() + loLinksToContext.size() + mdLinksToFrameContext.size() + linksToCopiedContext.size());
                for (IModuleData copiedItem : rootItems) {
                    IModuleData copy3 = copiedItem.copy(projectUID);
                    copy3.setProjectUID(projectUID);
                    AbstractCopyManager.this.setTemporaryDummyID(copy3);
                    uidMap.put(copiedItem.getUID(), copy3.getUID());
                    createdItemsSet.add(copy3);
                    copies.add(copy3);
                    modelController.addItem(copy3);
                    if (newParent == null) continue;
                    modelController.createLink(newParent.getUID(), copy3, AbstractCopyManager.this.linkTypeHelper.getHierarchyLinkTypeID(newParent.getTypeID(), copy3.getTypeID()));
                }
                for (IModuleData copiedItem : items) {
                    Iterator copy2 = copiedItem.copy(projectUID);
                    copy2.setProjectUID(projectUID);
                    AbstractCopyManager.this.setTemporaryDummyID(copy2);
                    uidMap.put(copiedItem.getUID(), copy2.getUID());
                    createdItemsSet.add(copy2);
                    modelController.addItem((IModuleData)((Object)copy2));
                }
                MapMap map_typeID_importedCategory_existingCategory = new MapMap();
                for (IModuleData iModuleData : createdItemsSet) {
                    ObjectTypeCategoryID objectTypeCategoryID = iModuleData.getCategoryID();
                    if (objectTypeCategoryID == null) continue;
                    String importedCategoryUID = objectTypeCategoryID.getUID();
                    if (map_typeID_importedCategory_existingCategory.containsKey((Object)iModuleData.getTypeID(), (Object)importedCategoryUID)) {
                        iModuleData.setCategoryID((ObjectTypeCategoryID)map_typeID_importedCategory_existingCategory.get((Object)iModuleData.getTypeID(), (Object)importedCategoryUID));
                        continue;
                    }
                    String humanReadableIDOfImportedCategory = (String)objectTypeCategoryMetaInformation.get(importedCategoryUID);
                    ObjectTypeCategory matchingExistingCategory = ((IFrameProjectAgent)modelController.getProjectAgent()).getObjectTypeCategoriesManager().getCategoryByHumanreadableID(iModuleData.getTypeID(), humanReadableIDOfImportedCategory);
                    ObjectTypeCategoryID matchingExistingCategoryID = matchingExistingCategory != null ? matchingExistingCategory.getObjectTypeCategoryID() : null;
                    map_typeID_importedCategory_existingCategory.put((Object)iModuleData.getTypeID(), (Object)humanReadableIDOfImportedCategory, (Object)matchingExistingCategoryID);
                    iModuleData.setCategoryID(matchingExistingCategoryID);
                }
                for (EOLink eOLink : links) {
                    EOLink eOLink2 = new EOLink(eOLink);
                    eOLink2.setProjectUID(projectUID);
                    String newModuleDataUID = (String)uidMap.get(eOLink2.getModuleDataUID());
                    eOLink2.setModuleDataUID(newModuleDataUID);
                    newLinkableObjectUID = (String)uidMap.get(eOLink2.getLinkableObjectUID());
                    eOLink2.setLinkableObjectUID(newLinkableObjectUID);
                    createdLinksSet.add(eOLink2);
                    modelController.addLinks(Collections.singleton(eOLink2), eOLink2.getLinkTypeID());
                }
                for (EOLink eOLink : mdLinksToContext) {
                    boolean mayLinkContextItem;
                    IModuleData iModuleData = modelController.getItem(AbstractCopyManager.this.linkTypeHelper.getLinkTargetDataTypeIDForLinkType(eOLink.getLinkTypeID()), eOLink.getLinkableObjectUID());
                    if (iModuleData == null || !(mayLinkContextItem = modelController.getPermissionMgr().mayLinkItem(iModuleData, eOLink.getLinkTypeID(), 1))) continue;
                    copy = new EOLink(eOLink);
                    copy.setProjectUID(projectUID);
                    String newModuleDataUID = (String)uidMap.get(copy.getModuleDataUID());
                    copy.setModuleDataUID(newModuleDataUID);
                    createdLinksSet.add(copy);
                    modelController.addLinks(Collections.singleton(copy), copy.getLinkTypeID());
                }
                for (EOLink eOLink : loLinksToContext) {
                    boolean mayLinkContextItem;
                    IModuleData iModuleData = modelController.getItem(AbstractCopyManager.this.linkTypeHelper.getLinkSourceDataTypeIDForLinkType(eOLink.getLinkTypeID()), eOLink.getModuleDataUID());
                    if (iModuleData == null || !(mayLinkContextItem = modelController.getPermissionMgr().mayLinkItem(iModuleData, eOLink.getLinkTypeID(), 0))) continue;
                    copy = new EOLink(eOLink);
                    copy.setProjectUID(projectUID);
                    String newLinkableObjectUID2 = (String)uidMap.get(copy.getLinkableObjectUID());
                    copy.setLinkableObjectUID(newLinkableObjectUID2);
                    createdLinksSet.add(copy);
                    modelController.addLinks(Collections.singleton(copy), copy.getLinkTypeID());
                }
                for (EOLink eOLink : mdLinksToFrameContext) {
                    if (!modelController.getPlatformAccessAgent().itemExists(AbstractCopyManager.this.linkTypeHelper.getLinkTargetDataTypeIDForLinkType(eOLink.getLinkTypeID()), eOLink.getLinkableObjectUID())) continue;
                    EOLink eOLink3 = new EOLink(eOLink);
                    eOLink3.setProjectUID(projectUID);
                    String newModuleDataUID = (String)uidMap.get(eOLink3.getModuleDataUID());
                    eOLink3.setModuleDataUID(newModuleDataUID);
                    createdLinksSet.add(eOLink3);
                    modelController.addLinks(Collections.singleton(eOLink3), eOLink3.getLinkTypeID());
                }
                for (IModuleData iModuleData : contextItems) {
                    IModuleData iModuleData2 = AbstractCopyManager.this.getExistingContextItem(iModuleData, modelController);
                    if (iModuleData2 != null) {
                        uidMap.put(iModuleData.getUID(), iModuleData2.getUID());
                        continue;
                    }
                    IModuleData copy4 = iModuleData.copy(projectUID);
                    copy4.setProjectUID(projectUID);
                    AbstractCopyManager.this.setTemporaryDummyID(copy4);
                    uidMap.put(iModuleData.getUID(), copy4.getUID());
                    createdItemsSet.add(copy4);
                    modelController.addItem(copy4);
                }
                for (EOLink eOLink : linksToCopiedContext) {
                    EOLink eOLink4 = new EOLink(eOLink);
                    eOLink4.setProjectUID(projectUID);
                    String newModuleDataUID = (String)uidMap.get(eOLink4.getModuleDataUID());
                    eOLink4.setModuleDataUID(newModuleDataUID);
                    newLinkableObjectUID = (String)uidMap.get(eOLink4.getLinkableObjectUID());
                    eOLink4.setLinkableObjectUID(newLinkableObjectUID);
                    createdLinksSet.add(eOLink4);
                    modelController.addLinks(Collections.singleton(eOLink4), eOLink4.getLinkTypeID());
                }
                HashMap<String, ListMap> hashMap = new HashMap<String, ListMap>();
                SetMap modifiedItems = new SetMap();
                for (final IModuleData iModuleData : createdItemsSet) {
                    AbstractCopyManager.this.restoreTemporarilyRemovedID(iModuleData);
                    if (!modelController.assertIDIsSet(iModuleData) || modelController.hasExistingID(iModuleData)) {
                        ListMap map_parent_idReceiversForChildren = (ListMap)hashMap.get(iModuleData.getTypeID());
                        if (map_parent_idReceiversForChildren == null) {
                            map_parent_idReceiversForChildren = new ListMap();
                            hashMap.put(iModuleData.getTypeID(), map_parent_idReceiversForChildren);
                        }
                        map_parent_idReceiversForChildren.add((Object)modelController.getParent(iModuleData), (Object)new INewIDReceiver(){

                            @Override
                            public void setNewID(String newID) {
                                iModuleData.getAttribute(iModuleData.getTypeDescription().getIDAttribute()).setValueViaDisplayStringRepresentation(newID);
                            }

                            @Override
                            public void setLock(LockAccess lock) {
                            }
                        });
                    }
                    modifiedItems.add((Object)iModuleData.getTypeID(), (Object)iModuleData);
                    if (!modelController.hasExistingName(iModuleData, modelController.getParent(iModuleData))) continue;
                    String newName = modelController.generateNewName(iModuleData, modelController.getParent(iModuleData), true, null);
                    if (newName != null) {
                        iModuleData.getAttribute(iModuleData.getTypeDescription().getNameAttribute()).setValueViaDisplayStringRepresentation(newName);
                        continue;
                    }
                    modelController.undoItemCreation(createdItemsSet, createdLinksSet);
                    hasBeenAborted[0] = true;
                    return;
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    IModuleDataTypeDescription typeDescription = modelController.getDataTypesHelper().getTypeDescription((String)entry.getKey());
                    try {
                        modelController.generateNewIDs((CollectionMap<IModuleData, INewIDReceiver>)((CollectionMap)entry.getValue()), typeDescription, 0, true, false);
                    }
                    catch (EXCockpitLockDenied e) {
                        modelController.undoItemCreation(createdItemsSet, createdLinksSet);
                        hasBeenAborted[0] = true;
                        return;
                    }
                }
                for (String string : modifiedItems.keySet()) {
                    Set refreshedItemsOfType = modifiedItems.get((Object)string);
                    modelController.itemPropertiesModified(refreshedItemsOfType.toArray(new IModuleData[refreshedItemsOfType.size()]), null);
                }
                AbstractCopyManager.this.clearTemporaryRemovedIDsMap();
                AbstractCopyManager.handlePasteOfFileCustomProperties(createdItemsSet, tempFileDescriptors, modelController, shell);
                AbstractCopyManager.this.customPasteOperations(newParent, rootItems, items, links, mdLinksToContext, loLinksToContext, contextItems, linksToCopiedContext, uidMap, modelController);
            }
        });
        if (!hasBeenAborted[0]) {
            return copies;
        }
        return null;
    }

    private static void handlePasteOfFileCustomProperties(Collection<IModuleData> items, Collection<EOTemporaryFileForCopyAndPaste> tempFileDescriptors, IModelController modelController, Shell shell) {
        IFilesManager fileManager = ((ProjectAgent)modelController.getProjectAgent()).getFilesManager();
        HashSet_ tempFileDescriptors_withHasherWithoutProjectUID = new HashSet_(tempFileDescriptors, (IHasher_)new IHasher_<EOTemporaryFileForCopyAndPaste>(){

            public int getHashCode(EOTemporaryFileForCopyAndPaste object) {
                return object.hashCodeWithoutProjectUID();
            }

            public boolean isEqual(EOTemporaryFileForCopyAndPaste object1, EOTemporaryFileForCopyAndPaste object2) {
                return object1.equalsWithoutProjectUID((Object)object2);
            }
        });
        SetMap map_cockpitTypeID_customPropertyTypes = new SetMap();
        boolean anyFilesCouldNotBeCopied = false;
        for (IModuleData item : items) {
            if (!map_cockpitTypeID_customPropertyTypes.containsKey((Object)item.getTypeID())) {
                AbstractCopyManager.findFileCustomProperties(item.getTypeID(), modelController, (SetMap<String, IAttributeType>)map_cockpitTypeID_customPropertyTypes);
            }
            Set fileCustomPropertyTypes = map_cockpitTypeID_customPropertyTypes.get((Object)item.getTypeID());
            for (IAttributeType fileCustomPropertyType : fileCustomPropertyTypes) {
                File file;
                IDataTypeWithFile fileCustomPropertyTypeDataType = (IDataTypeWithFile)fileCustomPropertyType.getDataType();
                IAttribute fileCustomProperty = item.getCustomAttribute(fileCustomPropertyType);
                FileID fileDescriptor = null;
                if (fileCustomProperty != null) {
                    fileDescriptor = (FileID)fileCustomProperty.getAttributeValue();
                }
                if (fileDescriptor == null) continue;
                FileID newFileID = FileID.NO_FILE;
                EOTemporaryFileForCopyAndPaste tempFileDescriptorKey = new EOTemporaryFileForCopyAndPaste(null, fileDescriptor.getFileUID(), "");
                EOTemporaryFileForCopyAndPaste tempFileDescriptor = (EOTemporaryFileForCopyAndPaste)((Object)tempFileDescriptors_withHasherWithoutProjectUID.get((Object)tempFileDescriptorKey));
                if (tempFileDescriptor != null && (file = new File(tempFileDescriptor.getTemporaryFile())).exists()) {
                    FileResourceWithOverwrittenName fileResource = new FileResourceWithOverwrittenName(file, tempFileDescriptor.getOriginalFileName());
                    try {
                        newFileID = fileManager.loadFileIntoTemporaryStorage((IStreamResource)fileResource);
                    }
                    catch (JvmExternalResourceInteractionException jeriE) {
                        anyFilesCouldNotBeCopied = true;
                    }
                }
                CustomModuleAttribute newFileCustomProperty = new CustomModuleAttribute(fileCustomPropertyType.getAttributeTypeID(), newFileID);
                fileCustomPropertyTypeDataType.notifyAboutValueBeeingInUse((Object)newFileID);
                item.setCustomAttribute(fileCustomPropertyType, newFileCustomProperty);
                if (tempFileDescriptor == null || newFileID.equals((Object)FileID.NO_FILE)) continue;
                fileManager.removeFileFromTemporaryStorage(newFileID);
            }
        }
        if (anyFilesCouldNotBeCopied) {
            MessageDialog.openWarning((Shell)shell, (String)Messages.getString("AbstractCopyManager.Error.FileCustomProperties.Title"), (String)Messages.getString("AbstractCopyManager.Error.FileCustomProperties.Message"));
        }
    }

    private void setTemporaryDummyID(IModuleData item) {
        String idAttributeID = item.getTypeDescription().getIDAttribute();
        if (idAttributeID != null) {
            String currentID = item.getAttribute(idAttributeID).getUniqueStringRepresentation();
            this.map_uid_temporarilyRemovedID.put(new KeyUID(item), currentID);
            item.getAttribute(idAttributeID).setValueViaUniqueStringRepresentation(TEMPORARY_DUMMY_ID_FOR_COPIED_ITEMS);
        }
    }

    private void restoreTemporarilyRemovedID(IModuleData item) {
        String idAttributeID = item.getTypeDescription().getIDAttribute();
        if (idAttributeID != null) {
            String oldID = this.map_uid_temporarilyRemovedID.get(new KeyUID(item));
            if (oldID != null) {
                item.getAttribute(idAttributeID).setValueViaUniqueStringRepresentation(oldID);
            } else {
                item.getAttribute(idAttributeID).setValueViaUniqueStringRepresentation("");
            }
        }
    }

    private void clearTemporaryRemovedIDsMap() {
        this.map_uid_temporarilyRemovedID.clear();
    }

    private static void sortDataToBeCopied(List<IModuleData> dataToBeCopied, IModelController modelController) {
        Comparator<IModuleData> naturalOrderComparator = StandardTreeDataViewSorter.getComparatorForNaturalOrder(modelController);
        Collections.sort(dataToBeCopied, naturalOrderComparator);
    }
}

