/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EnumerationEntry;
import com.arcway.cockpit.modulelib2.client.core.project.ModulePlatformAccess;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.EnumValueReference;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.ExistingAttributeReference;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.TargetAttributeDescription;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDiscrete;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IAttributeMappingPersistencyHelper;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription_forEnumValueMapping;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.memento.ArcwayMementoHelper;
import com.arcway.lib.memento.IArcwayMemento;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import java.util.List;

public class AttributeMappingPersistencyHelper
implements IAttributeMappingPersistencyHelper<Object, String, ExistingAttributeReference, Integer, EnumValueReference> {
    private static final String MEMENTO_ID_ATTRIBUTEASSIGNMENT = "ATTRIBUTE-ASSIGNMENT";
    private static final String MEMENTO_ID_EXISTINGATTRIBUTEID = "EXISTING-ATTRIBUTE-ID";
    private static final String MEMENTO_ID_EXISTINGATTRIBUTETYPE = "EXISTING-ATTRIBUTE-TYPE";
    private static final String MEMENTO_ID_ENUMVALUEMAPPING = "ENUM-VALUE-MAPPING";
    private static final String MEMENTO_ID_ENUMVALUEMAPPINGTYPE = "ENUM-VALUE-MAPPING-TYPE";
    private static final String MEMENTO_ID_VALUEASSIGNEMENT = "VALUE-ASSIGNMENT";
    private static final String MEMENTO_ID_EXISTINGVALUEID = "EXISTING-VALUE-ID";
    private final ModulePlatformAccess platformAccessAgent;

    public AttributeMappingPersistencyHelper(ModulePlatformAccess platformAccessAgent) {
        this.platformAccessAgent = platformAccessAgent;
    }

    public IArcwayMemento createChildMementoForAttributeAssignment(IArcwayMemento parent, Object sourceKey) {
        return ArcwayMementoHelper.getOrCreateChild((IArcwayMemento)parent, (String)MEMENTO_ID_ATTRIBUTEASSIGNMENT, (String)new Integer(sourceKey.hashCode()).toString());
    }

    public void storeTargetKeyIntoMemento(IArcwayMemento memento, ExistingAttributeReference targetKey) {
        if (targetKey != null) {
            memento.putString(MEMENTO_ID_EXISTINGATTRIBUTEID, targetKey.getAttributeID());
            memento.putInteger(MEMENTO_ID_EXISTINGATTRIBUTETYPE, targetKey.getAttributeKind().intValue());
        } else {
            memento.putString(MEMENTO_ID_EXISTINGATTRIBUTEID, "");
            memento.putInteger(MEMENTO_ID_EXISTINGATTRIBUTETYPE, -1);
        }
    }

    public IArcwayMemento createChildMementoForEnumValueMapping(IArcwayMemento parent, Object sourceKey) {
        return ArcwayMementoHelper.getOrCreateChild((IArcwayMemento)parent, (String)MEMENTO_ID_ENUMVALUEMAPPING, (String)new Integer(sourceKey.hashCode()).toString());
    }

    public void storeTargetAttributeConstraintsForEnumValueMappingIntoMemento(IArcwayMemento memento, ITargetAttributeDescription<ExistingAttributeReference, Integer, EnumValueReference> targetAttribute) {
        memento.putInteger(MEMENTO_ID_ENUMVALUEMAPPINGTYPE, ((TargetAttributeDescription)targetAttribute).getEnumerationType());
    }

    public IArcwayMemento createChildMementoForEnumValueAssignment(IArcwayMemento parent, String sourceEnumValueKey) {
        return ArcwayMementoHelper.getOrCreateChild((IArcwayMemento)parent, (String)MEMENTO_ID_VALUEASSIGNEMENT, (String)sourceEnumValueKey);
    }

    public void storeTargetEnumKeyIntoMemento(IArcwayMemento memento, EnumValueReference targetEnumValueKey) {
        switch (targetEnumValueKey.getEnumValueKind()) {
            case 0: {
                Integer index = (Integer)targetEnumValueKey.getEnumValueReference();
                memento.putInteger(MEMENTO_ID_EXISTINGVALUEID, index.intValue());
                break;
            }
            case 1: {
                String moduleDataUID = (String)targetEnumValueKey.getEnumValueReference();
                memento.putString(MEMENTO_ID_EXISTINGVALUEID, moduleDataUID);
                break;
            }
            case 3: {
                if (targetEnumValueKey.getEnumValueReference() == null) {
                    memento.putString(MEMENTO_ID_EXISTINGVALUEID, "");
                    break;
                }
                IRepositoryObjectReference frameDataObject = (IRepositoryObjectReference)targetEnumValueKey.getEnumValueReference();
                this.platformAccessAgent.storeKeyForFrameDataItem(frameDataObject, memento);
                break;
            }
            case 2: {
                String customEnumerationValueID = (String)targetEnumValueKey.getEnumValueReference();
                memento.putString(MEMENTO_ID_EXISTINGVALUEID, customEnumerationValueID);
            }
        }
    }

    public IArcwayMemento getChildMementoForAttributeAssignment(IArcwayMemento parent, Object sourceKey) {
        return parent.getChild(MEMENTO_ID_ATTRIBUTEASSIGNMENT, new Integer(sourceKey.hashCode()).toString());
    }

    public ITargetAttributeDescription<ExistingAttributeReference, Integer, EnumValueReference> getTargetKeyOfMemento(IArcwayMemento memento, ICollection_<? extends ITargetAttributeDescription<ExistingAttributeReference, Integer, EnumValueReference>> targetAttributes, ITargetAttributeDescription<ExistingAttributeReference, Integer, EnumValueReference> markerForNoMapping) {
        String mappedTargetAttributeID = memento.getString(MEMENTO_ID_EXISTINGATTRIBUTEID);
        int attributeType = memento.getInteger(MEMENTO_ID_EXISTINGATTRIBUTETYPE);
        if (mappedTargetAttributeID.equals("") && attributeType == -1) {
            return markerForNoMapping;
        }
        for (ITargetAttributeDescription targetAttribute : targetAttributes) {
            if (!((ExistingAttributeReference)targetAttribute.getKey()).getAttributeID().equals(mappedTargetAttributeID) || ((ExistingAttributeReference)targetAttribute.getKey()).getAttributeKind() != attributeType) continue;
            return targetAttribute;
        }
        return null;
    }

    public IArcwayMemento getChildMementoForEnumValueMapping(IArcwayMemento parent, Object sourceKey) {
        IArcwayMemento[] enumValueMappings = parent.getChildren(MEMENTO_ID_ENUMVALUEMAPPING);
        String hashedSourceKey = new Integer(sourceKey.hashCode()).toString();
        IArcwayMemento[] iArcwayMementoArray = enumValueMappings;
        int n = enumValueMappings.length;
        int n2 = 0;
        while (n2 < n) {
            IArcwayMemento enumValueMapping = iArcwayMementoArray[n2];
            if (enumValueMapping.getID().equals(hashedSourceKey)) {
                return enumValueMapping;
            }
            ++n2;
        }
        return null;
    }

    public boolean isMatchingTargetAttributeConstraintsForEnumValueMappingOfMemento(IArcwayMemento memento, ITargetAttributeDescription<ExistingAttributeReference, Integer, EnumValueReference> targetAttribute) {
        int enumValueMappingType = memento.getInteger(MEMENTO_ID_ENUMVALUEMAPPINGTYPE);
        return enumValueMappingType == ((TargetAttributeDescription)targetAttribute).getEnumerationType();
    }

    public IArcwayMemento getChildMementoForEnumValueAssignment(IArcwayMemento parent, String sourceEnumValueKey) {
        IArcwayMemento[] valueAssignments;
        IArcwayMemento[] iArcwayMementoArray = valueAssignments = parent.getChildren(MEMENTO_ID_VALUEASSIGNEMENT);
        int n = valueAssignments.length;
        int n2 = 0;
        while (n2 < n) {
            IArcwayMemento valueAssignment = iArcwayMementoArray[n2];
            if (sourceEnumValueKey.equals(valueAssignment.getID())) {
                return valueAssignment;
            }
            ++n2;
        }
        return null;
    }

    public EnumValueReference getTargetEnumKeyOfMemento(IArcwayMemento memento, ITargetAttributeDescription_forEnumValueMapping<EnumValueReference> targetAttribute_) {
        TargetAttributeDescription targetAttribute = (TargetAttributeDescription)targetAttribute_;
        int enumValueMappingType = targetAttribute.getEnumerationType();
        if (enumValueMappingType == 0) {
            int discreteValueIndex = memento.getInteger(MEMENTO_ID_EXISTINGVALUEID);
            if (discreteValueIndex < ((ModuleDataAttributeDiscrete)targetAttribute.getKey().getAttribute()).getValueRange().length) {
                return new EnumValueReference(0, new Integer(discreteValueIndex));
            }
        } else if (enumValueMappingType == 1) {
            String linkedModuleDataUID = memento.getString(MEMENTO_ID_EXISTINGVALUEID);
            if (linkedModuleDataUID.equals("")) {
                return new EnumValueReference(1, "");
            }
            if (targetAttribute.getKey().getModelController().itemExists(targetAttribute.getKey().getLinkedModuleDataDataTypeID(), linkedModuleDataUID)) {
                return new EnumValueReference(1, linkedModuleDataUID);
            }
        } else if (enumValueMappingType == 3) {
            String linkedFrameDataUID = memento.getString(MEMENTO_ID_EXISTINGVALUEID);
            if (linkedFrameDataUID != null && linkedFrameDataUID.equals("")) {
                return new EnumValueReference(3, null);
            }
            IRepositoryObjectReference frameDataObject = targetAttribute.getKey().getPlatformAccessAgent().getFrameDataItem(memento);
            if (frameDataObject != null) {
                return new EnumValueReference(3, frameDataObject);
            }
        } else if (enumValueMappingType == 2) {
            String customEnumerationValueID = memento.getString(MEMENTO_ID_EXISTINGVALUEID);
            if (customEnumerationValueID.equals("")) {
                return new EnumValueReference(2, "");
            }
            List existingValueRange = (List)targetAttribute.getKey().getAttributeType().getValueRange().getValueRange();
            for (Object existingValueAsObject : existingValueRange) {
                EnumerationEntry existingValue = (EnumerationEntry)existingValueAsObject;
                if (!existingValue.getID().equals(customEnumerationValueID)) continue;
                return new EnumValueReference(2, customEnumerationValueID);
            }
        }
        return null;
    }
}

