/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IModuleUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.IncompatibleDataTypeException;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.CustomModuleAttribute;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData_CustomPropertiesExtension;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttribute;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeTimestamp;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeUser;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.messages.description.ModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.modulelib2.shared.messages.EOModuleData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.lib.resources.IIconResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractModuleAttributeAgent
implements IAttributeOwner,
IAttributeModificationManager,
IModuleData {
    private static final ILogger logger = Logger.getLogger(AbstractModuleAttributeAgent.class);
    private static final String NO_LOCK = Messages.getString("AbstractModuleAttributeAgent.ErrMsgLock");
    private static final String NO_PERMISSION = Messages.getString("AbstractModuleAttributeAgent.ErrMsgPermission");
    private final IModuleData_CustomPropertiesExtension moduleData;
    private final IModuleUserDefinedAttributeTypesManager typesManager;

    public AbstractModuleAttributeAgent(IModuleData_CustomPropertiesExtension moduleData, IModuleUserDefinedAttributeTypesManager typesManager) {
        assert (moduleData != null) : "moduleData must not be null";
        assert (typesManager != null) : "typesManager must not be null";
        this.moduleData = moduleData;
        this.typesManager = typesManager;
    }

    public int getModificationCount() {
        return this.moduleData.getModuleData().getModificationCount();
    }

    @Override
    public void setModificationCount(int modificationCount) {
        this.getModuleData().setModificationCount(modificationCount);
    }

    public int getCommitCount() {
        return this.getModuleData().getCommitCount();
    }

    @Override
    public void setCommitCount(int commitCount) {
        this.getModuleData().setCommitCount(commitCount);
    }

    @Override
    public ObjectTypeCategoryID getCategoryID() {
        return this.getModuleData().getCategoryID();
    }

    @Override
    public void setCategoryID(ObjectTypeCategoryID categoryID) {
        this.getModuleData().setCategoryID(categoryID);
    }

    public Collection<IAttribute> getAllAttributes() {
        Collection types = this.typesManager.getAttributeTypesForModuleData(this.moduleData.getTypeID());
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>(types.size());
        for (IAttributeType type : types) {
            try {
                attributes.add(this.getAttribute(type.getAttributeTypeID()));
            }
            catch (ExInvalidAttributeType e) {
                logger.error("Could not get attribute ", (Throwable)e);
            }
        }
        return attributes;
    }

    public IAttributeType getAttributeTypeByHumanreadableID(String humanreadableID) {
        for (IAttribute attribute : this.getAllAttributes()) {
            IAttributeType attributeType = this.getAttributeType(attribute.getAttributeTypeID());
            if (!attributeType.getHumanReadableID().equals(humanreadableID)) continue;
            return attributeType;
        }
        return null;
    }

    private IAttribute doGetAttribute(IAttributeType attributeType) {
        IAttribute attribute = this.moduleData.getCustomAttribute(attributeType);
        if (attribute == null) {
            attribute = new Attribute(attributeType.getAttributeTypeID(), attributeType.getDataType().getDefaultValue());
        }
        return attribute;
    }

    public IAttribute getAttribute(IAttributeTypeID attributeTypeID) throws ExInvalidAttributeType {
        IAttributeType type = this.getAttributeType(attributeTypeID);
        if (type == null) {
            throw ExInvalidAttributeType.getExceptionForNoneExistingAttributeType((String)attributeTypeID.getUID());
        }
        return this.doGetAttribute(type);
    }

    public IAttributeType getAttributeType(IAttributeTypeID attributeTypeID) throws ExInvalidAttributeType {
        IAttributeType type = this.typesManager.getUserDefinedAttributeType(attributeTypeID);
        return type;
    }

    @Override
    public String getProjectUID() {
        return this.moduleData.getProjectUID();
    }

    @Override
    public String getTypeID() {
        return this.moduleData.getTypeID();
    }

    @Override
    public String getUID() {
        return this.moduleData.getUID();
    }

    public void requestAttributeModificationPermission(IAttribute newAttribute, ILocksAndPermissionsTransactionController transactionController) {
        if (this.getPermissionMgr().mayEditAttribute(this.moduleData.getModuleData(), this.getParent(), this.typesManager.getUserDefinedAttributeType(newAttribute.getAttributeTypeID()))) {
            LockAccess la = this.getLockMgr().acquireEditLock((ICockpitProjectData)this.moduleData.getModuleData(), false);
            if (!la.hasLock()) {
                EOLock firstConflictingsLock = la.getConflictingLocks().iterator().next();
                transactionController.addLockModificationProblem((IModificationProblem)new ModificationProblem(firstConflictingsLock, NO_LOCK));
            }
        } else {
            transactionController.addLockModificationProblem((IModificationProblem)new ModificationProblem(this.typesManager.getUserDefinedAttributeType(newAttribute.getAttributeTypeID()), this.getPermissionMgr().getParentOperandTree(this.getItem(), this.getParent()), this.moduleData.getProjectUID()));
        }
    }

    public void requestObjectTypeCategoryModificationPermission(ILocksAndPermissionsTransactionController transactionController) {
        throw new UnsupportedOperationException();
    }

    public Collection<IModificationProblem> checkObjectTypeCategoryModificationPermission() {
        throw new UnsupportedOperationException();
    }

    public IModificationProblem checkLocks() {
        return null;
    }

    public Collection<IModificationProblem> checkGeneralModificationPermissions(IAttributeType attributeType) {
        ArrayList<IModificationProblem> modProblems = new ArrayList<IModificationProblem>();
        if (!this.getPermissionMgr().mayEditAttribute(this.moduleData.getModuleData(), this.getParent(), attributeType)) {
            modProblems.add((IModificationProblem)new ModificationProblem(attributeType, this.getPermissionMgr().getParentOperandTree(this.getItem(), this.getParent()), this.moduleData.getProjectUID()));
        }
        return modProblems;
    }

    @Deprecated
    public void modifyAttribute(IAttribute newAttribute, Object oldAttributeValue) throws ExInvalidAttributeType, ExInvalidDataType, EXNoPermission, EXNoLock {
        IAttributeType type = this.modifyAttributeStep1(newAttribute);
        this.modifyAttributeStep2(newAttribute, type);
    }

    public void modifyAttributeAndNotifyDataType(IAttribute newAttribute, Object oldAttributeValue) {
        IAttributeType type = this.modifyAttributeStep1(newAttribute);
        if (oldAttributeValue != null) {
            type.getDataType().notifyAboutValueNotBeeingInUseAnymore(oldAttributeValue);
        }
        type.getDataType().notifyAboutValueBeeingInUse(newAttribute.getAttributeValue());
        this.modifyAttributeStep2(newAttribute, type);
    }

    private IAttributeType modifyAttributeStep1(IAttribute newAttribute) {
        IAttributeType type = this.typesManager.getUserDefinedAttributeType(newAttribute.getAttributeTypeID());
        if (type == null) {
            throw ExInvalidAttributeType.getExceptionForNoneExistingAttributeType((String)newAttribute.getAttributeTypeID().getUID());
        }
        if (!type.getDataType().supportsValue(newAttribute.getAttributeValue(), type.getValueRange())) {
            throw new ExInvalidDataType(newAttribute.getAttributeValue().getClass().toString(), type.getDataType().getDisplayName());
        }
        this.doSetAttribute(newAttribute, type);
        return type;
    }

    private void modifyAttributeStep2(IAttribute newAttribute, IAttributeType type) {
        this.modifyAttribute(newAttribute, this.moduleData, type);
    }

    private void doSetAttribute(IAttribute attribute, IAttributeType type) {
        if (attribute.getAttributeValue() == null) {
            attribute = new Attribute(type.getAttributeTypeID(), type.getDataType().getDefaultValue());
        }
        this.moduleData.setCustomAttribute(type, new CustomModuleAttribute(attribute));
    }

    protected abstract AbstractLockManager getLockMgr();

    protected abstract AbstractPermissionMgr getPermissionMgr();

    protected abstract void modifyAttribute(IAttribute var1, IModuleData_CustomPropertiesExtension var2, IAttributeType var3);

    protected abstract IModuleData getParent();

    protected IModuleData getItem() {
        return this.moduleData.getModuleData();
    }

    @Override
    public IModuleData copy(boolean includeUid) {
        return this.moduleData.getModuleData().copy(includeUid);
    }

    @Override
    public IModuleData copy(String projectUID) {
        return this.moduleData.getModuleData().copy(projectUID);
    }

    @Override
    public void copyDataFrom(AbstractModuleData moduleData, boolean includeUid) throws IncompatibleDataTypeException {
        moduleData.getModuleData().copyDataFrom(moduleData, includeUid);
    }

    @Override
    public boolean mergingHasEffect(IModuleData moduleDataToMerge) {
        return this.moduleData.getModuleData().mergingHasEffect(moduleDataToMerge);
    }

    @Override
    public IModuleData merge(IModuleData md) {
        return this.moduleData.getModuleData().merge(md);
    }

    @Override
    public EOModuleData createEncodableObject() {
        return this.moduleData.getModuleData().createEncodableObject();
    }

    public Map getAttributes() {
        return this.moduleData.getModuleData().getAttributes();
    }

    @Override
    public ModuleDataAttributeTimestamp getModificationTime() {
        return this.moduleData.getModuleData().getModificationTime();
    }

    @Override
    public ModuleDataAttributeTimestamp getCreationTime() {
        return this.moduleData.getModuleData().getCreationTime();
    }

    @Override
    public ModuleDataAttributeUser getModifier() {
        return this.moduleData.getModuleData().getModifier();
    }

    @Override
    public ModuleDataAttributeUser getCreator() {
        return this.moduleData.getModuleData().getCreator();
    }

    @Override
    public IModuleDataAttribute getAttribute(String role) {
        return this.moduleData.getModuleData().getAttribute(role);
    }

    @Override
    public void setProjectUID(String projectUID) {
        this.moduleData.getModuleData().setProjectUID(projectUID);
    }

    @Override
    public String getDisplayRepresentation() {
        return this.moduleData.getModuleData().getDisplayRepresentation();
    }

    @Override
    public String getDisplayRepresentation(Locale locale) {
        return this.moduleData.getModuleData().getDisplayRepresentation(locale);
    }

    @Override
    public void setDisplayRepresentation(String displayRepresentation) {
        this.moduleData.getModuleData().setDisplayRepresentation(displayRepresentation);
    }

    @Override
    public boolean isHistoricItem() {
        return this.moduleData.getModuleData().isHistoricItem();
    }

    @Override
    public ModuleDataTypeDescriptionForFrame getModuleDataTypeDescriptionForFrame() {
        return this.moduleData.getModuleData().getModuleDataTypeDescriptionForFrame();
    }

    @Override
    public boolean isIsomorphic(IModuleData item) {
        return this.moduleData.getModuleData().isIsomorphic(item);
    }

    @Override
    public Collection<? extends IAttribute> getCustomAttributes() {
        return this.moduleData.getModuleData().getCustomAttributes();
    }

    @Override
    public IAttribute getCustomAttribute(IAttributeType type) {
        return this.moduleData.getModuleData().getCustomAttribute(type);
    }

    @Override
    public void setCustomAttribute(IAttributeType type, CustomModuleAttribute attribute) {
        this.moduleData.getModuleData().setCustomAttribute(type, attribute);
    }

    @Override
    public IModuleData getModuleData() {
        return this.moduleData.getModuleData();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractModuleAttributeAgent) {
            AbstractModuleAttributeAgent attrAgent = (AbstractModuleAttributeAgent)obj;
            return this.getItem().equals(attrAgent.getItem());
        }
        if (obj instanceof IModuleData) {
            IModuleData moduleData = (IModuleData)obj;
            return this.getItem().equals(moduleData);
        }
        return false;
    }

    public int hashCode() {
        return this.getItem().hashCode();
    }

    @Override
    public void setUid(String newUID) {
        this.moduleData.getModuleData().setUid(newUID);
    }

    @Override
    public String getStatus() {
        return this.moduleData.getModuleData().getStatus();
    }

    @Override
    public IIconResource getStatusDependentIcon() {
        return this.moduleData.getModuleData().getStatusDependentIcon();
    }

    @Override
    public IIconResource getAttributeIcon(String attributeID) {
        return this.moduleData.getModuleData().getAttributeIcon(attributeID);
    }

    @Override
    public IModuleDataTypeDescription getTypeDescription() {
        return this.moduleData.getModuleData().getTypeDescription();
    }

    public void modifyCategoryID() throws EXNoPermission, EXNoLock {
    }
}

