/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.infrastructure.specification;

import com.arcway.cockpit.genericmodule.client.infrastructure.resources.ResourceManager;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.IModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationReader;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.DetailsPageLayout;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ParentType;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.security.Security;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;

public class SpecificationProvider {
    private static SpecificationProvider singleton;
    private Map<String, ModuleSpecification> moduleSpecifications;
    private Map<String, Boolean> moduleSignatures;

    private SpecificationProvider() {
    }

    private void construct() {
        this.moduleSpecifications = SpecificationReader.getDefault().readAllModuleSpecifications();
        this.moduleSignatures = new HashMap<String, Boolean>();
    }

    public Map<String, ModuleSpecification> getModuleSpecifications() {
        return this.moduleSpecifications;
    }

    public ModuleSpecification getModuleSpecification(String moduleID) {
        return this.moduleSpecifications.get(moduleID);
    }

    public IModuleSpecificationPart getModuleSpecificationPart(Object partDescription) {
        if (!(partDescription instanceof String)) {
            return null;
        }
        String partID = (String)partDescription;
        ArrayList partIDList = StringUtil.split((String)partID, (char)'.', (int)-1);
        ArrayList moduleIDPair = StringUtil.split((String)((String)partIDList.get(0)), (char)'_', (int)2);
        String moduleID = (String)moduleIDPair.get(1);
        ModuleSpecification moduleSpecification = this.getModuleSpecification(moduleID);
        if (moduleSpecification == null) {
            return null;
        }
        IModuleSpecificationPart currentPart = moduleSpecification;
        int partIDIndex = 1;
        while (partIDIndex < partIDList.size()) {
            ArrayList partIDPair = StringUtil.split((String)((String)partIDList.get(partIDIndex)), (char)'_', (int)2);
            boolean partFound = false;
            for (IModuleSpecificationPart specPart : currentPart.getChildren()) {
                if (specPart == null || !specPart.getTypeID().equals(partIDPair.get(0)) || !specPart.getID().equals(partIDPair.get(1))) continue;
                currentPart = specPart;
                partFound = true;
                break;
            }
            if (!partFound) {
                return null;
            }
            ++partIDIndex;
        }
        return currentPart;
    }

    public String getModuleID(Object partDescription) {
        if (!(partDescription instanceof String)) {
            return null;
        }
        String partID = (String)partDescription;
        ArrayList partIDList = StringUtil.split((String)partID, (char)'.', (int)2);
        ArrayList moduleIDPair = StringUtil.split((String)((String)partIDList.get(0)), (char)'_', (int)2);
        String moduleID = (String)moduleIDPair.get(1);
        return moduleID;
    }

    public boolean verifySpecificationSignature(String moduleID) {
        Boolean signature = this.moduleSignatures.get(moduleID);
        if (signature != null) {
            return signature;
        }
        boolean valid = false;
        try {
            URL specFileURL = ResourceManager.getDefault().getResourceURL(moduleID, "spec/ModuleSpec.xml");
            File specFile = new File(FileLocator.toFileURL((URL)specFileURL).getPath());
            URL signatureFileURL = ResourceManager.getDefault().getResourceURL(moduleID, "spec/ModuleSpec.signature");
            File signatureFile = new File(FileLocator.toFileURL((URL)signatureFileURL).getPath());
            valid = Security.verifySignature((File)specFile, (File)signatureFile);
        }
        catch (IOException specFileURL) {
        }
        catch (Security.EXOldSignature e) {
            valid = true;
        }
        this.moduleSignatures.put(moduleID, valid);
        return valid;
    }

    public static ObjectType getObjectTypeForParentType(ModuleSpecification completeSpecification, ParentType parentType) {
        for (ObjectType objectType : completeSpecification.getModuleDataSpecification().getObjectTypeList()) {
            for (ParentType currentParentType : objectType.getParentTypeList()) {
                if (currentParentType != parentType) continue;
                return objectType;
            }
        }
        return null;
    }

    public static DetailsPageLayout getDetailsPageLayoutForObjectType(ModuleSpecification completeSpecification, ObjectType objectType) {
        DetailsPageLayout detailsPageLayout = completeSpecification.getModuleUISpecification().getDetailsPageLayout(objectType.getObjectTypeID());
        return detailsPageLayout;
    }

    public static String makeIdPath(String parentIdPath, String childTypeID, String childId) {
        if (parentIdPath != null && parentIdPath.length() > 0) {
            return String.valueOf(parentIdPath) + "." + childTypeID + "_" + childId;
        }
        return String.valueOf(childTypeID) + "_" + childId;
    }

    public static synchronized SpecificationProvider getDefault() {
        if (singleton == null) {
            singleton = new SpecificationProvider();
            singleton.construct();
        }
        return singleton;
    }
}

