/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.core.datamanagement;

import com.arcway.cockpit.frame.client.project.core.links.linkeddataaccess.ILinkedDataAccessFacade;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.messages.description.NaturalOrderDataTypeDescriptionForFrame;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;

public class NaturalOrderingLinkedDataAccessFacade
implements ILinkedDataAccessFacade {
    private final AbstractDataMgr dataManager;
    private final String naturalOrderVirtualTypeCockpitID;
    private final Set<String> realTypeIDs = new HashSet<String>();

    public NaturalOrderingLinkedDataAccessFacade(String moduleID, ModuleDataSpecification moduleDataSpecification, int typeRank, AbstractDataMgr dataManager) {
        for (ObjectType objectType : moduleDataSpecification.getObjectTypeList()) {
            String objectCockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(moduleID, objectType.getObjectTypeID());
            if (objectType.getTypeRank() != typeRank) continue;
            this.realTypeIDs.add(objectCockpitTypeID);
        }
        this.naturalOrderVirtualTypeCockpitID = NaturalOrderDataTypeDescriptionForFrame.getNaturalOrderDataTypeCockpitTypeID(moduleID, typeRank);
        this.dataManager = dataManager;
    }

    public String getDataTypeID() {
        return this.naturalOrderVirtualTypeCockpitID;
    }

    public boolean isLinkedItemExistent(String UID, boolean checkOnServerState) {
        for (String realType : this.realTypeIDs) {
            if (!(checkOnServerState ? this.dataManager.itemExistsOnServer((Object)UID, (Object)realType) : this.dataManager.itemExists((Object)UID, (Object)realType))) continue;
            return true;
        }
        return false;
    }

    public ICockpitProjectData getLinkedItem(String UID) {
        for (String realType : this.realTypeIDs) {
            IModuleData item = (IModuleData)this.dataManager.getItem((Object)realType, (Object)UID);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public ICockpitProjectData getLinkedItemVersion(String UID, int version) {
        return null;
    }

    public boolean isCreationOfNewItemsPossible() {
        return false;
    }

    public ICockpitProjectData createNewItem() {
        return null;
    }

    public ILabelProvider getLabelProvider() {
        return null;
    }
}

