/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.shared;

import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.util.Zip;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.psc.shared.DumpFileAccessException;
import de.plans.psc.shared.DumpFileHasInvalidFileTypeException;
import de.plans.psc.shared.message.EOVersionFileContent;
import java.io.File;
import java.io.IOException;

public abstract class ProjectDumpFileAccess {
    private static final ILogger logger = Logger.getLogger(ProjectDumpFileAccess.class);
    private static final int STATE_ERROR = 1;
    private static final int STATE_EVERYTHING_ACCESSIBLE = 3;
    private static final int STATE_DISPOSED = 4;
    private File projectDumpFile;
    private File rootDirectoryOfUnzippedProjectDumpFile;
    private int state;
    private int version = -2;
    private EOVersionFileContent versionFileContent;

    public ProjectDumpFileAccess(File projectDumpFile) {
        assert (projectDumpFile != null && projectDumpFile.exists());
        if (projectDumpFile.isFile()) {
            this.projectDumpFile = projectDumpFile;
        } else {
            this.projectDumpFile = null;
            this.rootDirectoryOfUnzippedProjectDumpFile = projectDumpFile;
        }
    }

    protected void init() throws DumpFileAccessException {
        if (this.projectDumpFile != null) {
            String fileType;
            try {
                this.rootDirectoryOfUnzippedProjectDumpFile = this.createRootDirectoryOfUnzippedProjectDumpFile();
            }
            catch (DumpFileAccessException dfaE) {
                this.state = 1;
                throw dfaE;
            }
            this.unzipProjectDump();
            EOVersionFileContent versionFileContent_ = this.getVersionFileContent();
            if (versionFileContent_ != null && (fileType = versionFileContent_.getFileType()) != null && fileType.trim().length() > 0 && !fileType.equals("cockpit.project-dump")) {
                throw new DumpFileHasInvalidFileTypeException("The given file is not a Cockpit project dump (file type: " + fileType + ").", fileType);
            }
        }
        this.state = 3;
    }

    public int getVersion() throws DumpFileAccessException {
        this.checkState();
        if (this.version == -2) {
            Integer frameVersionAsInteger;
            EOVersionFileContent versionsMap_ = this.getVersionFileContent();
            this.version = versionsMap_ != null ? ((frameVersionAsInteger = versionsMap_.getVersion("COCKPIT_FRAME")) != null ? frameVersionAsInteger : -1) : -1;
        }
        return this.version;
    }

    public EOVersionFileContent getVersionFileContent() throws DumpFileAccessException {
        this.checkState();
        if (this.versionFileContent == null) {
            try {
                this.versionFileContent = this.readVersionFile();
            }
            catch (DumpFileAccessException pfaE) {
                this.versionFileContent = null;
            }
        }
        return this.versionFileContent;
    }

    protected boolean isCreatedFromProjectDumpFile() {
        return this.projectDumpFile != null;
    }

    public void dispose() {
        this.dispose_internal();
    }

    protected void dispose_internal() {
        if (this.state != 4) {
            try {
                try {
                    if (this.projectDumpFile != null) {
                        FileHelper.deleteExistingFileOrDirectory((File)this.rootDirectoryOfUnzippedProjectDumpFile);
                    }
                }
                catch (JvmExternalResourceInteractionException jeriE) {
                    logger.warn("Could not delete the unzipped project dump file contents during disposal (" + this.rootDirectoryOfUnzippedProjectDumpFile.getAbsolutePath() + ").", (Throwable)jeriE);
                    this.rootDirectoryOfUnzippedProjectDumpFile = null;
                    this.state = 4;
                }
            }
            finally {
                this.rootDirectoryOfUnzippedProjectDumpFile = null;
                this.state = 4;
            }
        }
    }

    protected abstract File createRootDirectoryOfUnzippedProjectDumpFile() throws DumpFileAccessException;

    public File getRootDirectoryOfUnzippedProjectDumpFile() {
        return this.rootDirectoryOfUnzippedProjectDumpFile;
    }

    private void unzipProjectDump() throws DumpFileAccessException {
        try {
            Zip.unzipFile((String)this.projectDumpFile.getAbsolutePath(), (String)this.rootDirectoryOfUnzippedProjectDumpFile.getAbsolutePath());
        }
        catch (IOException ioE) {
            logger.error("Can't unzip project dump file (" + this.projectDumpFile.getName() + ") into temp directory (" + this.rootDirectoryOfUnzippedProjectDumpFile.getAbsolutePath() + ").", (Throwable)ioE);
            this.state = 1;
            throw new DumpFileAccessException((Exception)ioE);
        }
    }

    private EOVersionFileContent readVersionFile() throws DumpFileAccessException {
        File versionFile = new File(this.rootDirectoryOfUnzippedProjectDumpFile, "versions.xml");
        EncodableObjectBase eo = this.readVersionFromFile(versionFile);
        if (eo instanceof EOVersionFileContent) {
            return (EOVersionFileContent)eo;
        }
        return null;
    }

    protected abstract EncodableObjectBase readVersionFromFile(File var1) throws DumpFileAccessException;

    protected void checkState() throws DumpFileAccessException {
        if (this.state == 1) {
            throw new DumpFileAccessException("Calling a method on this ProjectDumpFileAccess is not possible, because it is in an error state. At least one exception should have been thrown earlier (e.g. by the constructor).");
        }
        if (this.state == 4) {
            throw new DumpFileAccessException("Calling this method is not possible, because this ProjectDumpFileAccess is in the wrong state (e.g. disposed).");
        }
    }
}

