/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.sequences;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.links.ILinkedItemDeletionListener;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.CardinalityNN;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkTypeLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.LinkType;
import com.arcway.cockpit.frame.client.project.core.locking.ILockTypeProvider;
import com.arcway.cockpit.frame.client.project.core.locking.LockTypeProvider;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.cockpit.frame.client.project.sequences.IFrameSequencerManager;
import com.arcway.cockpit.frame.client.project.sequences.ISequencer;
import com.arcway.cockpit.frame.client.project.sequences.Sequencer;
import com.arcway.cockpit.frame.client.project.sequences.modifications.DataTypeWithSequenceChanges;
import com.arcway.cockpit.frame.client.project.sequences.modifications.SequenceModificationsForProjectView;
import com.arcway.cockpit.frame.shared.ILockable;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class SequencerManager
implements IFrameSequencerManager,
ILinkedItemDeletionListener,
IProjectCloseListener {
    public static final String linkTypeID_prefix = "data_sequences_";
    private final Map<String, ILinkTypeLinkAccessFacade> linkFacades = new HashMap<String, ILinkTypeLinkAccessFacade>();
    private final Map<String, String> linkTypeIDs = new HashMap<String, String>();
    private final IFrameProjectAgent projectAgent;
    private final Map<ICockpitProjectData, Map<ICockpitDataType, Sequencer>> sequencers = new HashMap<ICockpitProjectData, Map<ICockpitDataType, Sequencer>>();

    public SequencerManager(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    @Override
    public void objectDeleted(ICockpitProjectData deletedData) {
        this.objectDeleted(deletedData, deletedData.getTypeID());
    }

    @Override
    public void objectDeleted(ICockpitProjectData deletedData, String cockpitTypeID) {
        this.sequencers.remove(deletedData);
        this.removeFromSortings(deletedData.getUID(), cockpitTypeID);
    }

    @Override
    public void objectMoved(ICockpitProjectData movedData, ICockpitProjectData oldParent, ICockpitProjectData newParent) {
        this.objectMoved(movedData, oldParent, newParent, movedData.getTypeID());
    }

    @Override
    public void objectMoved(ICockpitProjectData movedData, ICockpitProjectData oldParent, ICockpitProjectData newParent, String cockpitTypeID) {
        if (oldParent != null && !oldParent.equals(newParent)) {
            this.removeFromSortings(movedData.getUID(), cockpitTypeID);
        }
    }

    private void removeFromSortings(String dataUID, String dataTypeID) {
        ILinkTypeLinkAccessFacade linkFacade = this.linkFacades.get(dataTypeID);
        if (linkFacade != null) {
            SequencerManager.removeElementFromSorting(linkFacade, dataUID);
        }
    }

    public void construct() {
        for (ICockpitDataType dataType : FrameDataTypes.getDataTypesWithNaturalOrder()) {
            String typeIDForLinkType = dataType.getCockpitDataTypeID();
            String linkTypeID = linkTypeID_prefix + dataType.getCockpitDataTypeID();
            String displayName = NLS.bind((String)Messages.getString("SequenceManager.SequenceLinkDisplayNamePrefix"), (Object)dataType.getDisplayName());
            LinkType linkType = new LinkType(linkTypeID, displayName, typeIDForLinkType, typeIDForLinkType, new CardinalityNN(), "frame", null, false, false);
            ILinkTypeLinkAccessFacade linkFacade = this.projectAgent.getLinkManager().registerLinkType(linkType);
            this.linkFacades.put(dataType.getCockpitDataTypeID(), linkFacade);
            this.linkTypeIDs.put(dataType.getCockpitDataTypeID(), linkTypeID);
        }
        this.projectAgent.getLinkManager().addDeletionListener(this);
        this.projectAgent.addProjectCloseListener(this);
    }

    @Override
    public ISequencer getSequencer(IAttributeOwner parent, Collection<ILockTypeProvider> lockTypeProviders, ICockpitDataType dataType) {
        Sequencer sequencer;
        Map<ICockpitDataType, Sequencer> sequencersForParent = this.sequencers.get(parent);
        if (sequencersForParent == null) {
            sequencersForParent = new HashMap<ICockpitDataType, Sequencer>();
            this.sequencers.put((ICockpitProjectData)parent, sequencersForParent);
        }
        if ((sequencer = sequencersForParent.get(dataType)) == null) {
            ILinkTypeLinkAccessFacade linkFacade = this.linkFacades.get(dataType.getCockpitDataTypeID());
            String linkTypeID = this.linkTypeIDs.get(dataType.getCockpitDataTypeID());
            sequencer = new Sequencer(parent, dataType, this.projectAgent, linkFacade, linkTypeID);
            sequencersForParent.put(dataType, sequencer);
        }
        sequencer.setLockTypeProviders(lockTypeProviders);
        return sequencer;
    }

    @Override
    public ISequencer getSequencer(IAttributeOwner parent, String lockType, ICockpitDataType dataType) {
        LockTypeProvider lockTypeProvider = new LockTypeProvider((ILockable)parent, lockType);
        return this.getSequencer(parent, Collections.singleton(lockTypeProvider), dataType);
    }

    public void asynchronouseUpdateStarted() {
        for (Map<ICockpitDataType, Sequencer> sequencersForParent : this.sequencers.values()) {
            this.asynchronouseUpdateStarted(sequencersForParent.values());
        }
    }

    public void asynchronouseUpdateEnded() {
        for (Map<ICockpitDataType, Sequencer> sequencersForParent : this.sequencers.values()) {
            this.asynchronouseUpdateEnded(sequencersForParent.values());
        }
    }

    @Override
    public ILocalModificationContainer getLocalModificationsForProjectView() {
        ArrayList<DataTypeWithSequenceChanges> modifiedDataTypes = new ArrayList<DataTypeWithSequenceChanges>(this.linkTypeIDs.entrySet().size());
        for (Map.Entry<String, String> entry : this.linkTypeIDs.entrySet()) {
            if (!this.projectAgent.getLinkManager().hasModifiedLinks(entry.getValue())) continue;
            modifiedDataTypes.add(new DataTypeWithSequenceChanges(FrameDataTypes.getDataType(entry.getKey()).getDisplayName()));
        }
        if (!modifiedDataTypes.isEmpty()) {
            return new SequenceModificationsForProjectView(modifiedDataTypes.toArray(new DataTypeWithSequenceChanges[modifiedDataTypes.size()]));
        }
        return null;
    }

    private void asynchronouseUpdateEnded(Collection<Sequencer> sequencersForParent) {
        for (Sequencer sequencer : sequencersForParent) {
            sequencer.asynchronousUpdateEnded();
        }
    }

    private void asynchronouseUpdateStarted(Collection<Sequencer> sequencersForParent) {
        for (Sequencer sequencer : sequencersForParent) {
            sequencer.asynchronousUpdateStarted();
        }
    }

    @Override
    public void closeProject(IFrameProjectAgent projectAgent) {
        for (Map<ICockpitDataType, Sequencer> dataTypeWithSequencers : this.sequencers.values()) {
            this.destructSequencers(dataTypeWithSequencers.values());
        }
    }

    private void destructSequencers(Collection<Sequencer> sequencersToDestruct) {
        for (Sequencer sequencer : sequencersToDestruct) {
            sequencer.desctruct();
        }
    }

    protected static boolean removeElementFromSorting(ILinkTypeLinkAccessFacade linkFacade, String idOfElementToRemove) {
        boolean foundAndRemoved = false;
        String predecessor = null;
        for (EOLink link : linkFacade.getLinksForModuleDataItem(idOfElementToRemove)) {
            predecessor = link.getLinkableObjectUID();
            linkFacade.deleteLink(link);
            foundAndRemoved = true;
        }
        boolean isFirstSuccessor = true;
        Set<EOLink> successorLinkCollection = linkFacade.getLinksForLinkableObject(idOfElementToRemove);
        for (EOLink successorLink : successorLinkCollection) {
            linkFacade.deleteLink(successorLink);
            if (!isFirstSuccessor) continue;
            if (predecessor != null) {
                EOLink newSequenceLink = new EOLink(successorLink);
                if (!predecessor.equals(idOfElementToRemove)) {
                    newSequenceLink.setLinkableObjectUID(predecessor);
                } else {
                    newSequenceLink.setLinkableObjectUID(successorLink.getModuleDataUID());
                }
                linkFacade.addLink(newSequenceLink);
            }
            isFirstSuccessor = false;
        }
        return foundAndRemoved;
    }
}

