/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.planeditors;

import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.ObjectTypeCategoryChangeMenu;
import com.arcway.cockpit.frame.client.project.IPlanElement;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElementRW;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.OccurrenceList;
import com.arcway.cockpit.frame.client.project.editors.FMCAEditorDNDData;
import com.arcway.cockpit.frame.client.project.editors.IDNDURLTransfer;
import com.arcway.cockpit.frame.client.project.editors.IDropListener;
import com.arcway.cockpit.frame.client.project.editors.IFrameDropListener;
import com.arcway.cockpit.frame.client.project.editors.UniqueElementOccurrenceListTransfer;
import com.arcway.cockpit.frame.client.project.modules.IUniqueElementProjectionRequest;
import com.arcway.cockpit.frame.client.project.modules.ProjectionIdentifier;
import com.arcway.cockpit.frame.client.project.modules.ProjectionRequest;
import com.arcway.cockpit.frame.client.project.planagents.IInternalAbstractPlanAgentController;
import com.arcway.cockpit.frame.client.project.planagents.IInternalPlanAgentControllerExtension;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentProjectAgent;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentUniqueElementManager;
import com.arcway.cockpit.frame.client.project.planagents.OpenedPlan;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.frame.client.project.planagents.PlanDisplayParameters;
import com.arcway.cockpit.frame.client.project.planeditors.FMCAEditorMgrCommand;
import com.arcway.cockpit.frame.client.project.planeditors.FMCAEditorMgrCommandChangeDescriptionOfLocalElement;
import com.arcway.cockpit.frame.client.project.planeditors.FMCAEditorMgrCommandChangeDescriptionOfUEOccurrence;
import com.arcway.cockpit.frame.client.project.planeditors.FMCAEditorMgrCommandCreatePlanElements;
import com.arcway.cockpit.frame.client.project.planeditors.FMCAEditorMgrCommandCreateUniqueElementOccurrence;
import com.arcway.cockpit.frame.client.project.planeditors.FMCAEditorMgrCommandDeletePlanElements;
import com.arcway.cockpit.frame.client.project.planeditors.FMCAEditorMgrCommandMakeLocal;
import com.arcway.cockpit.frame.client.project.planeditors.FMCAEditorMgrCommandRenameLocalElement;
import com.arcway.cockpit.frame.client.project.planeditors.FMCAEditorMgrCommandRenameUEOccurrence;
import com.arcway.cockpit.frame.client.project.planeditors.FMCAEditorMgrCommandUnexecutable;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorManager;
import com.arcway.cockpit.frame.client.project.planeditors.PlanElement;
import com.arcway.cockpit.frame.client.project.planeditors.PlanElementToOccurrenceMapping;
import com.arcway.cockpit.frame.client.project.planeditors.projections.IProjectionReceiver;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementOccurrence;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.lib.eclipse.transfer.AbstractTransferAgentForMultipleObjectTransfer;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferContent;
import com.arcway.lib.eclipse.transfer.old.URLTransfer;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planagent.INameAndDescriptionAndCommentAndAspectID;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentExtension;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentStructuredPlanElement;
import com.arcway.planagent.controllinginterface.planeditor.IDNDFileTransfer;
import com.arcway.planagent.controllinginterface.planeditor.IDNDTextTransfer;
import com.arcway.planagent.controllinginterface.planeditor.IInvalidPlanElement;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorCommand;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerCommand;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerExtension;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorExtension;
import com.arcway.planagent.controllinginterface.planeditor.ISelectionRequest;
import com.arcway.planagent.controllinginterface.planeditor.PlanAgentPlanElementMapping;
import com.arcway.planagent.controllinginterface.planeditor.PlanAgentTimestamp;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightRequest;
import com.arcway.planagent.controllinginterface.planviewer.IPlanViewerExtension;
import com.arcway.planagent.controllinginterface.planviewer.IProjectionRequest;
import de.plans.lib.util.gui.IProgressDisplay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class PlanEditorControllerExtension
implements IInternalPlanAgentControllerExtension,
IPlanEditorControllerExtension,
IExternalPlanEditorControllerExtension,
IProjectionReceiver {
    private IPlanEditorExtension planEditorExtension;
    private IInternalAbstractPlanAgentController abstractPlanAgentController;
    private final PlanEditorManager planEditorManager;

    protected PlanEditorControllerExtension(PlanEditorManager planEditorManager) {
        this.planEditorManager = planEditorManager;
    }

    @Override
    public Integer getVersion() {
        return this.abstractPlanAgentController.getOpenedPlan().getVersionInteger();
    }

    @Override
    public PlanDisplayParameters getPlanDisplayParameters() {
        return this.abstractPlanAgentController.getOpenedPlan().getPlanDisplayParameters();
    }

    @Override
    public void updatePlanDisplayParameters(PlanDisplayParameters incomingPlanDisplayParameters) {
        OpenedPlan plan = this.abstractPlanAgentController.getOpenedPlan();
        PlanDisplayParameters planDisplayParameters = plan.getPlanDisplayParameters();
        planDisplayParameters.update(this.abstractPlanAgentController, (IPlanViewerExtension)this.planEditorExtension, incomingPlanDisplayParameters);
    }

    @Override
    public void setAbstractPlanAgentController(IInternalAbstractPlanAgentController abstractPlanAgentController) {
        assert (abstractPlanAgentController != null);
        this.abstractPlanAgentController = abstractPlanAgentController;
    }

    @Override
    public void setPlanAgentExtension(IPlanAgentExtension planAgentExtension) {
        assert (planAgentExtension != null);
        this.planEditorExtension = (IPlanEditorExtension)planAgentExtension;
        if (this.getWorkingMode() == 1) {
            this.editModeEntered();
        }
    }

    public int isDropOnPlanAllowed(int modesAllowed, int modeWished, Object data) {
        return 0;
    }

    public int isDropOnPlanElementAllowed(IPlanAgentPlanElement iPlanElement, int modesAllowed, int modeWished, Object data) {
        IDropListener dropListener = null;
        Object payLoad = null;
        if (this.abstractPlanAgentController.getOpenedPlan().isHistoric()) {
            return 0;
        }
        if (data != null && data instanceof FMCAEditorDNDData) {
            FMCAEditorDNDData fMCAEditorDNDData = (FMCAEditorDNDData)data;
            String sourceProjectUID = fMCAEditorDNDData.getSourceProjectUID();
            if (sourceProjectUID != null && sourceProjectUID.equals(this.getProjectAgent().getProjectUID())) {
                dropListener = fMCAEditorDNDData.getDropListener();
                payLoad = fMCAEditorDNDData.getPayLoad();
            }
        } else {
            payLoad = this.convertPayload(data);
            if (payLoad != null) {
                dropListener = this.getProjectAgent().getDNDManger();
            }
        }
        if (dropListener != null) {
            PlanElement planElement = new PlanElement(iPlanElement, this.getPlanUID(), this.getProjectAgent().getProjectUID());
            if (this.getUniqueElementMgr().isAssignedToUniqueElement(planElement)) {
                IUniqueElement uniqueElement = this.getUniqueElementMgr().getUniqueElementOfOccurrence(planElement);
                return dropListener.isDropOnUniqueElementAllowed(uniqueElement, modesAllowed, modeWished, payLoad);
            }
        }
        return 0;
    }

    public void dropOnPlan(int mode, Object data) {
    }

    public void dropOnPlanElement(IPlanAgentPlanElement iPlanElement, int modesAllowed, int mode, Object data) {
        boolean select;
        IDropListener dropListener = null;
        Object payLoad = null;
        if (data != null && data instanceof FMCAEditorDNDData) {
            FMCAEditorDNDData fMCAEditorDNDData = (FMCAEditorDNDData)data;
            String sourceProjectUID = fMCAEditorDNDData.getSourceProjectUID();
            if (sourceProjectUID != null && sourceProjectUID.equals(this.getProjectAgent().getProjectUID())) {
                dropListener = fMCAEditorDNDData.getDropListener();
                payLoad = fMCAEditorDNDData.getPayLoad();
            }
        } else {
            payLoad = this.convertPayload(data);
            if (payLoad != null) {
                dropListener = this.getProjectAgent().getDNDManger();
            }
        }
        assert (dropListener != null);
        PlanElement planElement = new PlanElement(iPlanElement, this.getPlanUID(), this.getProjectAgent().getProjectUID());
        assert (this.getUniqueElementMgr().isAssignedToUniqueElement(planElement));
        IUniqueElement uniqueElement = this.getUniqueElementMgr().getUniqueElementOfOccurrence(planElement);
        if (dropListener instanceof IFrameDropListener) {
            IFrameDropListener frameDropListener = (IFrameDropListener)dropListener;
            select = frameDropListener.dropOnUniqueElement(uniqueElement, planElement, mode, payLoad);
        } else {
            select = dropListener.dropOnUniqueElement(uniqueElement, modesAllowed, mode, payLoad);
        }
        if (select) {
            this.getWorkbenchPage().bringToTop((IWorkbenchPart)this.planEditorExtension.getEditorPart());
        }
    }

    private Object convertPayload(final Object editorFormat) {
        Object frameFormat = null;
        if (editorFormat instanceof IDNDTextTransfer) {
            frameFormat = new com.arcway.cockpit.frame.client.project.editors.IDNDTextTransfer(){

                @Override
                public String getText() {
                    return ((IDNDTextTransfer)editorFormat).getText();
                }
            };
        } else if (editorFormat instanceof IDNDFileTransfer) {
            frameFormat = new com.arcway.cockpit.frame.client.project.editors.IDNDFileTransfer(){

                @Override
                public String[] getFiles() {
                    return ((IDNDFileTransfer)editorFormat).getFiles();
                }
            };
        } else if (editorFormat instanceof com.arcway.planagent.controllinginterface.planeditor.IDNDURLTransfer) {
            frameFormat = new IDNDURLTransfer(){

                @Override
                public URLTransfer.URLType getURL() {
                    return ((com.arcway.planagent.controllinginterface.planeditor.IDNDURLTransfer)editorFormat).getURL();
                }
            };
        }
        return frameFormat;
    }

    public void renamePlanRequest(String newName, IPlanEditorCommand editorCommand) {
        FMCAEditorMgrCommandUnexecutable editorMgrCommand = new FMCAEditorMgrCommandUnexecutable(this);
        editorCommand.setMgrCommand((IPlanEditorControllerCommand)editorMgrCommand);
    }

    public void createPlanElementsRequest(List<? extends IPlanAgentPlanElement> planAgentPlanElements, Collection<? extends PlanAgentPlanElementMapping> planAgentPlanElementMapping, Collection<? extends MultipleObjectTransferContent> nativeContent, IPlanEditorCommand editorCommand) {
        List<IPlanElement> planElements = this.convertPlanAgentPlanElementsToPlanElements(planAgentPlanElements);
        List<? extends IUniqueElementOccurrence> originalOccurenceListOrNullForNone = this.getOriginalOccurenceListOrNullForNone(nativeContent);
        Collection<PlanElementToOccurrenceMapping> planElementMappingOrNullForNoMapping = this.convertPlanAgentPlanElementMappingToPlanElementMappingOrNullForNoMapping(planAgentPlanElementMapping, originalOccurenceListOrNullForNone);
        FMCAEditorMgrCommandCreatePlanElements editorMgrCommand = new FMCAEditorMgrCommandCreatePlanElements(this, planElements, planElementMappingOrNullForNoMapping);
        editorCommand.setMgrCommand((IPlanEditorControllerCommand)editorMgrCommand);
    }

    public void renamePlanElementRequest(IPlanAgentPlanElement iPlanElement, IPlanEditorCommand editorCommand) {
        PlanElement planElement = new PlanElement(iPlanElement, this.getPlanUID(), this.getProjectAgent().getProjectUID());
        IPlanAgentProjectAgent projectAgent = this.getProjectAgent();
        FMCAEditorMgrCommand editorMgrCommand = projectAgent.getPlanAgentUniqueElementManager().isAssignedToUniqueElement(planElement) ? new FMCAEditorMgrCommandRenameUEOccurrence(this, planElement) : new FMCAEditorMgrCommandRenameLocalElement(this, planElement);
        editorCommand.setMgrCommand((IPlanEditorControllerCommand)editorMgrCommand);
    }

    public void changePlanElementDescriptionRequest(IPlanAgentPlanElement iPlanElement, IPlanEditorCommand editorCommand) {
        PlanElement planElement = new PlanElement(iPlanElement, this.getPlanUID(), this.getProjectAgent().getProjectUID());
        IPlanAgentProjectAgent projectAgent = this.getProjectAgent();
        FMCAEditorMgrCommand editorMgrCommand = projectAgent.getPlanAgentUniqueElementManager().isAssignedToUniqueElement(planElement) ? new FMCAEditorMgrCommandChangeDescriptionOfUEOccurrence(this, planElement) : new FMCAEditorMgrCommandChangeDescriptionOfLocalElement(this, planElement);
        editorCommand.setMgrCommand((IPlanEditorControllerCommand)editorMgrCommand);
    }

    public void deletePlanElementsRequest(List<? extends IPlanAgentPlanElement> planAgentPlanElements, IPlanEditorCommand editorCommand) {
        List<IPlanElement> planElements = this.convertPlanAgentPlanElementsToPlanElements(planAgentPlanElements);
        FMCAEditorMgrCommandDeletePlanElements editorMgrCommand = new FMCAEditorMgrCommandDeletePlanElements(this, planElements);
        editorCommand.setMgrCommand((IPlanEditorControllerCommand)editorMgrCommand);
    }

    public Collection<MultipleObjectTransferContent> getNativeContentToAdd(List<? extends IPlanAgentPlanElement> planAgentPlanElements) {
        List<IPlanElement> planElements = this.convertPlanAgentPlanElementsToPlanElements(planAgentPlanElements);
        Object uniqueElementList = UniqueElementOccurrenceListTransfer.createListToTransfer(this.getProjectAgent(), planElements);
        MultipleObjectTransferContent nativeContent = new MultipleObjectTransferContent(uniqueElementList, (AbstractTransferAgentForMultipleObjectTransfer)UniqueElementOccurrenceListTransfer.getInstance());
        return Collections.singleton(nativeContent);
    }

    public void save(IProgressDisplay progressDisplay) {
        progressDisplay.beginQuantifiedTask(Messages.getString("PlanEditorControllerExtension.0"), 100, false);
        progressDisplay.reportQuantifiedProgress(0, Messages.getString("PlanEditorControllerExtension.1"));
        this.getProjectAgent().getPlanAgentUniqueElementManager().saveOccurenceAndRelationShipModifications(this);
        progressDisplay.reportQuantifiedProgress(50, Messages.getString("PlanEditorControllerExtension.2"));
        progressDisplay.reportQuantifiedProgress(100, null);
        progressDisplay.endTask();
    }

    @Override
    public void highlightElements(HighlightLevel highlightLevel, Collection<? extends IHighlightRequest> highlightRequest) {
        this.planEditorExtension.highlightPlanElements(highlightLevel, highlightRequest);
    }

    @Override
    public void selectElements(List<? extends ISelectionRequest> selectionRequests) {
        this.planEditorExtension.selectPlanElements(selectionRequests);
    }

    @Override
    public PlanAgentTimestamp getTimestamp() {
        return this.planEditorExtension.getTimestamp();
    }

    @Override
    public String getPlanUID() {
        return this.abstractPlanAgentController.getOpenedPlan().getPlanUID();
    }

    @Override
    public void setPlanElementName(Map<String, ? extends INameAndDescriptionAndCommentAndAspectID> planElementUID2newName) {
        this.abstractPlanAgentController.setPlanElementNames(planElementUID2newName);
    }

    public void setInvalidPlanElements(List<? extends IInvalidPlanElement> invalidPlanElements) {
        this.planEditorExtension.setInvalidPlanElements(invalidPlanElements);
    }

    @Override
    public int getWorkingMode() {
        return this.planEditorExtension.getWorkingMode();
    }

    @Override
    public Collection<? extends IPlanAgentStructuredPlanElement> getPlanStructure() {
        return this.abstractPlanAgentController.getPlanStructure();
    }

    @Override
    public void setWorkingMode(int targetWorkingMode) throws EXWriteAccessDeniedException {
        int sourceWorkingMode = this.getWorkingMode();
        this.planEditorExtension.setWorkingMode(targetWorkingMode, true);
        if (sourceWorkingMode != 1 && targetWorkingMode == 1) {
            this.editModeEntered();
        } else if (sourceWorkingMode == 1 && targetWorkingMode != 1) {
            this.editModeLeft();
        }
    }

    private void editModeEntered() {
        this.getProjectAgent().getPlanAgentUniqueElementManager().updateRelationshipsUnsaved(this, true);
    }

    private void editModeLeft() {
        this.getProjectAgent().getPlanAgentUniqueElementManager().discardOccurenceAndRelationShipModifications(this);
    }

    @Override
    public IEditorPart getEditorPart() {
        return this.planEditorExtension.getEditorPart();
    }

    public void executeCommand(IPlanEditorControllerCommand command, String label) {
        this.planEditorExtension.executeCommand(command, label);
    }

    @Override
    public IPlanAgentProjectAgent getProjectAgent() {
        return this.planEditorManager.getProjectAgent();
    }

    public IPlanAgentUniqueElementManager getUniqueElementMgr() {
        return this.getProjectAgent().getPlanAgentUniqueElementManager();
    }

    @Override
    public IPlan getPlan() {
        return this.abstractPlanAgentController.getOpenedPlan().getPlan();
    }

    @Override
    public PlanAgentManager getPlanAgentManager() {
        return this.planEditorManager.getPlanAgentManager();
    }

    @Override
    public boolean isDirty() {
        return this.planEditorExtension.getEditorPart().isDirty();
    }

    @Override
    public boolean isOld() {
        return this.abstractPlanAgentController.getOpenedPlan().isHistoric();
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        this.planEditorExtension.getEditorPart().doSave(monitor);
    }

    @Override
    public void closePlanAgent() {
        IEditorPart editorPart = this.planEditorExtension.getEditorPart();
        editorPart.getEditorSite().getPage().closeEditor(editorPart, false);
    }

    @Override
    public void project(List<? extends IProjectionRequest> projectionRequests, List<? extends IUniqueElementProjectionRequest> uniqueElementProjectionRequests) {
        assert (projectionRequests != null) : "projectionRequests can't be null";
        assert (uniqueElementProjectionRequests != null) : "uniqueElementProjectionRequests can't be null";
        String planUID = this.getPlanUID();
        ArrayList<? extends IProjectionRequest> completeProjectionRequestList = new ArrayList<IProjectionRequest>(projectionRequests);
        int i = 0;
        while (i < uniqueElementProjectionRequests.size()) {
            IUniqueElementProjectionRequest projectionRequest = uniqueElementProjectionRequests.get(i);
            OccurrenceList occurrences = this.getUniqueElementMgr().getUniqueElementOccurrences(projectionRequest.getUniqueElementUID());
            for (EOUniqueElementOccurrence occurance : occurrences.getUniqueElementOccurrencesOnPlan(planUID)) {
                ProjectionRequest request = new ProjectionRequest(occurance.getPlanElementUID(), projectionRequest.getProjection());
                completeProjectionRequestList.add(request);
            }
            ++i;
        }
        this.planEditorExtension.project(completeProjectionRequestList);
    }

    @Override
    public boolean hasProjection() {
        return this.planEditorExtension.hasProjectionRequest();
    }

    @Override
    public void planAgentClosed() {
        if (this.getWorkingMode() == 1) {
            this.editModeLeft();
        }
    }

    @Override
    public IWorkbenchPage getWorkbenchPage() {
        return this.planEditorExtension.getEditorPart().getSite().getPage();
    }

    @Override
    public void projectButtonPressed(ProjectionIdentifier projectionIdentifier, IWorkbenchPage page) {
        this.getProjectAgent().getPlanAgentModuleController().projectButtonPressed(projectionIdentifier, this, page);
    }

    @Override
    public void stopProjection() {
        this.getProjectAgent().stopProjectionButtonPressed(this);
        this.project(Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public void makeLocal(IUniqueElementOccurrence[] occurences) {
        FMCAEditorMgrCommandMakeLocal cmd = new FMCAEditorMgrCommandMakeLocal(this, occurences);
        this.executeCommand(cmd, "Deletion of an Unique Element Occurrence");
    }

    @Override
    public void makeUnique(IPlanElement planElement, IUniqueElement uniqueElement) {
        FMCAEditorMgrCommandCreateUniqueElementOccurrence cmd = new FMCAEditorMgrCommandCreateUniqueElementOccurrence(this, planElement, uniqueElement);
        this.executeCommand(cmd, "Creation of an Unique Element Occurrence");
    }

    @Override
    public void createUniqueElementOccurrence(IPlanElement planElement, IUniqueElement uniqueElement) {
        FMCAEditorMgrCommandCreateUniqueElementOccurrence cmd = new FMCAEditorMgrCommandCreateUniqueElementOccurrence(this, planElement, uniqueElement);
        this.executeCommand(cmd, "Creation of an Unique Element Occurrence");
    }

    @Override
    public void exchangeUniqueElementOccurrence(IPlanElement planElement, IUniqueElement newUniqueElement) {
        FMCAEditorMgrCommandCreateUniqueElementOccurrence cmd = new FMCAEditorMgrCommandCreateUniqueElementOccurrence(this, planElement, newUniqueElement);
        this.executeCommand(cmd, "Creation of an Unique Element Occurrence");
    }

    private List<IPlanElement> convertPlanAgentPlanElementsToPlanElements(List<? extends IPlanAgentPlanElement> planAgentElements) {
        ArrayList<IPlanElement> planElements = new ArrayList<IPlanElement>(planAgentElements.size());
        for (IPlanAgentPlanElement iPlanAgentPlanElement : planAgentElements) {
            planElements.add(new PlanElement(iPlanAgentPlanElement, this.getPlanUID(), this.getProjectAgent().getProjectUID()));
        }
        return planElements;
    }

    private List<? extends IUniqueElementOccurrence> getOriginalOccurenceListOrNullForNone(Collection<? extends MultipleObjectTransferContent> nativeContents) {
        List<? extends IUniqueElementOccurrence> originalOccurenceList = null;
        if (nativeContents != null) {
            boolean found = false;
            Iterator<? extends MultipleObjectTransferContent> i = nativeContents.iterator();
            while (!found && i.hasNext()) {
                MultipleObjectTransferContent nativeContent = i.next();
                if (!(nativeContent.getTransferAgent() instanceof UniqueElementOccurrenceListTransfer)) continue;
                originalOccurenceList = UniqueElementOccurrenceListTransfer.getOccurenceList(nativeContent.getObjectToTransfer(), this.getProjectAgent());
                found = true;
            }
        }
        return originalOccurenceList;
    }

    private Collection<PlanElementToOccurrenceMapping> convertPlanAgentPlanElementMappingToPlanElementMappingOrNullForNoMapping(Collection<? extends PlanAgentPlanElementMapping> planAgentPlanElementMapping, List<? extends IUniqueElementOccurrence> originalOccurencesOrNullForNone) {
        ArrayList<PlanElementToOccurrenceMapping> frameMapping;
        if (originalOccurencesOrNullForNone != null) {
            List<? extends IUniqueElementOccurrence> originalOccurences = originalOccurencesOrNullForNone;
            frameMapping = new ArrayList<PlanElementToOccurrenceMapping>(planAgentPlanElementMapping.size());
            for (PlanAgentPlanElementMapping planAgentPlanElementMapping2 : planAgentPlanElementMapping) {
                IPlanAgentPlanElement originalPlanAgentPlanElement = planAgentPlanElementMapping2.getOriginalPlanElement();
                IPlanAgentPlanElement createdPlanAgentPlanElement = planAgentPlanElementMapping2.getCreatedPlanElement();
                IUniqueElementOccurrence originalOccurence = this.getOriginalOccurence(originalPlanAgentPlanElement, originalOccurences);
                PlanElement createdPlanElement = new PlanElement(createdPlanAgentPlanElement, this.getPlanUID(), this.getProjectAgent().getProjectUID());
                PlanElementToOccurrenceMapping planElementMapping = new PlanElementToOccurrenceMapping(originalOccurence, createdPlanElement);
                frameMapping.add(planElementMapping);
            }
        } else {
            frameMapping = null;
        }
        return frameMapping;
    }

    private IUniqueElementOccurrence getOriginalOccurence(IPlanAgentPlanElement originalPlanAgentPlanElement, List<? extends IUniqueElementOccurrence> originalOccurences) {
        IUniqueElementOccurrence originalOccurence = null;
        Iterator<? extends IUniqueElementOccurrence> i = originalOccurences.iterator();
        while (originalOccurence == null && i.hasNext()) {
            IUniqueElementOccurrence occurence = i.next();
            if (!occurence.getPlanElementUID().equals(originalPlanAgentPlanElement.getPlanElementUID())) continue;
            originalOccurence = occurence;
        }
        return originalOccurence;
    }

    @Override
    public IUniqueElement findUniqueElement(IPlanAgentPlanElement planAgentPlanElement) {
        assert (planAgentPlanElement != null);
        PlanElement planElement = new PlanElement(planAgentPlanElement, this.getPlanUID(), this.getProjectAgent().getProjectUID());
        IPlanAgentProjectAgent projectAgent = this.getProjectAgent();
        IUniqueElement ce = projectAgent.getPlanAgentUniqueElementManager().isAssignedToUniqueElement(planElement) ? projectAgent.getPlanAgentUniqueElementManager().getUniqueElementOfOccurrence(planElement) : null;
        return ce;
    }

    public void doSaveTransaction(Runnable saveTransaction) {
        this.getProjectAgent().getModelTransactionManager().executeTransaction(saveTransaction);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public IEditorInput saveAsRequest() {
        return null;
    }

    @Override
    public boolean hasHighlightRequest(HighlightLevel highlightLevel) {
        return this.planEditorExtension.hasHighlightRequest(highlightLevel);
    }

    public void openPlanElement(IPlanAgentPlanElement iPlanElement) {
        PlanElement planElement = new PlanElement(iPlanElement, this.getPlanUID(), this.getProjectAgent().getProjectUID());
        if (this.getUniqueElementMgr().isAssignedToUniqueElement(planElement)) {
            IUniqueElement uniqueElement = this.getUniqueElementMgr().getUniqueElementOfOccurrence(planElement);
            this.getUniqueElementMgr().openPlanForUniqueElement(uniqueElement, this.getPlan(), this.getWorkbenchPage());
        }
    }

    public void updateToolTip(String planElementUID, String planElementName, String planElementDescription) {
        String toolTip = this.getPlanElementTooltip(planElementUID, planElementName, planElementDescription);
        this.planEditorExtension.setPlanElementTooltip(planElementUID, toolTip);
    }

    public void updateDecorators() {
        this.planEditorExtension.updateDecorators();
    }

    public String getPlanElementTooltip(IPlanAgentPlanElement planElement) {
        return this.getPlanElementTooltip(planElement.getPlanElementUID(), planElement.getPlanElementName(), planElement.getPlanElementDescription());
    }

    private String getPlanElementTooltip(String planElementUID, String planElementName, String planElementDescription) {
        IUniqueElementOccurrence occurence;
        String description;
        String toolTip = null;
        String name = planElementName;
        if (name != null && name.length() > 0) {
            toolTip = name;
        }
        if (((description = planElementDescription) == null || description.length() == 0) && (occurence = this.planEditorManager.getProjectAgent().getPlanAgentUniqueElementManager().getUniqueElementOccurrence1(this.getPlanUID(), planElementUID)) != null) {
            IUniqueElement uniqueElement = this.planEditorManager.getProjectAgent().getPlanAgentUniqueElementManager().getUniqueElement(occurence.getElementUID());
            description = uniqueElement.getDescription();
        }
        if (description != null && description.length() > 0) {
            toolTip = toolTip == null ? description : String.valueOf(toolTip) + "\n\n" + description;
        }
        return toolTip;
    }

    @Override
    public void planStructureChanged() {
        this.getProjectAgent().getPlanAgentUniqueElementManager().updateRelationshipsUnsaved(this, false);
    }

    public Image getDecorator(IPlanAgentPlanElement planElement) {
        return this.getDecorator(planElement.getPlanElementUID());
    }

    private Image getDecorator(String planElementUID) {
        IPlanAgentProjectAgent projectAgent;
        IUniqueElementOccurrence occurence;
        Image decorator = null;
        if (this.getWorkingMode() != 1 && (occurence = (projectAgent = this.planEditorManager.getProjectAgent()).getPlanAgentUniqueElementManager().getUniqueElementOccurrence1(this.getPlanUID(), planElementUID)) != null) {
            IPlan refiningPlan;
            IPlan thisPlan;
            IUniqueElement uniqueElement = projectAgent.getPlanAgentUniqueElementManager().getUniqueElement(occurence.getElementUID());
            Collection<? extends IPlan> refiningPlans = projectAgent.getUniqueElementRelationshipManager().getRefiningPlans(uniqueElement);
            boolean decorate = refiningPlans.size() == 0 ? false : (refiningPlans.size() == 1 ? !(thisPlan = this.getPlan()).equals(refiningPlan = refiningPlans.iterator().next()) : true);
            if (decorate) {
                decorator = Icons.getImageForRefinement();
            }
        }
        return decorator;
    }

    public IContributionItem getObjectTypeCategoryContributionItem(List<IPlanAgentPlanElement> planElements) {
        IPlanAgentUniqueElementManager ueMgr = this.getUniqueElementMgr();
        ArrayList<IUniqueElementRW> uniqueElements = new ArrayList<IUniqueElementRW>(planElements.size());
        String planUID = this.getPlanUID();
        String projectID = this.getProjectAgent().getProjectUID();
        for (IPlanAgentPlanElement singlePlanElement : planElements) {
            PlanElement planElement = new PlanElement(singlePlanElement, planUID, projectID);
            IUniqueElement uniqueElement = ueMgr.getUniqueElementOfOccurrence(planElement);
            if (uniqueElement instanceof IUniqueElementRW) {
                uniqueElements.add((IUniqueElementRW)uniqueElement);
                continue;
            }
            return null;
        }
        return new ObjectTypeCategoryChangeMenu("com.arcway.cockpit.uniqueelement", uniqueElements, this.getProjectAgent().getProjectUID());
    }

    public boolean isPlanElementTiedToUniqueElement(IPlanAgentPlanElement planAgentPlanElement) {
        PlanElement planElement = new PlanElement(planAgentPlanElement, this.getPlanUID(), this.getProjectAgent().getProjectUID());
        return this.getUniqueElementMgr().isAssignedToUniqueElement(planElement);
    }
}

