/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.planeditors;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.CreatePlanElementDialog;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IPlanElement;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.EXModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElementRW;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentProjectAgent;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentUniqueElementManager;
import com.arcway.cockpit.frame.client.project.planeditors.FMCAEditorMgrCommand;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.planagent.controllinginterface.planagent.NameAndDescriptionAndCommentAndAspectID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class FMCAEditorMgrCommandRenameUEOccurrence
extends FMCAEditorMgrCommand {
    private static final ILogger logger = Logger.getLogger(FMCAEditorMgrCommandRenameUEOccurrence.class);
    private static final int MODE_RENAMED_UE = 1;
    private static final int MODE_CREATED_AND_DELETED_OCCURRENCE = 2;
    private final IUniqueElement uniqueElement;
    private final IPlanElement planElement;
    private int mode = 0;
    private final String oldName;
    private String newName;
    private final String oldUniqueElementUID;
    private String newUniqueElementUID;
    private ObjectTypeCategoryID newCategoryID;
    private ObjectTypeCategoryID oldCategoryID;

    public FMCAEditorMgrCommandRenameUEOccurrence(IExternalPlanEditorControllerExtension controllerExtension, IPlanElement planElement) {
        super(controllerExtension);
        this.planElement = planElement;
        this.oldName = planElement.getPlanElementName();
        this.oldUniqueElementUID = this.getProjectAgent().getPlanAgentUniqueElementManager().getUniqueElementOccurence(planElement).getElementUID();
        this.uniqueElement = this.getProjectAgent().getPlanAgentUniqueElementManager().getUniqueElement(this.oldUniqueElementUID);
        this.oldCategoryID = this.uniqueElement.getCategoryID();
    }

    public boolean canExecuteInGeneral() {
        return true;
    }

    public boolean canExecuteNow() {
        IConstructionElementTypeDescription constructionElementType = ExtensionMgr.getDefault().getDefaultConstructionElementTypeDescription(this.planElement.getPlanElementTypeID());
        List<IUniqueElement> uniqueElementsOfType = this.getProjectAgent().getPlanAgentUniqueElementManager().getUniqueElements(constructionElementType.getConstructionElementTypeID());
        Shell parentShell = this.getPlanEditorControllerExtension().getWorkbenchPage().getWorkbenchWindow().getShell();
        CreatePlanElementDialog dialog = new CreatePlanElementDialog(parentShell, this.uniqueElement, uniqueElementsOfType, constructionElementType, this.planElement.getPlanElementName(), this.getProjectAgent(), 3);
        int answer = dialog.open();
        if (answer != 1) {
            IPlanAgentUniqueElementManager ueMgr = this.getProjectAgent().getPlanAgentUniqueElementManager();
            String choosenName = dialog.getElementName();
            IUniqueElement existingUE = ueMgr.getUniqueElement(choosenName, constructionElementType.getConstructionElementTypeID());
            this.newCategoryID = null;
            if (dialog.getObjectTypeCategory() != null) {
                this.newCategoryID = dialog.getObjectTypeCategory().getObjectTypeCategoryID();
            }
            if (existingUE != null && existingUE.getUID().equals(this.uniqueElement.getUID())) {
                if (!choosenName.equals(this.uniqueElement.getElementName())) {
                    this.mode = 1;
                    this.newName = choosenName;
                }
            } else if (existingUE != null) {
                this.mode = 2;
                this.newName = choosenName;
            } else {
                ArrayList<IModificationProblem> problems = new ArrayList<IModificationProblem>();
                if (answer == 16002) {
                    if (this.uniqueElement instanceof IUniqueElementRW) {
                        IUniqueElementRW rw = (IUniqueElementRW)this.uniqueElement;
                        Collection renameProblems = rw.checkGeneralAttributeModificationPermission(rw.getAttributeType(UniqueElementAttributeTypesProvider.ATTRID_DISPLAY_NAME));
                        problems.addAll(renameProblems);
                    }
                    if (problems.isEmpty()) {
                        this.mode = 1;
                        this.newName = choosenName;
                    }
                } else if (answer == 16001) {
                    IModificationProblem modProblem = ueMgr.checkUniqueElementCreationPermission(choosenName, constructionElementType.getConstructionElementTypeID(), true);
                    if (modProblem != null) {
                        problems.add(modProblem);
                    }
                    if (problems.isEmpty()) {
                        this.mode = 2;
                        this.newName = choosenName;
                    }
                }
                if (!problems.isEmpty()) {
                    IWorkbenchPage workbenchPage = this.getPlanEditorControllerExtension().getEditorPart().getSite().getPage();
                    ModificationProblemsDialog.showModificationProblemsDialog(problems, (Shell)workbenchPage.getWorkbenchWindow().getShell());
                }
            }
        }
        return this.mode != 0;
    }

    public boolean makesPlanRelatedChanges() {
        return true;
    }

    public void execute() {
        final EXModificationProblem[] es = new EXModificationProblem[1];
        this.getProjectAgent().getPropertyChangesListenerManager().runWithDeferredPropertyChangePropagation(new Runnable(){

            @Override
            public void run() {
                if (FMCAEditorMgrCommandRenameUEOccurrence.this.mode == 1) {
                    try {
                        if (!FMCAEditorMgrCommandRenameUEOccurrence.this.doesCategoryExist(FMCAEditorMgrCommandRenameUEOccurrence.this.newCategoryID)) {
                            FMCAEditorMgrCommandRenameUEOccurrence.this.newCategoryID = null;
                        }
                        FMCAEditorMgrCommandRenameUEOccurrence.this.renameUE(FMCAEditorMgrCommandRenameUEOccurrence.this.newName, FMCAEditorMgrCommandRenameUEOccurrence.this.newCategoryID);
                    }
                    catch (EXModificationProblem e) {
                        es[0] = e;
                    }
                } else if (FMCAEditorMgrCommandRenameUEOccurrence.this.mode == 2) {
                    IPlanAgentUniqueElementManager ueMgr = FMCAEditorMgrCommandRenameUEOccurrence.this.getProjectAgent().getPlanAgentUniqueElementManager();
                    IUniqueElement existingUE = ueMgr.getUniqueElement(FMCAEditorMgrCommandRenameUEOccurrence.this.newName, FMCAEditorMgrCommandRenameUEOccurrence.this.uniqueElement.getElementTypeID());
                    if (existingUE == null) {
                        try {
                            ueMgr.requestUniqueElementCreationPermission(FMCAEditorMgrCommandRenameUEOccurrence.this.newName, FMCAEditorMgrCommandRenameUEOccurrence.this.uniqueElement.getElementTypeID());
                        }
                        catch (EXModificationProblem e) {
                            es[0] = e;
                        }
                    }
                    if (es[0] == null) {
                        ueMgr.deleteUniqueElementOccurencesUnsaved(FMCAEditorMgrCommandRenameUEOccurrence.this.getPlanEditorControllerExtension(), Collections.singleton(FMCAEditorMgrCommandRenameUEOccurrence.this.planElement.getPlanElementUID()));
                        if (existingUE == null) {
                            try {
                                existingUE = ueMgr.createUniqueElement(FMCAEditorMgrCommandRenameUEOccurrence.this.newName, FMCAEditorMgrCommandRenameUEOccurrence.this.uniqueElement.getElementTypeID(), FMCAEditorMgrCommandRenameUEOccurrence.this.newCategoryID);
                            }
                            catch (EXModificationProblem e) {
                                es[0] = e;
                            }
                        }
                        if (es[0] == null && existingUE != null) {
                            try {
                                FMCAEditorMgrCommandRenameUEOccurrence.this.newUniqueElementUID = existingUE.getUID();
                                ueMgr.createUniqueElementOccurencesUnsaved(FMCAEditorMgrCommandRenameUEOccurrence.this.getPlanEditorControllerExtension(), Collections.singletonMap(FMCAEditorMgrCommandRenameUEOccurrence.this.planElement.getPlanElementUID(), FMCAEditorMgrCommandRenameUEOccurrence.this.newUniqueElementUID));
                                String description = existingUE.getDescription();
                                FMCAEditorMgrCommandRenameUEOccurrence.this.getPlanEditorControllerExtension().setPlanElementName(Collections.singletonMap(FMCAEditorMgrCommandRenameUEOccurrence.this.planElement.getPlanElementUID(), new NameAndDescriptionAndCommentAndAspectID(FMCAEditorMgrCommandRenameUEOccurrence.this.newName.trim(), description, null, null)));
                            }
                            catch (EXModificationProblem e) {
                                es[0] = e;
                            }
                        }
                    }
                }
            }
        });
        if (es[0] != null) {
            ModificationProblemsDialog problemsDialog = new ModificationProblemsDialog(es[0].getModificationProblems(), null, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            problemsDialog.open();
        }
    }

    private void renameUE(String nameToAssign, ObjectTypeCategoryID categoryIDToSet) throws EXModificationProblem {
        if (this.uniqueElement instanceof IUniqueElementRW) {
            IUniqueElementRW rw = (IUniqueElementRW)this.uniqueElement;
            Attribute newAttribute = new Attribute(UniqueElementAttributeTypesProvider.ATTRID_DISPLAY_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(nameToAssign, null, null));
            LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
            rw.requestAttributeModificationPermission(newAttribute, transactionController);
            Collection<IModificationProblem> problems = transactionController.execute();
            if (problems.isEmpty()) {
                try {
                    rw.setAttribute(newAttribute);
                    rw.setCategoryID(categoryIDToSet);
                }
                catch (EXNoPermission e) {
                    logger.error("could not execute", (Throwable)e);
                }
                catch (EXNoLock e) {
                    logger.error("could not execute", (Throwable)e);
                }
            } else {
                throw new EXModificationProblem(problems);
            }
        }
    }

    public boolean canUndoNow() {
        if (this.mode == 2) {
            IUniqueElement oldUE = this.getProjectAgent().getPlanAgentUniqueElementManager().getUniqueElement(this.oldUniqueElementUID);
            return oldUE != null;
        }
        if (this.mode == 1) {
            return this.doesCategoryExist(this.oldCategoryID);
        }
        return true;
    }

    public void undo() {
        final EXModificationProblem[] es = new EXModificationProblem[1];
        this.getProjectAgent().getPropertyChangesListenerManager().runWithDeferredPropertyChangePropagation(new Runnable(){

            @Override
            public void run() {
                if (FMCAEditorMgrCommandRenameUEOccurrence.this.mode == 1) {
                    try {
                        if (!FMCAEditorMgrCommandRenameUEOccurrence.this.doesCategoryExist(FMCAEditorMgrCommandRenameUEOccurrence.this.oldCategoryID)) {
                            FMCAEditorMgrCommandRenameUEOccurrence.this.oldCategoryID = null;
                        }
                        FMCAEditorMgrCommandRenameUEOccurrence.this.renameUE(FMCAEditorMgrCommandRenameUEOccurrence.this.oldName, FMCAEditorMgrCommandRenameUEOccurrence.this.oldCategoryID);
                    }
                    catch (EXModificationProblem e) {
                        es[0] = e;
                    }
                }
                if (FMCAEditorMgrCommandRenameUEOccurrence.this.mode == 2) {
                    IPlanAgentUniqueElementManager ueMgr = FMCAEditorMgrCommandRenameUEOccurrence.this.getProjectAgent().getPlanAgentUniqueElementManager();
                    ueMgr.deleteUniqueElementOccurencesUnsaved(FMCAEditorMgrCommandRenameUEOccurrence.this.getPlanEditorControllerExtension(), Collections.singleton(FMCAEditorMgrCommandRenameUEOccurrence.this.planElement.getPlanElementUID()));
                    try {
                        ueMgr.createUniqueElementOccurencesUnsaved(FMCAEditorMgrCommandRenameUEOccurrence.this.getPlanEditorControllerExtension(), Collections.singletonMap(FMCAEditorMgrCommandRenameUEOccurrence.this.planElement.getPlanElementUID(), FMCAEditorMgrCommandRenameUEOccurrence.this.oldUniqueElementUID));
                    }
                    catch (EXModificationProblem e) {
                        es[0] = e;
                    }
                    IUniqueElement oldUE = ueMgr.getUniqueElement(FMCAEditorMgrCommandRenameUEOccurrence.this.oldUniqueElementUID);
                    if (oldUE != null) {
                        String name = oldUE.getElementName();
                        String description = oldUE.getDescription();
                        FMCAEditorMgrCommandRenameUEOccurrence.this.getPlanEditorControllerExtension().setPlanElementName(Collections.singletonMap(FMCAEditorMgrCommandRenameUEOccurrence.this.planElement.getPlanElementUID(), new NameAndDescriptionAndCommentAndAspectID(name, description, null, null)));
                    } else {
                        throw new IllegalStateException();
                    }
                }
            }
        });
        if (es[0] != null) {
            ModificationProblemsDialog problemsDialog = new ModificationProblemsDialog(es[0].getModificationProblems(), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            problemsDialog.open();
        }
    }

    public void redo() {
        final EXModificationProblem[] es = new EXModificationProblem[1];
        this.getProjectAgent().getPropertyChangesListenerManager().runWithDeferredPropertyChangePropagation(new Runnable(){

            @Override
            public void run() {
                if (FMCAEditorMgrCommandRenameUEOccurrence.this.mode == 1) {
                    try {
                        if (!FMCAEditorMgrCommandRenameUEOccurrence.this.doesCategoryExist(FMCAEditorMgrCommandRenameUEOccurrence.this.newCategoryID)) {
                            FMCAEditorMgrCommandRenameUEOccurrence.this.newCategoryID = null;
                        }
                        FMCAEditorMgrCommandRenameUEOccurrence.this.renameUE(FMCAEditorMgrCommandRenameUEOccurrence.this.newName, FMCAEditorMgrCommandRenameUEOccurrence.this.newCategoryID);
                    }
                    catch (EXModificationProblem e) {
                        es[0] = e;
                    }
                }
                if (FMCAEditorMgrCommandRenameUEOccurrence.this.mode == 2) {
                    IPlanAgentUniqueElementManager ueMgr = FMCAEditorMgrCommandRenameUEOccurrence.this.getProjectAgent().getPlanAgentUniqueElementManager();
                    ueMgr.deleteUniqueElementOccurencesUnsaved(FMCAEditorMgrCommandRenameUEOccurrence.this.getPlanEditorControllerExtension(), Collections.singleton(FMCAEditorMgrCommandRenameUEOccurrence.this.planElement.getPlanElementUID()));
                    try {
                        ueMgr.createUniqueElementOccurencesUnsaved(FMCAEditorMgrCommandRenameUEOccurrence.this.getPlanEditorControllerExtension(), Collections.singletonMap(FMCAEditorMgrCommandRenameUEOccurrence.this.planElement.getPlanElementUID(), FMCAEditorMgrCommandRenameUEOccurrence.this.newUniqueElementUID));
                    }
                    catch (EXModificationProblem e) {
                        es[0] = e;
                    }
                    IUniqueElement newUE = ueMgr.getUniqueElement(FMCAEditorMgrCommandRenameUEOccurrence.this.newUniqueElementUID);
                    if (newUE != null) {
                        String name = newUE.getElementName();
                        String description = newUE.getDescription();
                        FMCAEditorMgrCommandRenameUEOccurrence.this.getPlanEditorControllerExtension().setPlanElementName(Collections.singletonMap(FMCAEditorMgrCommandRenameUEOccurrence.this.planElement.getPlanElementUID(), new NameAndDescriptionAndCommentAndAspectID(name, description, null, null)));
                    } else {
                        throw new IllegalStateException();
                    }
                }
            }
        });
        if (es[0] != null) {
            ModificationProblemsDialog problemsDialog = new ModificationProblemsDialog(es[0].getModificationProblems(), null, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            problemsDialog.open();
        }
    }

    private boolean doesCategoryExist(ObjectTypeCategoryID categoryID) {
        if (categoryID != null) {
            IPlanAgentProjectAgent agent = this.getProjectAgent();
            if (agent instanceof IFrameProjectAgent) {
                if (((IFrameProjectAgent)agent).getObjectTypeCategoriesManager().itemExists(categoryID.getUID())) {
                    return true;
                }
            } else assert (false) : "ProjectAgent is not of type IFrameProjectAgent.";
        }
        return false;
    }
}

