/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.offlinemode;

import com.arcway.cockpit.cockpitlib.client.files.FileContentProviderForXMLFilesWithFixContent;
import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.XMLFileAccessor;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectDataInterchangeEOFactory;
import com.arcway.cockpit.frame.client.project.offlinemode.OfflineDataContainer;
import com.arcway.cockpit.frame.client.project.offlinemode.OfflineModeManager;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.repository.cockpitadapter.EOWorkspaceInformation;
import com.arcway.repository.cockpitadapter.locks.EOPlatformLock;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class OfflineModeDataFileManager {
    private static final String OFFLINE_DATA_CONTAINER_FILE_NAME = "offlinedata.data";
    private static final String OFFLINE_DATA_ROLE_MAIN_DATA = "maindata";
    private static final String OFFLINE_DATA_ROLE_PF_COMMIT_INFO = "pfcommitinfo";
    private static final String OFFLINE_DATA_ROLE_PF_WORKSPACE_INFO = "pfwsinfo";
    private static final String OFFLINE_DATA_ROLE_PF_WSUID_LOCKS = "pfwsuidlocks";
    private static final String OFFLINE_DATA_ROLE_PF_LOCK_LOG = "pflocklog";
    private static final String OFFLINE_DATA_ROLE_USER_DATA = "userdata";
    private static final String OFFLINE_DATA_ROLE_ALL_SERVER_GROUPS = "servergroups";
    private static final String OFFLINE_DATA_ROLE_ALL_SERVER_USERS = "serveruser";
    private static final String OFFLINE_DATA_ROLE_ALL_PERMISSIONS = "allpermissions";
    private final IFrameProjectAgent projectAgent;
    private final XMLFileAccessor<EOList<EOList<? extends EncodableObjectBase>>> offlineDataFileAccessor;

    public OfflineModeDataFileManager(File projectRoot, IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
        File offlineDataFile = OfflineModeManager.getOfflineDataRelatedFile(OFFLINE_DATA_CONTAINER_FILE_NAME, projectAgent.getProjectRoot());
        this.offlineDataFileAccessor = new XMLFileAccessor(offlineDataFile, (IEncodableObjectFactory)ProjectDataInterchangeEOFactory.getDefault());
    }

    public void writeData(OfflineDataContainer offlineDataContainer) {
        ServerDataContainer serverDataContainer = offlineDataContainer.getServerDataContainer();
        EOList dataToWrite = new EOList();
        EOList mainData = new EOList(OFFLINE_DATA_ROLE_MAIN_DATA);
        EOList pfCommitInfo = new EOList(OFFLINE_DATA_ROLE_PF_COMMIT_INFO);
        EOList pfWSInfo = new EOList(OFFLINE_DATA_ROLE_PF_WORKSPACE_INFO);
        EOList pfWSUIDLocks = new EOList(OFFLINE_DATA_ROLE_PF_WSUID_LOCKS);
        EOList pfLockLog = new EOList(OFFLINE_DATA_ROLE_PF_LOCK_LOG);
        EOList userData = new EOList(OFFLINE_DATA_ROLE_USER_DATA);
        EOList allServerGroups = new EOList(OFFLINE_DATA_ROLE_ALL_SERVER_GROUPS);
        EOList allServerUser = new EOList(OFFLINE_DATA_ROLE_ALL_SERVER_USERS);
        EOList allPermissions = new EOList(OFFLINE_DATA_ROLE_ALL_PERMISSIONS);
        mainData.addAll(serverDataContainer.getMainData());
        pfCommitInfo.add(serverDataContainer.getCommitInformations());
        pfWSInfo.addAll(serverDataContainer.getWorkspaceInformations());
        Map<String, Collection<EOPlatformLock>> wsUID2Locks = serverDataContainer.getWorkspaceUID_locks();
        for (String wsUID : wsUID2Locks.keySet()) {
            EOList currentWSUID2Locks = new EOList(wsUID);
            currentWSUID2Locks.addAll(wsUID2Locks.get(wsUID));
            pfWSUIDLocks.add((EncodableObjectBase)currentWSUID2Locks);
        }
        pfLockLog.addAll(serverDataContainer.getLockLog());
        userData.add((EncodableObjectBase)offlineDataContainer.getUserData());
        allServerGroups.addAll(offlineDataContainer.getAllServerGroups());
        allServerUser.addAll(offlineDataContainer.getAllServerUsers());
        allPermissions.addAll(offlineDataContainer.getAllPermissions());
        dataToWrite.add((EncodableObjectBase)mainData);
        dataToWrite.add((EncodableObjectBase)pfCommitInfo);
        dataToWrite.add((EncodableObjectBase)pfWSInfo);
        dataToWrite.add((EncodableObjectBase)pfWSUIDLocks);
        dataToWrite.add((EncodableObjectBase)pfLockLog);
        dataToWrite.add((EncodableObjectBase)userData);
        dataToWrite.add((EncodableObjectBase)allServerGroups);
        dataToWrite.add((EncodableObjectBase)allServerUser);
        dataToWrite.add((EncodableObjectBase)allPermissions);
        this.offlineDataFileAccessor.write((IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent((EOEncodableObject)dataToWrite));
    }

    public OfflineDataContainer readData() throws IOException, EXDecoderException {
        EOList readData = (EOList)this.offlineDataFileAccessor.read();
        EOList mainData = new EOList();
        EOList pfCommitInfo = null;
        ArrayList<EOWorkspaceInformation> pfWSInfo = new ArrayList<EOWorkspaceInformation>();
        HashMap<String, Collection<EOPlatformLock>> pfWSUIDLocks = new HashMap<String, Collection<EOPlatformLock>>();
        ArrayList pfLockLog = new ArrayList();
        EOUserAndGroupAndPermissions userData = null;
        ArrayList allServerGroups = new ArrayList();
        ArrayList allServerUsers = new ArrayList();
        ArrayList allPermissions = new ArrayList();
        for (EOList currentList : readData) {
            if (currentList.getRole().equals(OFFLINE_DATA_ROLE_MAIN_DATA)) {
                mainData = currentList;
                continue;
            }
            if (currentList.getRole().equals(OFFLINE_DATA_ROLE_PF_COMMIT_INFO)) {
                pfCommitInfo = (EOList)currentList.getElements().iterator().next();
                continue;
            }
            if (currentList.getRole().equals(OFFLINE_DATA_ROLE_PF_WORKSPACE_INFO)) {
                pfWSInfo.addAll(currentList.getElements());
                continue;
            }
            if (currentList.getRole().equals(OFFLINE_DATA_ROLE_PF_WSUID_LOCKS)) {
                for (EOList listWSUID : currentList) {
                    pfWSUIDLocks.put(listWSUID.getRole(), listWSUID.getElements());
                }
                continue;
            }
            if (currentList.getRole().equals(OFFLINE_DATA_ROLE_PF_LOCK_LOG)) {
                pfLockLog = currentList.getElements();
                continue;
            }
            if (currentList.getRole().equals(OFFLINE_DATA_ROLE_USER_DATA)) {
                userData = (EOUserAndGroupAndPermissions)currentList.getElements().iterator().next();
                continue;
            }
            if (currentList.getRole().equals(OFFLINE_DATA_ROLE_ALL_SERVER_GROUPS)) {
                allServerGroups = currentList.getElements();
                continue;
            }
            if (currentList.getRole().equals(OFFLINE_DATA_ROLE_ALL_SERVER_USERS)) {
                allServerUsers = currentList.getElements();
                continue;
            }
            if (!currentList.getRole().equals(OFFLINE_DATA_ROLE_ALL_PERMISSIONS)) continue;
            allPermissions = currentList.getElements();
        }
        assert (pfCommitInfo != null);
        assert (userData != null);
        ServerDataContainer serverDataContainer = new ServerDataContainer(this.projectAgent, pfCommitInfo, pfWSInfo, pfWSUIDLocks, pfLockLog, (EOList<EOList<? extends EncodableObjectBase>>)mainData);
        return new OfflineDataContainer(serverDataContainer, userData, allServerGroups, allServerUsers, allPermissions);
    }

    public OfflineDataContainer cleanUpWithBackup() throws IOException, EXDecoderException {
        OfflineDataContainer offlineDataContainer = this.readData();
        this.cleanUp();
        return offlineDataContainer;
    }

    public void cleanUp() {
        this.offlineDataFileAccessor.write((IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent(null));
    }

    public boolean offlineDataFileExists() {
        return this.offlineDataFileAccessor.checkIfSourceEOIsNotNull();
    }
}

