/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.modules;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.DataLabelProviderAdapter;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.modules.ModuleInformation;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ModuleDataManager
implements IFrameDataManager {
    private final ModuleInformation module;
    private final String dataTypeID;
    private final IFrameProjectAgent projectAgent;
    private IDataLabelProvider dataLabelProvider;

    public ModuleDataManager(ModuleInformation module, String dataTypeID, IFrameProjectAgent projectAgent) {
        this.module = module;
        this.dataTypeID = dataTypeID;
        this.projectAgent = projectAgent;
    }

    @Override
    public void initializeBeforePermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public void initializeAfterPermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public void finishInitialization(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) {
    }

    @Override
    public String getLocalizedManagerName() {
        return this.module.getModuleName();
    }

    @Override
    public void discardLocalModifications() {
        this.module.getModuleFacade().discardLocalModifications1();
    }

    @Override
    public boolean hasLocalModifications() {
        return this.module.getModuleFacade().hasChangesForProject() || this.projectAgent.getModuleLinkManager().hasProjectWideChangesForModule(this.module.getModuleID());
    }

    @Override
    public boolean handlesDataType(String cockpitDataTypeID) {
        return cockpitDataTypeID.equals(this.dataTypeID);
    }

    @Override
    public boolean itemExistsOnServer(String cockpitDataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICockpitProjectData getCockpitProjectData(String cockpitDataUID) {
        return this.module.getModuleFacade().getCockpitProjectData(this.dataTypeID, cockpitDataUID);
    }

    @Override
    public IDataLabelProvider getDataLabelProvider() {
        if (this.dataLabelProvider == null) {
            this.dataLabelProvider = new DataLabelProviderAdapter(this.module.getModuleFacade().getDataLabelProvider());
        }
        return this.dataLabelProvider;
    }

    @Override
    public ILocalModificationContainer[] getLocalModifications(boolean displayableOnly) {
        return new ILocalModificationContainer[]{this.module.getModuleFacade().getLocalModification(displayableOnly)};
    }

    @Override
    public Map<IAttributeTypeDataType, Collection<IAttribute>> getAllAttributesOfType(Class<? extends IAttributeTypeDataType> dataTypeClazz) {
        return this.module.getModuleFacade().getAllAttributesOfType(dataTypeClazz);
    }

    @Override
    public Collection<IAttributeType> getAllAttributeTypes(Class<? extends IAttributeTypeDataType> dataTypeClass) {
        return this.module.getModuleFacade().getAllAttributeTypes(dataTypeClass);
    }

    @Override
    public void requestDataDeletePermission(IAttributeOwner data, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem("not implemented", "not implemented"));
    }

    @Override
    public void deleteData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applySynchronousModification(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public void applyAsynchronousModifications(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public Collection<? extends IAttributeOwner> getData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAttributeOwner getParent(IAttributeOwner child) {
        IAttributeOwner parent = this.module.getModuleFacade().getParent((ICockpitProjectData)child);
        if (parent == null) {
            parent = this.projectAgent.getProjectMetaDataManager().getProject();
        }
        return parent;
    }

    @Override
    public Collection<? extends IAttributeOwner> getChildren(IAttributeOwner parent) {
        Collection<IAttributeOwner> children = this.projectAgent.getProjectMetaDataManager().getProject().equals(parent) ? this.module.getModuleFacade().getChildren(null) : this.module.getModuleFacade().getChildren((ICockpitProjectData)parent);
        return children != null ? children : Collections.emptyList();
    }

    @Override
    public void requestAddPermission(String name, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes, IAttributeOwner parent, boolean forImport, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem("Functionality is not implemented.", "Can not add data."));
    }

    @Override
    public Collection<? extends IAttributeOwner> addData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new EXNoPermission("Permission was not requested!");
    }

    @Override
    public boolean managesChildrenForType(String chilDataTypeID) {
        return false;
    }

    @Override
    public void requestMovePermission(IAttributeOwner dataToMove, IAttributeOwner newParent, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem("Functionality is not implemented.", "Can not move data."));
    }

    @Override
    public void moveData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission, EXNoLock {
        throw new EXNoPermission("Permission was not requested!");
    }

    @Override
    public void dataModified(IAttributeOwner modifiedData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IFrameDataRW> importDataFromEO(List<EOFrameData> eos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocallyModified(String dataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocallyAdded(String dataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFrameDataFactory getDataFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAttributeOwner getServerState(String dataUID) {
        throw new UnsupportedOperationException();
    }

    public IAttributeOwner getAttributeOwner(ICockpitProjectData data) {
        return this.module.getModuleFacade().getAttributeOwner(data);
    }

    public IAttributeOwner getParent(ICockpitProjectData child) {
        IAttributeOwner parent = this.module.getModuleFacade().getParent(child);
        if (parent == null) {
            parent = this.projectAgent.getProjectMetaDataManager().getProject();
        }
        return parent;
    }

    @Override
    public void visitAllAttributeOwnerRWs(IAttributeOwnerRW.IVisitor visitor) {
        this.module.getModuleFacade().visitAllAttributeOwnerRWs(visitor);
    }

    @Override
    public IAttributeTypesProvider getAttributeTypesProvider() {
        throw new UnsupportedOperationException();
    }
}

