/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version5;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOProject_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOUniqueElement_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.V5_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version5.HistoricProjectDumpView_5_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version0.HistoricProjectFileView_0_;
import com.arcway.cockpit.frame.client.project.migration.migrators.version5.UniqueElementEmptyNameMigratorDataPath;
import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForBasicEOs;
import de.plans.lib.xml.encoding.MessageDataFactoryForUnknownEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import java.util.Collections;
import java.util.List;

public class UniqueElementEmptyNameMigrator
implements ICockpitMigrator {
    public static final String KEY = "com.arcway.cockpit.frame.client.project.migration.migrators.version5.uniqueelementemptynamemigrator";
    private static final IEncodableObjectFactory EOFACTORY = new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{MessageDataFactoryForBasicEOs.getDefault(), V5_EOFactory.getDefault(), MessageDataFactoryForUnknownEOs.getDefault()});

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 5;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.emptyList();
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return V5_EOFactory.getDefault();
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        HistoricProjectDumpView_5_ dumpView = (HistoricProjectDumpView_5_)projectDump;
        for (EOProject_V5 project : dumpView.getAllProjects()) {
            EOList uniqueElementList;
            try {
                uniqueElementList = (EOList)dumpView.readDataFile(project, "uniqueElements.xml", null, EOFACTORY);
            }
            catch (EXDecoderException e) {
                throw new MigrationFailedException(e);
            }
            UniqueElementEmptyNameMigratorDataPath.migrateUniqueElementList((EOList<EOUniqueElement_V5>)uniqueElementList);
            dumpView.writeDataFile(project, "uniqueElements.xml", null, (EncodableObjectBase)uniqueElementList);
        }
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateImport(projectFile);
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateImport(projectFile);
    }

    private void migrateImport(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        HistoricProjectFileView_0_ fileView = (HistoricProjectFileView_0_)projectFile;
        try {
            EOList<? extends EncodableObjectBase> uniqueElementList = fileView.getDataList("unique elements");
            UniqueElementEmptyNameMigratorDataPath.migrateUniqueElementList(uniqueElementList);
        }
        catch (ProjectFileAccess.ProjectFileAccessException e) {
            throw new MigrationFailedException(e);
        }
    }
}

