/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version3;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLinkDataContainer_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLocalLink_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version3.HistoricProjectDumpView_3_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version3.HistoricProjectFileView_3_;
import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForBasicEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LocalLinkMigrator
implements ICockpitMigrator {
    public static final String KEY = "LocalLinkMigrator";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 3;
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.emptyList();
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateProjectFile(projectFile);
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateProjectFile(projectFile);
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        try {
            HistoricProjectDumpView_3_ historicView = (HistoricProjectDumpView_3_)projectDump;
            List<EOProject_V0> projects = historicView.getAllProjects();
            if (projects != null) {
                for (EOProject_V0 currentProject : projects) {
                    EncodableObjectBase linkData = historicView.readDataFile(currentProject, "links.xml", null, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault()}));
                    if (!(linkData instanceof EOLinkDataContainer_V0)) continue;
                    EOList newLinkData = new EOList();
                    newLinkData.addAll((Collection)((EOLinkDataContainer_V0)linkData).getLinks());
                    boolean success = historicView.writeDataFile(currentProject, "links.xml", null, (EncodableObjectBase)newLinkData);
                    if (success) continue;
                    throw new MigrationFailedException("Could not write back links");
                }
            }
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException(e);
        }
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    private void migrateProjectFile(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        HistoricProjectFileView_3_ historicView = (HistoricProjectFileView_3_)projectFile;
        try {
            EOList<? extends EncodableObjectBase> linkData = historicView.getDataList("links");
            if (linkData != null) {
                ArrayList<EncodableObjectBase> linksToBeRemoved = new ArrayList<EncodableObjectBase>(linkData.size());
                for (EncodableObjectBase link : linkData) {
                    if (!(link instanceof EOLocalLink_V0)) continue;
                    linksToBeRemoved.add(link);
                }
                linkData.removeAll(linksToBeRemoved);
            }
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            throw new MigrationFailedException("Can't access project file.", pfaE);
        }
    }
}

