/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.docgenerator.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.DocGenConfigurationPerReport;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.ModuleDocGenConfiguration;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.AbstractFilterItemProvider;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFilterItemProvider2
extends AbstractFilterItemProvider {
    public AbstractFilterItemProvider2(String moduleID, String name) {
        super(moduleID, name);
    }

    public AbstractFilterItemProvider2() {
    }

    public final List<AbstractFilter> getFilters() {
        ArrayList<AbstractFilter> filterList = new ArrayList<AbstractFilter>();
        for (IFilterItem filterItem : this.getItems()) {
            filterList.add(filterItem.getFilter());
        }
        return filterList;
    }

    @Override
    public final boolean hasActiveFilters() {
        boolean hasActiveFilter = false;
        for (IFilterItem filterItem : this.getItems()) {
            if (!filterItem.getFilter().isActive()) continue;
            hasActiveFilter = true;
            break;
        }
        return hasActiveFilter;
    }

    protected String getModuleDocumentationConfigurationItemID() {
        return this.getModuleID();
    }

    @Override
    public final void update(DocGenConfigurationPerReport configuration) {
        ModuleDocGenConfiguration moduleConfig = new ModuleDocGenConfiguration(this.getModuleDocumentationConfigurationItemID(), configuration);
        for (IFilterItem filterItem : this.getItems()) {
            AbstractFilter filter = filterItem.getFilter();
            filter.setActive(moduleConfig.isFilterActive(filter.getFilterID()));
            String value = moduleConfig.getFilterSettings(filter.getFilterID());
            if (value == null) continue;
            filter.setFilterValue(value);
        }
    }

    @Override
    public final void writeToConfiguration(DocGenConfigurationPerReport configuration) {
        ModuleDocGenConfiguration moduleConfig = new ModuleDocGenConfiguration(this.getModuleDocumentationConfigurationItemID(), configuration);
        for (IFilterItem filterItem : this.getItems()) {
            AbstractFilter filter = filterItem.getFilter();
            moduleConfig.addFilterSettings(filter.getFilterID(), filter.isActive(), filter.getFilterValue());
        }
    }
}

