/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.datainterchange.plan;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.FileMetaInformationItem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.IDataTypeWithFile;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlanRW;
import com.arcway.cockpit.frame.client.project.datainterchange.plan.EOPlanDataContainerTransferContent;
import com.arcway.cockpit.frame.client.project.datainterchange.plan.PlanDataTransferAgent;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.frame.client.project.planagents.planimportexport.IExternalPlanImporterExporterControllerExtension;
import com.arcway.cockpit.frame.client.project.planviewers.planexport.PlanExporter;
import com.arcway.cockpit.frame.shared.message.EOPlan;
import com.arcway.lib.eclipse.graphics.SWTDefaultRendererManager;
import com.arcway.lib.eclipse.graphics.SWTImageData;
import com.arcway.lib.eclipse.transfer.AbstractTransferAgentForMultipleObjectTransfer;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferAgent;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferContent;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.FileResource;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import de.plans.lib.util.gui.IProgressDisplay;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class PlanCopyManager {
    private static final ILogger logger = Logger.getLogger(PlanCopyManager.class);
    private final Clipboard clipboard;

    public PlanCopyManager(Display display) {
        this.clipboard = new Clipboard(display);
        MultipleObjectTransferAgent.getInstance().getSupportedTypes();
        FileTransfer.getInstance().getSupportedTypes();
    }

    public void copy(Collection<IPlan> plansToCopy, IProgressDisplay progressDisplay, boolean cut) {
        ArrayList<MultipleObjectTransferContent> contents = new ArrayList<MultipleObjectTransferContent>();
        ArrayList<String> fileNames = new ArrayList<String>();
        int number = 0;
        for (IPlan plan : plansToCopy) {
            ++number;
            try {
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(plan.getProjectUID());
                IExternalPlanImporterExporterControllerExtension ctrl = projectAgent.getPlanImporterExporterManager().getExporter(plan, progressDisplay);
                IPlanRW planRW = projectAgent.getFrameSectionManager().getPlanRW(plan.getUID());
                if (planRW == null) continue;
                Map<EOString, Tuple<EOString, EOString>> additionalFiles = this.getFileNames(plan, projectAgent);
                EOPlanDataContainerTransferContent content = new EOPlanDataContainerTransferContent((EOPlan)planRW.createEncodableObject(), ctrl.getPlanFile(), additionalFiles, cut);
                MultipleObjectTransferContent transferContent = new MultipleObjectTransferContent((Object)content, (AbstractTransferAgentForMultipleObjectTransfer)PlanDataTransferAgent.getInstance());
                contents.add(transferContent);
                File emfFile = PlanCopyManager.getImgFile(planRW, ".emf");
                PlanExporter.createEMFImage(plan, true, null, emfFile, progressDisplay);
                fileNames.add(emfFile.getAbsolutePath());
            }
            catch (PlanAgentManager.EXPlanAgentLaunchException e) {
                logger.error("could not execute", (Throwable)e);
            }
            catch (EXWriteAccessDeniedException e) {
                logger.error("could not execute", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("could not execute", (Throwable)e);
            }
        }
        String[] files = new String[number];
        int i = 0;
        while (i < number) {
            files[i] = (String)fileNames.get(i);
            ++i;
        }
        this.clipboard.setContents(new Object[]{contents, files}, new Transfer[]{MultipleObjectTransferAgent.getInstance(), FileTransfer.getInstance()});
    }

    public void copyAsPNG(Collection<IPlan> plansToCopy, IProgressDisplay progressDisplay) {
        ArrayList<String> fileNames = new ArrayList<String>();
        int number = 0;
        ImageData imageData = null;
        for (IPlan plan : plansToCopy) {
            ++number;
            try {
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(plan.getProjectUID());
                IPlanRW planRW = projectAgent.getFrameSectionManager().getPlanRW(plan.getUID());
                if (planRW == null) continue;
                File pngFile = PlanCopyManager.getImgFile(planRW, ".png");
                double max_page_size = 160.0;
                double resolution = 300.0;
                int maxWidthOrHeightInPixel = (int)Math.round(max_page_size * 0.03937007874015748 * resolution);
                PlanExporter.createPNGImage(plan, resolution, maxWidthOrHeightInPixel, true, null, pngFile, progressDisplay);
                fileNames.add(pngFile.getAbsolutePath());
                if (number > 1) {
                    imageData = null;
                    continue;
                }
                imageData = ((SWTImageData)SWTDefaultRendererManager.getDefaultSWTRendererOfCurrentThread().loadImageData((IStreamResource)new FileResource(pngFile))).getWrappedSWTImageData();
            }
            catch (Exception e) {
                logger.error("could not execute", (Throwable)e);
            }
        }
        String[] files = new String[number];
        int i = 0;
        while (i < number) {
            files[i] = (String)fileNames.get(i);
            ++i;
        }
        if (imageData != null) {
            this.clipboard.setContents(new Object[]{imageData, files}, new Transfer[]{ImageTransfer.getInstance(), FileTransfer.getInstance()});
        } else {
            this.clipboard.setContents(new Object[]{files}, new Transfer[]{FileTransfer.getInstance()});
        }
    }

    private Map<EOString, Tuple<EOString, EOString>> getFileNames(IPlan plan, IFrameProjectAgent projectAgent) {
        HashMap<EOString, Tuple<EOString, EOString>> fileNames = new HashMap<EOString, Tuple<EOString, EOString>>();
        for (IAttribute attribute : plan.getAllAttributes()) {
            IAttributeType attributeType = plan.getAttributeType(attribute.getAttributeTypeID());
            IAttributeTypeDataType attributeTypeDataType = attributeType.getDataType();
            if (!(attributeTypeDataType instanceof IDataTypeWithFile)) continue;
            IDataTypeWithFile dataType = (IDataTypeWithFile)attributeTypeDataType;
            try {
                FileID fileID = (FileID)attribute.getAttributeValue();
                FileMetaInformationItem metaInformation = projectAgent.getFilesManager().getFileMetaInformation(fileID);
                File file = dataType.getFileCopy(fileID);
                if (file == null) continue;
                fileNames.put(new EOString(attributeType.getAttributeTypeID().getUID()), (Tuple<EOString, EOString>)new Tuple((Object)new EOString(file.getAbsolutePath()), (Object)new EOString(metaInformation.getOriginalFileName())));
            }
            catch (ServerNotAvailableException e) {
                logger.error("Could not retrieve plan file", (Throwable)e);
            }
            catch (EXServerException e) {
                logger.error("Could not retrieve plan file", (Throwable)e);
            }
            catch (LoginCanceledException e) {
                logger.error("Could not retrieve plan file", (Throwable)e);
            }
            catch (UnknownServerException e) {
                logger.error("Could not retrieve plan file", (Throwable)e);
            }
            catch (ExPrematureEndOfTransfer e) {
                logger.error("Could not retrieve plan file", (Throwable)e);
            }
        }
        return fileNames;
    }

    private static File getImgFile(IPlan plan, String extension) throws IOException {
        assert (plan != null);
        String planName = plan.getPlanName();
        String fileName = FileHelper.convertStringToPortableFileName((String)planName);
        File wmfFile = File.createTempFile(fileName, extension);
        wmfFile.deleteOnExit();
        return wmfFile;
    }
}

